/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.interaction.forms;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.interaction.annotations.DualWidget;
import it.stefanochizzolini.clown.documents.interaction.annotations.Widget;
import it.stefanochizzolini.clown.documents.interaction.forms.ButtonField;
import it.stefanochizzolini.clown.documents.interaction.forms.Field;
import it.stefanochizzolini.clown.documents.interaction.forms.FieldWidgets;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.util.EnumSet;

public class RadioButton
extends ButtonField {
    public RadioButton(String name, DualWidget[] widgets, String value) {
        super(name, widgets[0]);
        EnumSet<Field.FlagsEnum> flags = this.getFlags();
        flags.add(Field.FlagsEnum.Radio);
        flags.add(Field.FlagsEnum.NoToggleToOff);
        this.setFlags(flags);
        FieldWidgets fieldWidgets = this.getWidgets();
        int index = 1;
        int length = widgets.length;
        while (index < length) {
            fieldWidgets.add(widgets[index]);
            ++index;
        }
        this.setValue(value);
    }

    public RadioButton(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public RadioButton clone(Document context) {
        throw new NotImplementedException();
    }

    public boolean isToggleable() {
        return !this.getFlags().contains((Object)Field.FlagsEnum.NoToggleToOff);
    }

    public void setToggleable(boolean value) {
        EnumSet<Field.FlagsEnum> flags = this.getFlags();
        if (value) {
            flags.remove((Object)Field.FlagsEnum.NoToggleToOff);
        } else {
            flags.add(Field.FlagsEnum.NoToggleToOff);
        }
        this.setFlags(flags);
    }

    @Override
    public void setValue(Object value) {
        PdfName selectedWidgetName = new PdfName((String)value);
        boolean selected = false;
        for (Widget widget : this.getWidgets()) {
            PdfName currentState;
            if (((DualWidget)widget).getWidgetName().equals(value)) {
                selected = true;
                currentState = selectedWidgetName;
            } else {
                currentState = PdfName.Off;
            }
            ((PdfDictionary)widget.getBaseDataObject()).put(PdfName.AS, currentState);
        }
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.V, selected ? selectedWidgetName : null);
    }
}

