/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.interaction.forms;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.interaction.annotations.Widget;
import it.stefanochizzolini.clown.documents.interaction.forms.CheckBox;
import it.stefanochizzolini.clown.documents.interaction.forms.ComboBox;
import it.stefanochizzolini.clown.documents.interaction.forms.FieldActions;
import it.stefanochizzolini.clown.documents.interaction.forms.FieldWidgets;
import it.stefanochizzolini.clown.documents.interaction.forms.ListBox;
import it.stefanochizzolini.clown.documents.interaction.forms.PushButton;
import it.stefanochizzolini.clown.documents.interaction.forms.RadioButton;
import it.stefanochizzolini.clown.documents.interaction.forms.SignatureField;
import it.stefanochizzolini.clown.documents.interaction.forms.TextField;
import it.stefanochizzolini.clown.files.File;
import it.stefanochizzolini.clown.objects.PdfAtomicObject;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfInteger;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfObjectWrapper;
import it.stefanochizzolini.clown.objects.PdfReference;
import it.stefanochizzolini.clown.objects.PdfString;
import it.stefanochizzolini.clown.objects.PdfTextString;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.util.ArrayList;
import java.util.EnumSet;

public abstract class Field
extends PdfObjectWrapper<PdfDictionary> {
    public static final Field wrap(PdfReference reference) {
        int fieldFlagsValue;
        if (reference == null) {
            return null;
        }
        PdfDictionary dataObject = (PdfDictionary)reference.getDataObject();
        PdfName fieldType = (PdfName)dataObject.get(PdfName.FT);
        PdfInteger fieldFlags = (PdfInteger)dataObject.get(PdfName.Ff);
        int n = fieldFlagsValue = fieldFlags == null ? 0 : (Integer)fieldFlags.getRawValue();
        if (fieldType.equals(PdfName.Btn)) {
            if ((fieldFlagsValue & FlagsEnum.Pushbutton.getCode()) > 0) {
                return new PushButton(reference);
            }
            if ((fieldFlagsValue & FlagsEnum.Radio.getCode()) > 0) {
                return new RadioButton(reference);
            }
            return new CheckBox(reference);
        }
        if (fieldType.equals(PdfName.Tx)) {
            return new TextField(reference);
        }
        if (fieldType.equals(PdfName.Ch)) {
            if ((fieldFlagsValue & FlagsEnum.Combo.getCode()) > 0) {
                return new ComboBox(reference);
            }
            return new ListBox(reference);
        }
        if (fieldType.equals(PdfName.Sig)) {
            return new SignatureField(reference);
        }
        return null;
    }

    protected Field(PdfName fieldType, String name, Widget widget) {
        this(widget.getBaseObject());
        PdfDictionary baseDataObject = (PdfDictionary)this.getBaseDataObject();
        baseDataObject.put(PdfName.FT, fieldType);
        baseDataObject.put(PdfName.T, new PdfTextString(name));
    }

    protected Field(PdfDirectObject baseObject) {
        super(baseObject, null);
    }

    @Override
    public Field clone(Document context) {
        throw new NotImplementedException();
    }

    public FieldActions getActions() {
        PdfDirectObject actionsObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.AA);
        if (actionsObject == null) {
            return null;
        }
        return new FieldActions(actionsObject, this.getContainer());
    }

    public Object getDefaultValue() {
        PdfAtomicObject defaultValueObject = (PdfAtomicObject)File.resolve(this.getInheritableAttribute(PdfName.DV));
        if (defaultValueObject == null) {
            return null;
        }
        return defaultValueObject.getValue();
    }

    public EnumSet<FlagsEnum> getFlags() {
        PdfInteger flagsObject = (PdfInteger)File.resolve(this.getInheritableAttribute(PdfName.Ff));
        if (flagsObject == null) {
            return EnumSet.noneOf(FlagsEnum.class);
        }
        return FlagsEnum.toEnumSet((Integer)flagsObject.getRawValue());
    }

    public FieldWidgets getWidgets() {
        PdfDirectObject widgetsObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.Kids);
        if (widgetsObject == null) {
            return new FieldWidgets(this.getBaseObject(), null, this);
        }
        return new FieldWidgets(widgetsObject, this.getContainer(), this);
    }

    public Widget getWidget() {
        return new Widget(this.getBaseObject(), null);
    }

    public String getFullName() {
        ArrayList<String> partialNames = new ArrayList<String>();
        PdfDictionary parent = (PdfDictionary)this.getBaseDataObject();
        while (parent != null) {
            partialNames.add((String)((PdfTextString)parent.get(PdfName.T)).getValue());
            parent = (PdfDictionary)File.resolve(parent.get(PdfName.Parent));
        }
        StringBuilder buffer = new StringBuilder();
        int index = partialNames.size() - 1;
        while (index >= 0) {
            buffer.append((String)partialNames.get(index));
            if (index > 0) {
                buffer.append(".");
            }
            --index;
        }
        return buffer.toString();
    }

    public String getName() {
        return (String)((PdfTextString)((PdfDictionary)this.getBaseDataObject()).get(PdfName.T)).getValue();
    }

    public Object getValue() {
        PdfAtomicObject valueObject = (PdfAtomicObject)File.resolve(this.getInheritableAttribute(PdfName.V));
        if (valueObject == null) {
            return null;
        }
        return valueObject.getValue();
    }

    public boolean isExportable() {
        return !this.getFlags().contains((Object)FlagsEnum.NoExport);
    }

    public boolean isReadOnly() {
        return this.getFlags().contains((Object)FlagsEnum.ReadOnly);
    }

    public boolean isRequired() {
        return this.getFlags().contains((Object)FlagsEnum.Required);
    }

    public void setActions(FieldActions value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.AA, value.getBaseObject());
    }

    public void setExportable(boolean value) {
        EnumSet<FlagsEnum> flags = this.getFlags();
        if (value) {
            flags.remove((Object)FlagsEnum.NoExport);
        } else {
            flags.add(FlagsEnum.NoExport);
        }
        this.setFlags(flags);
    }

    public void setFlags(EnumSet<FlagsEnum> value) {
        PdfDictionary baseDataObject = (PdfDictionary)this.getBaseDataObject();
        PdfInteger entry = (PdfInteger)baseDataObject.get(PdfName.Ff);
        if (entry == null) {
            entry = (PdfInteger)this.getInheritableAttribute(PdfName.Ff).clone(this.getFile());
            baseDataObject.put(PdfName.Ff, entry);
        }
        entry.setRawValue(FlagsEnum.toInt(value));
    }

    public void setName(String value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.T, new PdfTextString(value));
    }

    public void setReadOnly(boolean value) {
        EnumSet<FlagsEnum> flags = this.getFlags();
        if (value) {
            flags.add(FlagsEnum.ReadOnly);
        } else {
            flags.remove((Object)FlagsEnum.ReadOnly);
        }
        this.setFlags(flags);
    }

    public void setRequired(boolean value) {
        EnumSet<FlagsEnum> flags = this.getFlags();
        if (value) {
            flags.add(FlagsEnum.Required);
        } else {
            flags.remove((Object)FlagsEnum.Required);
        }
        this.setFlags(flags);
    }

    public void setValue(Object value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.V, new PdfString((String)value));
    }

    protected PdfDirectObject getInheritableAttribute(PdfName key) {
        PdfDictionary dictionary = (PdfDictionary)this.getBaseDataObject();
        do {
            PdfDirectObject entry;
            if ((entry = dictionary.get(key)) == null) continue;
            return entry;
        } while ((dictionary = (PdfDictionary)File.resolve(dictionary.get(PdfName.Parent))) != null);
        if (key.equals(PdfName.Ff)) {
            return new PdfInteger(0);
        }
        return null;
    }

    public static enum FlagsEnum {
        ReadOnly(1),
        Required(2),
        NoExport(4),
        Multiline(4096),
        Password(8192),
        NoToggleToOff(16384),
        Radio(32768),
        Pushbutton(65536),
        Combo(131072),
        Edit(262144),
        Sort(524288),
        FileSelect(0x100000),
        MultiSelect(0x200000),
        DoNotSpellCheck(0x400000),
        DoNotScroll(0x800000),
        Comb(0x1000000),
        RichText(0x2000000),
        RadiosInUnison(0x2000000),
        CommitOnSelChange(0x4000000);

        private final int code;

        public static int toInt(EnumSet<FlagsEnum> flags) {
            int flagsMask = 0;
            for (FlagsEnum flag : flags) {
                flagsMask |= flag.getCode();
            }
            return flagsMask;
        }

        public static EnumSet<FlagsEnum> toEnumSet(int flagsMask) {
            EnumSet<FlagsEnum> flags = EnumSet.noneOf(FlagsEnum.class);
            FlagsEnum[] flagsEnumArray = FlagsEnum.values();
            int n = flagsEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                FlagsEnum flag = flagsEnumArray[n2];
                if ((flagsMask & flag.getCode()) > 0) {
                    flags.add(flag);
                }
                ++n2;
            }
            return flags;
        }

        private FlagsEnum(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

