/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.interaction.annotations;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.Page;
import it.stefanochizzolini.clown.documents.interaction.annotations.Annotation;
import it.stefanochizzolini.clown.documents.interaction.annotations.AnnotationActions;
import it.stefanochizzolini.clown.documents.interaction.annotations.AppearanceCharacteristics;
import it.stefanochizzolini.clown.documents.interaction.annotations.WidgetActions;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.awt.geom.Rectangle2D;
import java.util.EnumSet;

public class Widget
extends Annotation {
    public Widget(Page page, Rectangle2D box) {
        super(page.getDocument(), PdfName.Widget, box, page);
        EnumSet<Annotation.FlagsEnum> flags = this.getFlags();
        flags.add(Annotation.FlagsEnum.Print);
        this.setFlags(flags);
    }

    public Widget(PdfDirectObject baseObject, PdfIndirectObject container) {
        super(baseObject, container);
    }

    @Override
    public Widget clone(Document context) {
        throw new NotImplementedException();
    }

    @Override
    public AnnotationActions getActions() {
        PdfDirectObject actionsObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.AA);
        if (actionsObject == null) {
            return null;
        }
        return new WidgetActions(this, actionsObject, this.getContainer());
    }

    public AppearanceCharacteristics getAppearanceCharacteristics() {
        PdfDirectObject appearanceObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.MK);
        if (appearanceObject == null) {
            return null;
        }
        return new AppearanceCharacteristics(appearanceObject, this.getContainer());
    }

    public HighlightModeEnum getHighlightMode() {
        PdfName highlightModeObject = (PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.H);
        if (highlightModeObject == null) {
            return HighlightModeEnum.Invert;
        }
        return HighlightModeEnum.get(highlightModeObject);
    }

    public void setAppearanceCharacteristics(AppearanceCharacteristics value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.MK, value.getBaseObject());
    }

    public void setHighlightMode(HighlightModeEnum value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.H, value.getCode());
    }

    public static enum HighlightModeEnum {
        None(PdfName.N),
        Invert(PdfName.I),
        Outline(PdfName.O),
        Push(PdfName.P),
        Toggle(PdfName.T);

        private final PdfName code;

        public static HighlightModeEnum get(PdfName value) {
            HighlightModeEnum[] highlightModeEnumArray = HighlightModeEnum.values();
            int n = highlightModeEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                HighlightModeEnum mode = highlightModeEnumArray[n2];
                if (mode.getCode().equals(value)) {
                    return mode;
                }
                ++n2;
            }
            return null;
        }

        private HighlightModeEnum(PdfName code) {
            this.code = code;
        }

        public PdfName getCode() {
            return this.code;
        }
    }
}

