/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.interaction.annotations;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.Page;
import it.stefanochizzolini.clown.documents.interaction.annotations.Shape;
import it.stefanochizzolini.clown.objects.IPdfNumber;
import it.stefanochizzolini.clown.objects.PdfArray;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfReal;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public abstract class VertexShape
extends Shape {
    protected VertexShape(Page page, Rectangle2D box, PdfName subtype) {
        super(page, box, subtype);
    }

    protected VertexShape(PdfDirectObject baseObject, PdfIndirectObject container) {
        super(baseObject, container);
    }

    @Override
    public VertexShape clone(Document context) {
        throw new NotImplementedException();
    }

    public List<Point2D> getVertices() {
        PdfArray verticesObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Vertices);
        ArrayList<Point2D> vertices = new ArrayList<Point2D>();
        double pageHeight = this.getPage().getBox().getHeight();
        int index = 0;
        int length = verticesObject.size();
        while (index < length) {
            double x = ((IPdfNumber)((Object)verticesObject.get(index))).getNumberValue();
            double y = pageHeight - ((IPdfNumber)((Object)verticesObject.get(index + 1))).getNumberValue();
            vertices.add(new Point2D.Double(x, y));
            index += 2;
        }
        return vertices;
    }

    public void setVertices(List<Point2D> value) {
        PdfArray verticesObject = new PdfArray();
        double pageHeight = this.getPage().getBox().getHeight();
        for (Point2D vertex : value) {
            verticesObject.add(new PdfReal(vertex.getX()));
            verticesObject.add(new PdfReal(pageHeight - vertex.getY()));
        }
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Vertices, verticesObject);
    }
}

