/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.interaction.annotations;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.Page;
import it.stefanochizzolini.clown.documents.interaction.annotations.Annotation;
import it.stefanochizzolini.clown.objects.IPdfNumber;
import it.stefanochizzolini.clown.objects.PdfArray;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfReal;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class Scribble
extends Annotation {
    public Scribble(Page page, Rectangle2D box, List<List<Point2D>> paths) {
        super(page.getDocument(), PdfName.Ink, box, page);
        this.setPaths(paths);
    }

    public Scribble(PdfDirectObject baseObject, PdfIndirectObject container) {
        super(baseObject, container);
    }

    @Override
    public Scribble clone(Document context) {
        throw new NotImplementedException();
    }

    public List<List<Point2D>> getPaths() {
        PdfArray pathsObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.InkList);
        ArrayList<List<Point2D>> paths = new ArrayList<List<Point2D>>();
        double pageHeight = this.getPage().getBox().getHeight();
        int pathIndex = 0;
        int pathLength = pathsObject.size();
        while (pathIndex < pathLength) {
            PdfArray pathObject = (PdfArray)pathsObject.get(pathIndex);
            ArrayList<Point2D.Double> path = new ArrayList<Point2D.Double>();
            int pointIndex = 0;
            int pointLength = pathObject.size();
            while (pointIndex < pointLength) {
                path.add(new Point2D.Double(((IPdfNumber)((Object)pathObject.get(pointIndex))).getNumberValue(), pageHeight - ((IPdfNumber)((Object)pathObject.get(pointIndex + 1))).getNumberValue()));
                pointIndex += 2;
            }
            paths.add(path);
            ++pathIndex;
        }
        return paths;
    }

    public void setPaths(List<List<Point2D>> value) {
        PdfArray pathsObject = new PdfArray();
        double pageHeight = this.getPage().getBox().getHeight();
        for (List<Point2D> path : value) {
            PdfArray pathObject = new PdfArray();
            for (Point2D point : path) {
                pathObject.add(new PdfReal(point.getX()));
                pathObject.add(new PdfReal(pageHeight - point.getY()));
            }
            pathsObject.add(pathObject);
        }
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.InkList, pathsObject);
    }
}

