/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.interaction.annotations;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.Page;
import it.stefanochizzolini.clown.documents.fileSpecs.FileSpec;
import it.stefanochizzolini.clown.documents.interaction.annotations.Annotation;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.awt.geom.Rectangle2D;

public class FileAttachment
extends Annotation {
    public FileAttachment(Page page, Rectangle2D box, FileSpec fileSpec) {
        super(page.getDocument(), PdfName.FileAttachment, box, page);
        this.setFileSpec(fileSpec);
    }

    public FileAttachment(PdfDirectObject baseObject, PdfIndirectObject container) {
        super(baseObject, container);
    }

    @Override
    public FileAttachment clone(Document context) {
        throw new NotImplementedException();
    }

    public FileSpec getFileSpec() {
        return new FileSpec(((PdfDictionary)this.getBaseDataObject()).get(PdfName.FS), this.getContainer(), null);
    }

    public IconTypeEnum getIconType() {
        PdfName nameObject = (PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Name);
        if (nameObject == null) {
            return IconTypeEnum.PushPin;
        }
        return IconTypeEnum.get(nameObject);
    }

    public void setFileSpec(FileSpec value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.FS, value.getBaseObject());
    }

    public void setIconType(IconTypeEnum value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Name, value.getCode());
    }

    public static enum IconTypeEnum {
        Graph(PdfName.Graph),
        PaperClip(PdfName.Paperclip),
        PushPin(PdfName.PushPin),
        Tag(PdfName.Tag);

        private final PdfName code;

        public static IconTypeEnum get(PdfName value) {
            IconTypeEnum[] iconTypeEnumArray = IconTypeEnum.values();
            int n = iconTypeEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                IconTypeEnum iconType = iconTypeEnumArray[n2];
                if (iconType.getCode().equals(value)) {
                    return iconType;
                }
                ++n2;
            }
            return null;
        }

        private IconTypeEnum(PdfName code) {
            this.code = code;
        }

        public PdfName getCode() {
            return this.code;
        }
    }
}

