/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.interaction.actions;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.fileSpecs.FileSpec;
import it.stefanochizzolini.clown.documents.interaction.actions.Action;
import it.stefanochizzolini.clown.documents.interaction.actions.OptionsEnum;
import it.stefanochizzolini.clown.objects.PdfBoolean;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfObjectWrapper;
import it.stefanochizzolini.clown.objects.PdfString;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.util.EnumSet;

public class Launch
extends Action {
    public Launch(Document context) {
        super(context, PdfName.Launch);
    }

    Launch(PdfDirectObject baseObject, PdfIndirectObject container) {
        super(baseObject, container);
    }

    @Override
    public Launch clone(Document context) {
        throw new NotImplementedException();
    }

    public FileSpec getFileSpec() {
        PdfDirectObject fileSpecObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.F);
        if (fileSpecObject == null) {
            return null;
        }
        return new FileSpec(fileSpecObject, this.getContainer(), null);
    }

    public EnumSet<OptionsEnum> getOptions() {
        EnumSet<OptionsEnum> options = EnumSet.noneOf(OptionsEnum.class);
        PdfDirectObject optionObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.NewWindow);
        if (optionObject != null && ((Boolean)((PdfBoolean)optionObject).getValue()).booleanValue()) {
            options.add(OptionsEnum.NewWindow);
        }
        return options;
    }

    public WinParametersObject getWinParameters() {
        PdfDictionary parametersObject = (PdfDictionary)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Win);
        if (parametersObject == null) {
            return null;
        }
        return new WinParametersObject(parametersObject, this.getContainer());
    }

    public void setFileSpec(FileSpec value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.F, value.getBaseObject());
    }

    public void setOptions(EnumSet<OptionsEnum> value) {
        if (value.contains((Object)OptionsEnum.NewWindow)) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.NewWindow, PdfBoolean.True);
        } else if (value.contains((Object)OptionsEnum.SameWindow)) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.NewWindow, PdfBoolean.False);
        } else {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.NewWindow);
        }
    }

    public void setWinParameters(WinParametersObject value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Win, value.getBaseObject());
    }

    public static class WinParametersObject
    extends PdfObjectWrapper<PdfDictionary> {
        public WinParametersObject(Document context, String fileName) {
            super(context.getFile(), new PdfDictionary());
            this.setFileName(fileName);
        }

        public WinParametersObject(Document context, String fileName, OperationEnum operation) {
            this(context, fileName);
            this.setOperation(operation);
        }

        public WinParametersObject(Document context, String fileName, String parameterString) {
            this(context, fileName);
            this.setParameterString(parameterString);
        }

        private WinParametersObject(PdfDirectObject baseObject, PdfIndirectObject container) {
            super(baseObject, container);
        }

        @Override
        public WinParametersObject clone(Document context) {
            throw new NotImplementedException();
        }

        public String getDefaultDirectory() {
            PdfString defaultDirectoryObject = (PdfString)((PdfDictionary)this.getBaseDataObject()).get(PdfName.D);
            if (defaultDirectoryObject == null) {
                return null;
            }
            return (String)defaultDirectoryObject.getValue();
        }

        public String getFileName() {
            return (String)((PdfString)((PdfDictionary)this.getBaseDataObject()).get(PdfName.F)).getValue();
        }

        public OperationEnum getOperation() {
            PdfString operationObject = (PdfString)((PdfDictionary)this.getBaseDataObject()).get(PdfName.O);
            if (operationObject == null) {
                return OperationEnum.Open;
            }
            return OperationEnum.get(operationObject);
        }

        public String getParameterString() {
            PdfString parameterStringObject = (PdfString)((PdfDictionary)this.getBaseDataObject()).get(PdfName.P);
            if (parameterStringObject == null) {
                return null;
            }
            return (String)parameterStringObject.getValue();
        }

        public void setDefaultDirectory(String value) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.D, new PdfString(value));
        }

        public void setFileName(String value) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.F, new PdfString(value));
        }

        public void setOperation(OperationEnum value) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.O, value.getCode());
        }

        public void setParameterString(String value) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.P, new PdfString(value));
        }

        public static enum OperationEnum {
            Open(new PdfString("open")),
            Print(new PdfString("print"));

            private final PdfString code;

            public static OperationEnum get(PdfString value) {
                OperationEnum[] operationEnumArray = OperationEnum.values();
                int n = operationEnumArray.length;
                int n2 = 0;
                while (n2 < n) {
                    OperationEnum operation = operationEnumArray[n2];
                    if (operation.getCode().equals(value)) {
                        return operation;
                    }
                    ++n2;
                }
                return null;
            }

            private OperationEnum(PdfString code) {
                this.code = code;
            }

            public PdfString getCode() {
                return this.code;
            }
        }
    }
}

