/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.contents.objects;

import it.stefanochizzolini.clown.documents.contents.ContentScanner;
import it.stefanochizzolini.clown.documents.contents.IContentContext;
import it.stefanochizzolini.clown.documents.contents.fonts.Font;
import it.stefanochizzolini.clown.documents.contents.objects.Operation;
import it.stefanochizzolini.clown.documents.contents.objects.ShowTextToNextLine;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.List;

public abstract class ShowText
extends Operation {
    protected ShowText(String operator) {
        super(operator);
    }

    protected ShowText(String operator, PdfDirectObject ... operands) {
        super(operator, operands);
    }

    protected ShowText(String operator, List<PdfDirectObject> operands) {
        super(operator, operands);
    }

    @Override
    public void applyTo(ContentScanner.GraphicsState state) {
        this.scan(state, null);
    }

    public abstract byte[] getText();

    public List<Object> getValue() {
        return Arrays.asList(new Object[]{this.getText()});
    }

    public void scan(ContentScanner.GraphicsState state, IScanner textScanner) {
        IContentContext context = state.getScanner().getContentContext();
        double contextHeight = context.getBox().getHeight();
        Font font = state.font;
        double fontSize = state.fontSize;
        double scale = state.scale / 100.0;
        double scaledFactor = Font.getScalingFactor(fontSize) * scale;
        double wordSpace = state.wordSpace * scale;
        double charSpace = state.charSpace * scale;
        double[] tm = state.tm;
        double[] ctm = state.ctm;
        boolean fontScanned = false;
        if (this instanceof ShowTextToNextLine) {
            Double newCharSpace;
            ShowTextToNextLine showTextToNextLine = (ShowTextToNextLine)this;
            Double newWordSpace = showTextToNextLine.getWordSpace();
            if (newWordSpace != null) {
                if (textScanner == null) {
                    state.wordSpace = newWordSpace;
                }
                wordSpace = newWordSpace * scale;
            }
            if ((newCharSpace = showTextToNextLine.getCharSpace()) != null) {
                if (textScanner == null) {
                    state.charSpace = newCharSpace;
                }
                charSpace = newCharSpace * scale;
            }
            tm = ContentScanner.GraphicsState.concat(new double[]{1.0, 0.0, 0.0, 1.0, 0.0, state.lead}, state.tlm);
        }
        List<Object> textElements = this.getValue();
        for (Object textElement : textElements) {
            if (textElement instanceof byte[]) {
                String textString = font.decode((byte[])textElement);
                char[] cArray = textString.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char textChar = cArray[n2];
                    double[] trm = ContentScanner.GraphicsState.concat(tm, ctm);
                    double charWidth = (double)font.getWidth(textChar) * scaledFactor;
                    double charHeight = font.getHeight(textChar, fontSize);
                    if (textScanner != null) {
                        if (!fontScanned) {
                            fontScanned = true;
                            textScanner.scanFont(fontSize * tm[3]);
                        }
                        double scaledCharWidth = charWidth * tm[0];
                        double scaledCharHeight = charHeight * tm[3];
                        Rectangle2D.Double charBox = new Rectangle2D.Double(trm[4], contextHeight - trm[5] - font.getAscent(fontSize) * tm[3], scaledCharWidth, scaledCharHeight);
                        textScanner.scanChar(textChar, charBox);
                    }
                    tm = ContentScanner.GraphicsState.concat(new double[]{1.0, 0.0, 0.0, 1.0, charWidth + charSpace + (textChar == ' ' ? wordSpace : 0.0), 0.0}, tm);
                    ++n2;
                }
                continue;
            }
            tm = ContentScanner.GraphicsState.concat(new double[]{1.0, 0.0, 0.0, 1.0, -((Number)textElement).doubleValue() * scaledFactor, 0.0}, tm);
        }
        if (textScanner == null) {
            state.tm = tm;
            if (this instanceof ShowTextToNextLine) {
                state.tlm = Arrays.copyOf(state.tm, state.tm.length);
            }
        }
    }

    public abstract void setText(byte[] var1);

    public void setValue(List<Object> value) {
        this.setText((byte[])value.get(0));
    }

    public static interface IScanner {
        public void scanFont(double var1);

        public void scanChar(char var1, Rectangle2D var2);
    }
}

