/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.contents.objects;

import it.stefanochizzolini.clown.bytes.IOutputStream;
import it.stefanochizzolini.clown.documents.contents.objects.BeginInlineImage;
import it.stefanochizzolini.clown.documents.contents.objects.BeginMarkedContent;
import it.stefanochizzolini.clown.documents.contents.objects.BeginSubpath;
import it.stefanochizzolini.clown.documents.contents.objects.BeginText;
import it.stefanochizzolini.clown.documents.contents.objects.CloseFillStroke;
import it.stefanochizzolini.clown.documents.contents.objects.CloseFillStrokeEvenOdd;
import it.stefanochizzolini.clown.documents.contents.objects.CloseStroke;
import it.stefanochizzolini.clown.documents.contents.objects.CloseSubpath;
import it.stefanochizzolini.clown.documents.contents.objects.ContentObject;
import it.stefanochizzolini.clown.documents.contents.objects.DrawCurve;
import it.stefanochizzolini.clown.documents.contents.objects.DrawLine;
import it.stefanochizzolini.clown.documents.contents.objects.DrawRectangle;
import it.stefanochizzolini.clown.documents.contents.objects.EndInlineImage;
import it.stefanochizzolini.clown.documents.contents.objects.EndMarkedContent;
import it.stefanochizzolini.clown.documents.contents.objects.EndPathNoOp;
import it.stefanochizzolini.clown.documents.contents.objects.EndText;
import it.stefanochizzolini.clown.documents.contents.objects.Fill;
import it.stefanochizzolini.clown.documents.contents.objects.FillEvenOdd;
import it.stefanochizzolini.clown.documents.contents.objects.FillStroke;
import it.stefanochizzolini.clown.documents.contents.objects.FillStrokeEvenOdd;
import it.stefanochizzolini.clown.documents.contents.objects.GenericOperation;
import it.stefanochizzolini.clown.documents.contents.objects.ModifyCTM;
import it.stefanochizzolini.clown.documents.contents.objects.ModifyClipPath;
import it.stefanochizzolini.clown.documents.contents.objects.ModifyClipPathEvenOdd;
import it.stefanochizzolini.clown.documents.contents.objects.PaintShading;
import it.stefanochizzolini.clown.documents.contents.objects.PaintXObject;
import it.stefanochizzolini.clown.documents.contents.objects.RestoreGraphicsState;
import it.stefanochizzolini.clown.documents.contents.objects.SaveGraphicsState;
import it.stefanochizzolini.clown.documents.contents.objects.SetCharSpace;
import it.stefanochizzolini.clown.documents.contents.objects.SetExtGState;
import it.stefanochizzolini.clown.documents.contents.objects.SetFillColor;
import it.stefanochizzolini.clown.documents.contents.objects.SetFillColorSpace;
import it.stefanochizzolini.clown.documents.contents.objects.SetFont;
import it.stefanochizzolini.clown.documents.contents.objects.SetLineCap;
import it.stefanochizzolini.clown.documents.contents.objects.SetLineDash;
import it.stefanochizzolini.clown.documents.contents.objects.SetLineJoin;
import it.stefanochizzolini.clown.documents.contents.objects.SetLineWidth;
import it.stefanochizzolini.clown.documents.contents.objects.SetMiterLimit;
import it.stefanochizzolini.clown.documents.contents.objects.SetStrokeColor;
import it.stefanochizzolini.clown.documents.contents.objects.SetStrokeColorSpace;
import it.stefanochizzolini.clown.documents.contents.objects.SetTextLead;
import it.stefanochizzolini.clown.documents.contents.objects.SetTextMatrix;
import it.stefanochizzolini.clown.documents.contents.objects.SetTextRenderMode;
import it.stefanochizzolini.clown.documents.contents.objects.SetTextRise;
import it.stefanochizzolini.clown.documents.contents.objects.SetTextScale;
import it.stefanochizzolini.clown.documents.contents.objects.SetWordSpace;
import it.stefanochizzolini.clown.documents.contents.objects.ShowAdjustedText;
import it.stefanochizzolini.clown.documents.contents.objects.ShowSimpleText;
import it.stefanochizzolini.clown.documents.contents.objects.ShowTextToNextLine;
import it.stefanochizzolini.clown.documents.contents.objects.Stroke;
import it.stefanochizzolini.clown.documents.contents.objects.TranslateTextRelative;
import it.stefanochizzolini.clown.documents.contents.objects.TranslateTextToNextLine;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import java.util.ArrayList;
import java.util.List;

public abstract class Operation
extends ContentObject {
    protected String operator;
    protected List<PdfDirectObject> operands;

    public static Operation get(String operator, List<PdfDirectObject> operands) {
        if (operator == null) {
            return null;
        }
        if (operator.equals("q")) {
            return SaveGraphicsState.Value;
        }
        if (operator.equals("Tf")) {
            return new SetFont(operands);
        }
        if (operator.equals("SC")) {
            return new SetStrokeColor(operands);
        }
        if (operator.equals("CS")) {
            return new SetStrokeColorSpace(operands);
        }
        if (operator.equals("sc")) {
            return new SetFillColor(operands);
        }
        if (operator.equals("cs")) {
            return new SetFillColorSpace(operands);
        }
        if (operator.equals("Q")) {
            return RestoreGraphicsState.Value;
        }
        if (operator.equals("m")) {
            return new BeginSubpath(operands);
        }
        if (operator.equals("h")) {
            return CloseSubpath.Value;
        }
        if (operator.equals("s")) {
            return CloseStroke.Value;
        }
        if (operator.equals("f") || operator.equals("F")) {
            return Fill.Value;
        }
        if (operator.equals("f*")) {
            return FillEvenOdd.Value;
        }
        if (operator.equals("S")) {
            return Stroke.Value;
        }
        if (operator.equals("B")) {
            return FillStroke.Value;
        }
        if (operator.equals("B*")) {
            return FillStrokeEvenOdd.Value;
        }
        if (operator.equals("b")) {
            return CloseFillStroke.Value;
        }
        if (operator.equals("b*")) {
            return CloseFillStrokeEvenOdd.Value;
        }
        if (operator.equals("n")) {
            return EndPathNoOp.Value;
        }
        if (operator.equals("W")) {
            return ModifyClipPath.Value;
        }
        if (operator.equals("W*")) {
            return ModifyClipPathEvenOdd.Value;
        }
        if (operator.equals("T*")) {
            return TranslateTextToNextLine.Value;
        }
        if (operator.equals("Tj")) {
            return new ShowSimpleText(operands);
        }
        if (operator.equals("'") || operator.equals("''")) {
            return new ShowTextToNextLine(operator, operands);
        }
        if (operator.equals("TJ")) {
            return new ShowAdjustedText(operands);
        }
        if (operator.equals("Td") || operator.equals("TD")) {
            return new TranslateTextRelative(operator, operands);
        }
        if (operator.equals("Tm")) {
            return new SetTextMatrix(operands);
        }
        if (operator.equals("cm")) {
            return new ModifyCTM(operands);
        }
        if (operator.equals("Do")) {
            return new PaintXObject(operands);
        }
        if (operator.equals("sh")) {
            return new PaintShading(operands);
        }
        if (operator.equals("Tc")) {
            return new SetCharSpace(operands);
        }
        if (operator.equals("J")) {
            return new SetLineCap(operands);
        }
        if (operator.equals("d")) {
            return new SetLineDash(operands);
        }
        if (operator.equals("j")) {
            return new SetLineJoin(operands);
        }
        if (operator.equals("w")) {
            return new SetLineWidth(operands);
        }
        if (operator.equals("M")) {
            return new SetMiterLimit(operands);
        }
        if (operator.equals("TL")) {
            return new SetTextLead(operands);
        }
        if (operator.equals("Ts")) {
            return new SetTextRise(operands);
        }
        if (operator.equals("Tz")) {
            return new SetTextScale(operands);
        }
        if (operator.equals("Tr")) {
            return new SetTextRenderMode(operands);
        }
        if (operator.equals("Tw")) {
            return new SetWordSpace(operands);
        }
        if (operator.equals("l")) {
            return new DrawLine(operands);
        }
        if (operator.equals("re")) {
            return new DrawRectangle(operands);
        }
        if (operator.equals("v") || operator.equals("c") || operator.equals("y")) {
            return new DrawCurve(operator, operands);
        }
        if (operator.equals("EI")) {
            return EndInlineImage.Value;
        }
        if (operator.equals("BT")) {
            return BeginText.Value;
        }
        if (operator.equals("ET")) {
            return EndText.Value;
        }
        if (operator.equals("BMC")) {
            return new BeginMarkedContent((PdfName)operands.get(0));
        }
        if (operator.equals("BDC")) {
            return new BeginMarkedContent((PdfName)operands.get(0), operands.get(1));
        }
        if (operator.equals("EMC")) {
            return EndMarkedContent.Value;
        }
        if (operator.equals("BI")) {
            return BeginInlineImage.Value;
        }
        if (operator.equals("EI")) {
            return EndInlineImage.Value;
        }
        if (operator.equals("gs")) {
            return new SetExtGState(operands);
        }
        return new GenericOperation(operator, operands);
    }

    protected Operation(String operator) {
        this.operator = operator;
    }

    protected Operation(String operator, PdfDirectObject operand) {
        this.operator = operator;
        this.operands = new ArrayList<PdfDirectObject>();
        this.operands.add(operand);
    }

    protected Operation(String operator, PdfDirectObject ... operands) {
        this.operator = operator;
        this.operands = new ArrayList<PdfDirectObject>();
        PdfDirectObject[] pdfDirectObjectArray = operands;
        int n = operands.length;
        int n2 = 0;
        while (n2 < n) {
            PdfDirectObject operand = pdfDirectObjectArray[n2];
            this.operands.add(operand);
            ++n2;
        }
    }

    protected Operation(String operator, List<PdfDirectObject> operands) {
        this.operator = operator;
        this.operands = operands;
    }

    public String getOperator() {
        return this.operator;
    }

    public List<PdfDirectObject> getOperands() {
        return this.operands;
    }

    public String toString() {
        return "{" + this.operator + " " + (this.operands == null ? "" : this.operands.toString()) + "}";
    }

    @Override
    public void writeTo(IOutputStream stream) {
        if (this.operands != null) {
            for (PdfDirectObject operand : this.operands) {
                operand.writeTo(stream);
                stream.write(" ");
            }
        }
        stream.write(this.operator);
        stream.write("\n");
    }
}

