/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.contents.fonts;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.contents.fonts.AfmParser;
import it.stefanochizzolini.clown.documents.contents.fonts.Encoding;
import it.stefanochizzolini.clown.documents.contents.fonts.PfbParser;
import it.stefanochizzolini.clown.documents.contents.fonts.SimpleFont;
import it.stefanochizzolini.clown.objects.PdfDataObject;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfStream;
import it.stefanochizzolini.clown.util.BiMap;
import it.stefanochizzolini.clown.util.ByteArray;
import it.stefanochizzolini.clown.util.ConvertUtils;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.util.Hashtable;
import java.util.Map;

public class Type1Font
extends SimpleFont {
    protected AfmParser.FontMetrics metrics;

    Type1Font(Document context) {
        super(context);
    }

    Type1Font(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public Type1Font clone(Document context) {
        throw new NotImplementedException();
    }

    protected Map<ByteArray, Integer> getNativeEncoding() {
        PdfDictionary descriptor = this.getDescriptor();
        if (descriptor.containsKey(PdfName.FontFile)) {
            PdfStream fontFileStream = (PdfStream)descriptor.resolve(PdfName.FontFile);
            PfbParser parser = new PfbParser(fontFileStream.getBody());
            return parser.parse();
        }
        if (descriptor.containsKey(PdfName.FontFile3)) {
            PdfStream fontFileStream = (PdfStream)descriptor.resolve(PdfName.FontFile3);
            PdfName fontFileSubtype = (PdfName)fontFileStream.getHeader().get(PdfName.Subtype);
            if (fontFileSubtype.equals(PdfName.Type1C)) {
                throw new NotImplementedException("Embedded CFF font file.");
            }
            if (fontFileSubtype.equals(PdfName.OpenType)) {
                throw new NotImplementedException("Embedded OpenFont/CFF font file.");
            }
            throw new UnsupportedOperationException("Unsupported embedded font file format: " + fontFileSubtype);
        }
        return Encoding.get(PdfName.StandardEncoding).getCodes();
    }

    @Override
    protected void loadEncoding() {
        if (this.codes == null) {
            Map<ByteArray, Integer> codes;
            PdfDataObject encodingObject = ((PdfDictionary)this.getBaseDataObject()).resolve(PdfName.Encoding);
            if (encodingObject == null) {
                codes = this.getNativeEncoding();
            } else if (encodingObject instanceof PdfName) {
                codes = Encoding.get((PdfName)encodingObject).getCodes();
            } else {
                PdfDictionary encodingDictionary = (PdfDictionary)encodingObject;
                PdfName baseEncodingName = (PdfName)encodingDictionary.get(PdfName.BaseEncoding);
                codes = baseEncodingName == null ? this.getNativeEncoding() : Encoding.get(baseEncodingName).getCodes();
                this.loadEncodingDifferences(encodingDictionary, codes);
            }
            this.codes = new BiMap<ByteArray, Integer>(codes);
        }
        if (this.glyphIndexes == null) {
            this.glyphIndexes = new Hashtable();
            for (Map.Entry codeEntry : this.codes.entrySet()) {
                this.glyphIndexes.put((Integer)codeEntry.getValue(), ConvertUtils.byteArrayToInt(((ByteArray)codeEntry.getKey()).data));
            }
        }
    }
}

