/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.contents.fonts;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class GlyphMapping {
    private static Hashtable<String, Integer> codes = new Hashtable();

    static {
        GlyphMapping.load();
    }

    GlyphMapping() {
    }

    public static int nameToCode(String name) {
        return codes.get(name);
    }

    private static void load() {
        BufferedReader glyphListStream = null;
        try {
            try {
                String line;
                glyphListStream = new BufferedReader(new InputStreamReader(GlyphMapping.class.getResourceAsStream("/fonts/AGL20.scsv")));
                Pattern linePattern = Pattern.compile("^(\\w+);([A-F0-9]+)$");
                while ((line = glyphListStream.readLine()) != null) {
                    Matcher lineMatcher = linePattern.matcher(line);
                    if (!lineMatcher.find()) continue;
                    String name = lineMatcher.group(1);
                    int code = Integer.parseInt(lineMatcher.group(2), 16);
                    codes.put(name, code);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            try {
                if (glyphListStream != null) {
                    glyphListStream.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

