/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.contents.fonts;

import it.stefanochizzolini.clown.documents.contents.fonts.GlyphMapping;
import it.stefanochizzolini.clown.documents.contents.fonts.MacRomanEncoding;
import it.stefanochizzolini.clown.documents.contents.fonts.StandardEncoding;
import it.stefanochizzolini.clown.documents.contents.fonts.WinAnsiEncoding;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.util.ByteArray;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

class Encoding {
    private static final Map<PdfName, Encoding> Encodings = new HashMap<PdfName, Encoding>();
    private Hashtable<ByteArray, Integer> codes = new Hashtable();

    static {
        Encodings.put(PdfName.StandardEncoding, new StandardEncoding());
        Encodings.put(PdfName.MacRomanEncoding, new MacRomanEncoding());
        Encodings.put(PdfName.WinAnsiEncoding, new WinAnsiEncoding());
    }

    Encoding() {
    }

    public static Encoding get(PdfName name) {
        return Encodings.get(name);
    }

    public Map<ByteArray, Integer> getCodes() {
        return new Hashtable<ByteArray, Integer>(this.codes);
    }

    protected void put(int charCode, String charName) {
        this.codes.put(new ByteArray(new byte[]{(byte)charCode}), GlyphMapping.nameToCode(charName));
    }
}

