/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.contents.fonts;

import it.stefanochizzolini.clown.bytes.Buffer;
import it.stefanochizzolini.clown.bytes.IInputStream;
import it.stefanochizzolini.clown.documents.contents.fonts.GlyphMapping;
import it.stefanochizzolini.clown.tokens.FileFormatException;
import it.stefanochizzolini.clown.tokens.TokenTypeEnum;
import it.stefanochizzolini.clown.util.ByteArray;
import it.stefanochizzolini.clown.util.ConvertUtils;
import it.stefanochizzolini.clown.util.math.OperationUtils;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;

final class CMapParser {
    private static final String BeginBaseFontCharOperator = "beginbfchar";
    private static final String BeginBaseFontRangeOperator = "beginbfrange";
    private static final String BeginCIDCharOperator = "begincidchar";
    private static final String BeginCIDRangeOperator = "begincidrange";
    private IInputStream stream;
    private Object token;
    private TokenTypeEnum tokenType;

    protected static int getHex(int c) {
        if (c >= 48 && c <= 57) {
            return c - 48;
        }
        if (c >= 65 && c <= 70) {
            return c - 65 + 10;
        }
        if (c >= 97 && c <= 102) {
            return c - 97 + 10;
        }
        return -1;
    }

    protected static boolean isDelimiter(int c) {
        return c == 40 || c == 41 || c == 60 || c == 62 || c == 91 || c == 93 || c == 47 || c == 37;
    }

    protected static boolean isEOL(int c) {
        return c == 10 || c == 13;
    }

    protected static boolean isWhitespace(int c) {
        return c == 32 || CMapParser.isEOL(c) || c == 0 || c == 9 || c == 12;
    }

    public CMapParser(BufferedReader stream) {
        this(new Buffer(stream));
    }

    public CMapParser(InputStream stream) {
        this(new Buffer(stream));
    }

    public CMapParser(IInputStream stream) {
        this.stream = stream;
    }

    public long getLength() {
        return this.stream.getLength();
    }

    public long getPosition() {
        return this.stream.getPosition();
    }

    public IInputStream getStream() {
        return this.stream;
    }

    public Object getToken() {
        return this.token;
    }

    public TokenTypeEnum getTokenType() {
        return this.tokenType;
    }

    public boolean moveNext(int offset) throws FileFormatException {
        int index = 0;
        while (index < offset) {
            if (!this.moveNext()) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public boolean moveNext() throws FileFormatException {
        int c = 0;
        try {
            while (CMapParser.isWhitespace(c = this.stream.readUnsignedByte())) {
            }
        }
        catch (EOFException e) {
            return false;
        }
        StringBuilder buffer = null;
        this.token = null;
        block10 : switch (c) {
            case 47: {
                this.tokenType = TokenTypeEnum.Name;
                buffer = new StringBuilder();
                try {
                    while (!CMapParser.isDelimiter(c = this.stream.readUnsignedByte()) && !CMapParser.isWhitespace(c)) {
                        if (c == 35) {
                            try {
                                c = (CMapParser.getHex(this.stream.readUnsignedByte()) << 4) + CMapParser.getHex(this.stream.readUnsignedByte());
                            }
                            catch (EOFException e) {
                                throw new FileFormatException("Unexpected EOF (malformed hexadecimal code in name object).", e, this.stream.getPosition());
                            }
                        }
                        buffer.append((char)c);
                    }
                }
                catch (EOFException e) {
                    throw new FileFormatException("Unexpected EOF (malformed name object).", e, this.stream.getPosition());
                }
                this.stream.skip(-1L);
                break;
            }
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                switch (c) {
                    case 46: {
                        this.tokenType = TokenTypeEnum.Real;
                        break;
                    }
                    default: {
                        this.tokenType = TokenTypeEnum.Integer;
                    }
                }
                buffer = new StringBuilder();
                try {
                    while (true) {
                        buffer.append((char)c);
                        c = this.stream.readUnsignedByte();
                        if (c == 46) {
                            this.tokenType = TokenTypeEnum.Real;
                            continue;
                        }
                        if (c < 48 || c > 57) break;
                    }
                }
                catch (EOFException e) {
                    throw new FileFormatException("Unexpected EOF (malformed number object).", e, this.stream.getPosition());
                }
                this.stream.skip(-1L);
                break;
            }
            case 91: {
                this.tokenType = TokenTypeEnum.ArrayBegin;
                break;
            }
            case 93: {
                this.tokenType = TokenTypeEnum.ArrayEnd;
                break;
            }
            case 60: {
                try {
                    c = this.stream.readUnsignedByte();
                }
                catch (EOFException e) {
                    throw new FileFormatException("Unexpected EOF (isolated opening angle-bracket character).", e, this.stream.getPosition());
                }
                if (c == 60) {
                    this.tokenType = TokenTypeEnum.DictionaryBegin;
                    break;
                }
                this.tokenType = TokenTypeEnum.Hex;
                buffer = new StringBuilder();
                try {
                    while (c != 62) {
                        buffer.append((char)c);
                        c = this.stream.readUnsignedByte();
                    }
                    break;
                }
                catch (EOFException e) {
                    throw new FileFormatException("Unexpected EOF (malformed hex string).", e, this.stream.getPosition());
                }
            }
            case 62: {
                try {
                    c = this.stream.readUnsignedByte();
                }
                catch (EOFException e) {
                    throw new FileFormatException("Unexpected EOF (malformed dictionary).", e, this.stream.getPosition());
                }
                if (c != 62) {
                    throw new FileFormatException("Malformed dictionary.", this.stream.getPosition());
                }
                this.tokenType = TokenTypeEnum.DictionaryEnd;
                break;
            }
            case 37: {
                this.tokenType = TokenTypeEnum.Comment;
                try {
                    while (!CMapParser.isEOL(c = this.stream.readUnsignedByte())) {
                    }
                }
                catch (EOFException e) {}
                break;
            }
            case 40: {
                this.tokenType = TokenTypeEnum.Literal;
                buffer = new StringBuilder();
                int level = 0;
                try {
                    while (true) {
                        if ((c = this.stream.readUnsignedByte()) == 40) {
                            ++level;
                        } else if (c == 41) {
                            --level;
                        } else if (c == 92) {
                            boolean lineBreak = false;
                            c = this.stream.readUnsignedByte();
                            switch (c) {
                                case 110: {
                                    c = 10;
                                    break;
                                }
                                case 114: {
                                    c = 13;
                                    break;
                                }
                                case 116: {
                                    c = 9;
                                    break;
                                }
                                case 98: {
                                    c = 8;
                                    break;
                                }
                                case 102: {
                                    c = 12;
                                    break;
                                }
                                case 40: 
                                case 41: 
                                case 92: {
                                    break;
                                }
                                case 13: {
                                    lineBreak = true;
                                    c = this.stream.readUnsignedByte();
                                    if (c == 10) break;
                                    this.stream.skip(-1L);
                                    break;
                                }
                                case 10: {
                                    lineBreak = true;
                                    break;
                                }
                                default: {
                                    if (c < 48 || c > 55) break;
                                    int octal = c - 48;
                                    c = this.stream.readUnsignedByte();
                                    if (c < 48 || c > 55) {
                                        c = octal;
                                        this.stream.skip(-1L);
                                        break;
                                    }
                                    octal = (octal << 3) + c - 48;
                                    c = this.stream.readUnsignedByte();
                                    if (c < 48 || c > 55) {
                                        c = octal;
                                        this.stream.skip(-1L);
                                        break;
                                    }
                                    octal = (octal << 3) + c - 48;
                                    c = octal & 0xFF;
                                }
                            }
                            if (lineBreak) {
                                continue;
                            }
                        } else if (c == 13 && (c = this.stream.readUnsignedByte()) != 10) {
                            c = 10;
                            this.stream.skip(-1L);
                        }
                        if (level == -1) break block10;
                        buffer.append((char)c);
                    }
                }
                catch (EOFException e) {
                    throw new FileFormatException("Unexpected EOF (malformed literal string).", e, this.stream.getPosition());
                }
            }
            default: {
                this.tokenType = TokenTypeEnum.Keyword;
                buffer = new StringBuilder();
                try {
                    do {
                        buffer.append((char)c);
                    } while (!CMapParser.isDelimiter(c = this.stream.readUnsignedByte()) && !CMapParser.isWhitespace(c));
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
                this.stream.skip(-1L);
            }
        }
        if (buffer != null) {
            switch (this.tokenType) {
                case Keyword: {
                    this.token = buffer.toString();
                    if (((String)this.token).equals("false") || ((String)this.token).equals("true")) {
                        this.tokenType = TokenTypeEnum.Boolean;
                        this.token = Boolean.parseBoolean((String)this.token);
                        break;
                    }
                    if (!((String)this.token).equals("null")) break;
                    this.tokenType = TokenTypeEnum.Null;
                    this.token = null;
                    break;
                }
                case Name: 
                case Comment: {
                    this.token = buffer.toString();
                    break;
                }
                case Literal: {
                    this.token = buffer.toString();
                    break;
                }
                case Hex: {
                    this.token = ConvertUtils.hexToByteArray(buffer.toString());
                    break;
                }
                case Integer: {
                    this.token = Integer.parseInt(buffer.toString());
                    break;
                }
                case Real: {
                    this.token = Float.valueOf(Float.parseFloat(buffer.toString()));
                }
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<ByteArray, Integer> parse() {
        this.stream.setPosition(0L);
        codes = new Hashtable<ByteArray, Integer>();
        itemCount = 0;
        try lbl-1000:
        // 2 sources

        {
            while (true) {
                if (!this.moveNext()) {
                    return codes;
                }
                switch (CMapParser.$SWITCH_TABLE$it$stefanochizzolini$clown$tokens$TokenTypeEnum()[this.tokenType.ordinal()]) {
                    case 1: {
                        operator = (String)this.token;
                        if (!operator.equals("beginbfchar") && !operator.equals("begincidchar")) ** GOTO lbl14
                        itemIndex = 0;
                        if (true) ** GOTO lbl86
lbl14:
                        // 1 sources

                        if (!operator.equals("beginbfrange") && !operator.equals("begincidrange")) break;
                        itemIndex = 0;
                        while (itemIndex < itemCount) {
                            this.moveNext();
                            beginInputCode = (byte[])this.token;
                            this.moveNext();
                            endInputCode = (byte[])this.token;
                            this.moveNext();
                            block10 : switch (CMapParser.$SWITCH_TABLE$it$stefanochizzolini$clown$tokens$TokenTypeEnum()[this.tokenType.ordinal()]) {
                                case 3: 
                                case 7: {
                                    inputCode = beginInputCode;
                                    switch (CMapParser.$SWITCH_TABLE$it$stefanochizzolini$clown$tokens$TokenTypeEnum()[this.tokenType.ordinal()]) {
                                        case 7: {
                                            charCode = ConvertUtils.byteArrayToInt((byte[])this.token);
                                            break;
                                        }
                                        case 3: {
                                            charCode = (Integer)this.token;
                                            break;
                                        }
                                        default: {
                                            throw new RuntimeException(String.valueOf(operator) + " section syntax error: hex string or integer expected instead of " + (Object)this.tokenType);
                                        }
                                    }
                                    endCharCode = charCode + (ConvertUtils.byteArrayToInt(endInputCode) - ConvertUtils.byteArrayToInt(beginInputCode));
                                    while (true) {
                                        codes.put(new ByteArray(inputCode), charCode);
                                        if (charCode == endCharCode) break block10;
                                        OperationUtils.increment(inputCode);
                                        ++charCode;
                                    }
                                }
                                case 10: {
                                    inputCode = beginInputCode;
                                    while (this.moveNext() && this.tokenType != TokenTypeEnum.ArrayEnd) {
                                        codes.put(new ByteArray(inputCode), GlyphMapping.nameToCode((String)this.token));
                                        OperationUtils.increment(inputCode);
                                    }
                                    break;
                                }
                                default: {
                                    throw new RuntimeException(String.valueOf(operator) + " section syntax error: hex string, integer or name array expected instead of " + (Object)this.tokenType);
                                }
                            }
                            ++itemIndex;
                        }
                        break;
                    }
                    case 3: {
                        itemCount = (Integer)this.token;
                        break;
                    }
                }
                continue;
                break;
            }
        }
        catch (FileFormatException fileFormatException) {
            throw new RuntimeException(fileFormatException);
        }
        do {
            this.moveNext();
            inputCode = new ByteArray((byte[])this.token);
            this.moveNext();
            switch (CMapParser.$SWITCH_TABLE$it$stefanochizzolini$clown$tokens$TokenTypeEnum()[this.tokenType.ordinal()]) {
                case 7: {
                    codes.put(inputCode, ConvertUtils.byteArrayToInt((byte[])this.token));
                    break;
                }
                case 3: {
                    codes.put(inputCode, (Integer)this.token);
                    break;
                }
                case 8: {
                    codes.put(inputCode, GlyphMapping.nameToCode((String)this.token));
                    break;
                }
                default: {
                    throw new RuntimeException(String.valueOf(operator) + " section syntax error: hex string, integer or name expected instead of " + (Object)this.tokenType);
                }
            }
            ++itemIndex;
lbl86:
            // 2 sources

        } while (itemIndex < itemCount);
        ** while (true)
    }

    public void seek(long position) {
        if (position < 0L) {
            throw new IllegalArgumentException("The 'position' argument is lower than acceptable.");
        }
        if (position > this.stream.getLength()) {
            throw new IllegalArgumentException("The 'position' argument is higher than acceptable.");
        }
        this.stream.seek(position);
    }

    public void skip(long offset) {
        long position = this.stream.getPosition() + offset;
        if (position < 0L) {
            throw new IllegalArgumentException("The 'offset' argument is lower than acceptable.");
        }
        if (position > this.stream.getLength()) {
            throw new IllegalArgumentException("The 'offset' argument is higher than acceptable.");
        }
        this.stream.skip(position);
    }

    public boolean skipWhitespace() {
        try {
            int b;
            while (CMapParser.isWhitespace(b = this.stream.readUnsignedByte())) {
            }
        }
        catch (EOFException e) {
            return false;
        }
        this.stream.skip(-1L);
        return true;
    }
}

