/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.contents.composition;

import it.stefanochizzolini.clown.documents.contents.fonts.Font;
import java.util.regex.Pattern;

final class TextFitter {
    private Font font;
    private double fontSize;
    private boolean hyphenation;
    private String text;
    private double width;
    private int beginIndex = 0;
    private int endIndex = -1;
    private String fittedText;
    private double fittedWidth;

    TextFitter(String text, double width, Font font, double fontSize, boolean hyphenation) {
        this.text = text;
        this.width = width;
        this.font = font;
        this.fontSize = fontSize;
        this.hyphenation = hyphenation;
    }

    public boolean fit() {
        return this.fit(this.endIndex + 1, this.width);
    }

    /*
     * Unable to fully structure code
     */
    public boolean fit(int index, double width) {
        this.beginIndex = index;
        this.width = width;
        this.fittedText = null;
        this.fittedWidth = 0.0;
        hyphen = "";
        pattern = Pattern.compile("(\\s*)(\\S*)");
        matcher = pattern.matcher(this.text);
        matcher.region(this.beginIndex, this.text.length());
        block3: while (matcher.find()) {
            block7: {
                spaceIndex = matcher.start(1);
                spaceEnd = matcher.end(1);
                while (spaceIndex < spaceEnd) {
                    switch (this.text.charAt(spaceIndex)) {
                        case '\n': 
                        case '\r': {
                            index = spaceIndex;
                            break block3;
                        }
                        default: {
                            ++spaceIndex;
                        }
                    }
                }
                wordEndIndex = matcher.end(0);
                wordWidth = this.font.getKernedWidth(matcher.group(0), this.fontSize);
                this.fittedWidth += wordWidth;
                if (!(this.fittedWidth > width)) break block7;
                this.fittedWidth -= wordWidth;
                wordEndIndex = index;
                if (wordEndIndex == 0 || !this.hyphenation) break;
                do {
                    textChar = this.text.charAt(wordEndIndex);
                    wordWidth = (double)(this.font.getKerning(this.text.charAt(wordEndIndex - 1), textChar) + this.font.getWidth(textChar)) * Font.getScalingFactor(this.fontSize);
                    ++wordEndIndex;
                    this.fittedWidth += wordWidth;
                } while (!(this.fittedWidth > width));
                this.fittedWidth -= wordWidth;
                if (--wordEndIndex <= index + 4) ** GOTO lbl45
                index = --wordEndIndex;
                textChar = this.text.charAt(wordEndIndex);
                this.fittedWidth -= (double)(this.font.getKerning(this.text.charAt(wordEndIndex - 1), textChar) + this.font.getWidth(textChar)) * Font.getScalingFactor(this.fontSize);
                textChar = '-';
                this.fittedWidth += (double)(this.font.getKerning(this.text.charAt(wordEndIndex - 1), textChar) + this.font.getWidth(textChar)) * Font.getScalingFactor(this.fontSize);
                hyphen = String.valueOf(textChar);
                break;
lbl-1000:
                // 1 sources

                {
                    textChar = this.text.charAt(--wordEndIndex);
                    this.fittedWidth -= (double)(this.font.getKerning(this.text.charAt(wordEndIndex - 1), textChar) + this.font.getWidth(textChar)) * Font.getScalingFactor(this.fontSize);
lbl45:
                    // 2 sources

                    ** while (wordEndIndex > index)
                }
lbl46:
                // 1 sources

                break;
            }
            index = wordEndIndex;
        }
        this.fittedText = String.valueOf(this.text.substring(this.beginIndex, index)) + hyphen;
        this.endIndex = index;
        return this.fittedWidth > 0.0;
    }

    public int getBeginIndex() {
        return this.beginIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public String getFittedText() {
        return this.fittedText;
    }

    public double getFittedWidth() {
        return this.fittedWidth;
    }

    public Font getFont() {
        return this.font;
    }

    public double getFontSize() {
        return this.fontSize;
    }

    public String getText() {
        return this.text;
    }

    public double getWidth() {
        return this.width;
    }

    public boolean isHyphenation() {
        return this.hyphenation;
    }
}

