/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.contents.composition;

import it.stefanochizzolini.clown.documents.Page;
import it.stefanochizzolini.clown.documents.contents.ContentScanner;
import it.stefanochizzolini.clown.documents.contents.FontResources;
import it.stefanochizzolini.clown.documents.contents.IContentContext;
import it.stefanochizzolini.clown.documents.contents.LineCapEnum;
import it.stefanochizzolini.clown.documents.contents.LineJoinEnum;
import it.stefanochizzolini.clown.documents.contents.Resources;
import it.stefanochizzolini.clown.documents.contents.TextRenderModeEnum;
import it.stefanochizzolini.clown.documents.contents.XObjectResources;
import it.stefanochizzolini.clown.documents.contents.colorSpaces.Color;
import it.stefanochizzolini.clown.documents.contents.colorSpaces.ColorSpace;
import it.stefanochizzolini.clown.documents.contents.colorSpaces.DeviceCMYKColorSpace;
import it.stefanochizzolini.clown.documents.contents.colorSpaces.DeviceGrayColorSpace;
import it.stefanochizzolini.clown.documents.contents.colorSpaces.DeviceRGBColorSpace;
import it.stefanochizzolini.clown.documents.contents.composition.AlignmentXEnum;
import it.stefanochizzolini.clown.documents.contents.composition.AlignmentYEnum;
import it.stefanochizzolini.clown.documents.contents.fonts.Font;
import it.stefanochizzolini.clown.documents.contents.objects.BeginMarkedContent;
import it.stefanochizzolini.clown.documents.contents.objects.BeginSubpath;
import it.stefanochizzolini.clown.documents.contents.objects.CloseSubpath;
import it.stefanochizzolini.clown.documents.contents.objects.CompositeObject;
import it.stefanochizzolini.clown.documents.contents.objects.ContentObject;
import it.stefanochizzolini.clown.documents.contents.objects.DrawCurve;
import it.stefanochizzolini.clown.documents.contents.objects.DrawLine;
import it.stefanochizzolini.clown.documents.contents.objects.DrawRectangle;
import it.stefanochizzolini.clown.documents.contents.objects.EndPathNoOp;
import it.stefanochizzolini.clown.documents.contents.objects.Fill;
import it.stefanochizzolini.clown.documents.contents.objects.FillStroke;
import it.stefanochizzolini.clown.documents.contents.objects.LocalGraphicsState;
import it.stefanochizzolini.clown.documents.contents.objects.MarkedContent;
import it.stefanochizzolini.clown.documents.contents.objects.ModifyCTM;
import it.stefanochizzolini.clown.documents.contents.objects.ModifyClipPath;
import it.stefanochizzolini.clown.documents.contents.objects.PaintXObject;
import it.stefanochizzolini.clown.documents.contents.objects.SetCharSpace;
import it.stefanochizzolini.clown.documents.contents.objects.SetFillColor;
import it.stefanochizzolini.clown.documents.contents.objects.SetFillColorSpace;
import it.stefanochizzolini.clown.documents.contents.objects.SetFont;
import it.stefanochizzolini.clown.documents.contents.objects.SetLineCap;
import it.stefanochizzolini.clown.documents.contents.objects.SetLineDash;
import it.stefanochizzolini.clown.documents.contents.objects.SetLineJoin;
import it.stefanochizzolini.clown.documents.contents.objects.SetLineWidth;
import it.stefanochizzolini.clown.documents.contents.objects.SetMiterLimit;
import it.stefanochizzolini.clown.documents.contents.objects.SetStrokeColor;
import it.stefanochizzolini.clown.documents.contents.objects.SetStrokeColorSpace;
import it.stefanochizzolini.clown.documents.contents.objects.SetTextLead;
import it.stefanochizzolini.clown.documents.contents.objects.SetTextMatrix;
import it.stefanochizzolini.clown.documents.contents.objects.SetTextRenderMode;
import it.stefanochizzolini.clown.documents.contents.objects.SetTextRise;
import it.stefanochizzolini.clown.documents.contents.objects.SetTextScale;
import it.stefanochizzolini.clown.documents.contents.objects.SetWordSpace;
import it.stefanochizzolini.clown.documents.contents.objects.ShowSimpleText;
import it.stefanochizzolini.clown.documents.contents.objects.Stroke;
import it.stefanochizzolini.clown.documents.contents.objects.Text;
import it.stefanochizzolini.clown.documents.contents.objects.TranslateTextRelative;
import it.stefanochizzolini.clown.documents.contents.objects.TranslateTextToNextLine;
import it.stefanochizzolini.clown.documents.contents.xObjects.XObject;
import it.stefanochizzolini.clown.documents.interaction.actions.Action;
import it.stefanochizzolini.clown.documents.interaction.annotations.Link;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class PrimitiveFilter {
    private ContentScanner scanner;

    public PrimitiveFilter(ContentScanner scanner) {
        this.setScanner(scanner);
    }

    public PrimitiveFilter(IContentContext context) {
        this(new ContentScanner(context.getContents()));
    }

    public ContentObject add(ContentObject object) {
        this.scanner.insert(object);
        this.scanner.moveNext();
        return object;
    }

    public void applyMatrix(double a, double b, double c, double d, double e, double f) {
        this.add(new ModifyCTM(a, b, c, d, e, f));
    }

    public CompositeObject begin(CompositeObject object) {
        this.scanner.insert(object);
        this.scanner = this.scanner.getChildLevel();
        return object;
    }

    public LocalGraphicsState beginLocalState() {
        return (LocalGraphicsState)this.begin(new LocalGraphicsState());
    }

    public MarkedContent beginMarkedContent(PdfName tag) {
        return (MarkedContent)this.begin(new MarkedContent(new BeginMarkedContent(tag)));
    }

    public void clip() {
        this.add(ModifyClipPath.Value);
        this.add(EndPathNoOp.Value);
    }

    public void closePath() {
        this.add(CloseSubpath.Value);
    }

    public void drawArc(RectangularShape location, double startAngle, double endAngle) {
        this.drawArc(location, startAngle, endAngle, 0.0, 1.0);
    }

    public void drawArc(RectangularShape location, double startAngle, double endAngle, double branchWidth, double branchRatio) {
        this.drawArc(location, startAngle, endAngle, branchWidth, branchRatio, true);
    }

    public void drawCurve(Point2D endPoint, Point2D startControl, Point2D endControl) {
        double contextHeight = this.scanner.getContentContext().getBox().getHeight();
        this.add(new DrawCurve(endPoint.getX(), contextHeight - endPoint.getY(), startControl.getX(), contextHeight - startControl.getY(), endControl.getX(), contextHeight - endControl.getY()));
    }

    public void drawCurve(Point2D startPoint, Point2D endPoint, Point2D startControl, Point2D endControl) {
        this.beginSubpath(startPoint);
        this.drawCurve(endPoint, startControl, endControl);
    }

    public void drawEllipse(RectangularShape location) {
        this.drawArc(location, 0.0, 360.0);
    }

    public void drawLine(Point2D endPoint) {
        this.add(new DrawLine(endPoint.getX(), this.scanner.getContentContext().getBox().getHeight() - endPoint.getY()));
    }

    public void drawLine(Point2D startPoint, Point2D endPoint) {
        this.beginSubpath(startPoint);
        this.drawLine(endPoint);
    }

    public void drawPolygon(Point2D[] points) {
        this.drawPolyline(points);
        this.closePath();
    }

    public void drawPolyline(Point2D[] points) {
        this.beginSubpath(points[0]);
        int index = 1;
        int length = points.length;
        while (index < length) {
            this.drawLine(points[index]);
            ++index;
        }
    }

    public void drawRectangle(RectangularShape location) {
        this.drawRectangle(location, 0.0);
    }

    public void drawRectangle(RectangularShape location, double radius) {
        if (radius == 0.0) {
            this.add(new DrawRectangle(location.getX(), this.scanner.getContentContext().getBox().getHeight() - location.getY() - location.getHeight(), location.getWidth(), location.getHeight()));
        } else {
            double endRadians = Math.PI * 2;
            double quadrantRadians = 1.5707963267948966;
            double radians = 0.0;
            while (radians < Math.PI * 2) {
                double radians2 = radians + 1.5707963267948966;
                int sin2 = (int)Math.sin(radians2);
                int cos2 = (int)Math.cos(radians2);
                double x1 = 0.0;
                double x2 = 0.0;
                double y1 = 0.0;
                double y2 = 0.0;
                double xArc = 0.0;
                double yArc = 0.0;
                if (cos2 == 0) {
                    if (sin2 == 1) {
                        x1 = x2 = location.getX() + location.getWidth();
                        y1 = location.getY() + location.getHeight() - radius;
                        y2 = location.getY() + radius;
                        xArc = -radius * 2.0;
                        yArc = -radius;
                        this.beginSubpath(new Point2D.Double(x1, y1));
                    } else {
                        x1 = x2 = location.getX();
                        y1 = location.getY() + radius;
                        y2 = location.getY() + location.getHeight() - radius;
                        yArc = -radius;
                    }
                } else if (cos2 == 1) {
                    x1 = location.getX() + radius;
                    x2 = location.getX() + location.getWidth() - radius;
                    y1 = y2 = location.getY() + location.getHeight();
                    xArc = -radius;
                    yArc = -radius * 2.0;
                } else if (cos2 == -1) {
                    x1 = location.getX() + location.getWidth() - radius;
                    x2 = location.getX() + radius;
                    y1 = y2 = location.getY();
                    xArc = -radius;
                }
                this.drawLine(new Point2D.Double(x2, y2));
                this.drawArc(new Rectangle2D.Double(x2 + xArc, y2 + yArc, radius * 2.0, radius * 2.0), Math.toDegrees(radians), Math.toDegrees(radians2), 0.0, 1.0, false);
                radians = radians2;
            }
        }
    }

    public void drawSpiral(Point2D center, double startAngle, double endAngle, double branchWidth, double branchRatio) {
        this.drawArc(new Rectangle2D.Double(center.getX(), center.getY(), 1.0E-4, 1.0E-4), startAngle, endAngle, branchWidth, branchRatio);
    }

    public void end() {
        this.scanner = this.scanner.getParentLevel();
        this.scanner.moveNext();
    }

    public void fill() {
        this.add(Fill.Value);
    }

    public void fillStroke() {
        this.add(FillStroke.Value);
    }

    public void flush() {
        this.scanner.getContents().flush();
    }

    public ContentScanner getScanner() {
        return this.scanner;
    }

    public ContentScanner.GraphicsState getState() {
        return this.scanner.getState();
    }

    public void rotate(double angle) {
        double rad = angle * Math.PI / 180.0;
        double cos = Math.cos(rad);
        double sin = Math.sin(rad);
        this.applyMatrix(cos, sin, -sin, cos, 0.0, 0.0);
    }

    public void rotate(double angle, Point2D origin) {
        this.translate(origin.getX(), this.scanner.getContentContext().getBox().getHeight() - origin.getY());
        this.rotate(angle);
        this.translate(0.0, -this.scanner.getContentContext().getBox().getHeight());
    }

    public void scale(double ratioX, double ratioY) {
        this.applyMatrix(ratioX, 0.0, 0.0, ratioY, 0.0, 0.0);
    }

    public void setCharSpace(double value) {
        this.add(new SetCharSpace(value));
    }

    public void setFillColor(Color value) {
        if (this.scanner.getState().fillColorSpace != value.getColorSpace()) {
            this.add(new SetFillColorSpace(this.getColorSpaceName(value.getColorSpace())));
        }
        this.add(new SetFillColor(value));
    }

    public void setFont(PdfName name, double size) {
        if (!this.scanner.getContentContext().getResources().getFonts().containsKey(name)) {
            throw new IllegalArgumentException("No font resource associated to the given argument (name:'name'; value:'" + name + "';)");
        }
        this.add(new SetFont(name, size));
    }

    public void setFont(Font value, double size) {
        this.setFont(this.getFontName(value), size);
    }

    public void setTextScale(double value) {
        this.add(new SetTextScale(value));
    }

    public void setTextLead(double value) {
        this.add(new SetTextLead(value));
    }

    public void setLineCap(LineCapEnum value) {
        this.add(new SetLineCap(value));
    }

    public void setLineDash(int phase, int unitsOn) {
        this.setLineDash(phase, unitsOn, unitsOn);
    }

    public void setLineDash(int phase, int unitsOn, int unitsOff) {
        this.add(new SetLineDash(phase, unitsOn, unitsOff));
    }

    public void setLineJoin(LineJoinEnum value) {
        this.add(new SetLineJoin(value));
    }

    public void setLineWidth(double value) {
        this.add(new SetLineWidth(value));
    }

    public void setMatrix(double a, double b, double c, double d, double e, double f) {
        this.add(ModifyCTM.getResetCTM(this.scanner.getState().ctm));
        this.add(new ModifyCTM(a, b, c, d, e, f));
    }

    public void setMiterLimit(double value) {
        this.add(new SetMiterLimit(value));
    }

    public void setScanner(ContentScanner value) {
        this.scanner = value;
    }

    public void setStrokeColor(Color value) {
        if (this.scanner.getState().strokeColorSpace != value.getColorSpace()) {
            this.add(new SetStrokeColorSpace(this.getColorSpaceName(value.getColorSpace())));
        }
        this.add(new SetStrokeColor(value));
    }

    public void setTextRenderMode(TextRenderModeEnum value) {
        this.add(new SetTextRenderMode(value));
    }

    public void setTextRise(double value) {
        this.add(new SetTextRise(value));
    }

    public void setWordSpace(double value) {
        this.add(new SetWordSpace(value));
    }

    public Point2D[] showText(String value) {
        return this.showText(value, new Point2D.Double(0.0, 0.0));
    }

    public Link showText(String value, Action action) {
        return this.showText(value, new Point2D.Double(0.0, 0.0), action);
    }

    public Point2D[] showText(String value, Point2D location) {
        return this.showText(value, location, AlignmentXEnum.Left, AlignmentYEnum.Top, 0.0);
    }

    public Link showText(String value, Point2D location, Action action) {
        return this.showText(value, location, AlignmentXEnum.Left, AlignmentYEnum.Top, 0.0, action);
    }

    public Point2D[] showText(String value, Point2D location, AlignmentXEnum alignmentX, AlignmentYEnum alignmentY, double rotation) {
        Point2D[] frame;
        block30: {
            ContentScanner.GraphicsState state = this.scanner.getState();
            Font font = state.font;
            double fontSize = state.fontSize;
            double x = location.getX();
            double y = location.getY();
            double width = font.getKernedWidth(value, fontSize);
            double height = font.getLineHeight(fontSize);
            double descent = font.getDescent(fontSize);
            frame = new Point2D[4];
            if (alignmentX == AlignmentXEnum.Left && alignmentY == AlignmentYEnum.Top) {
                this.beginText();
                try {
                    try {
                        if (rotation == 0.0) {
                            this.translateText(x, this.scanner.getContentContext().getBox().getHeight() - y - font.getAscent(fontSize));
                        } else {
                            double rad = rotation * Math.PI / 180.0;
                            double cos = Math.cos(rad);
                            double sin = Math.sin(rad);
                            this.setTextMatrix(cos, sin, -sin, cos, x, this.scanner.getContentContext().getBox().getHeight() - y - font.getAscent(fontSize));
                        }
                        state = this.scanner.getState();
                        frame[0] = state.textToDeviceSpace(new Point2D.Double(0.0, descent));
                        frame[1] = state.textToDeviceSpace(new Point2D.Double(width, descent));
                        frame[2] = state.textToDeviceSpace(new Point2D.Double(width, height + descent));
                        frame[3] = state.textToDeviceSpace(new Point2D.Double(0.0, height + descent));
                        this.add(new ShowSimpleText(font.encode(value)));
                        break block30;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to show text.", e);
                    }
                }
                finally {
                    this.end();
                }
            }
            this.beginLocalState();
            try {
                try {
                    double sin;
                    double cos;
                    if (rotation == 0.0) {
                        cos = 1.0;
                        sin = 0.0;
                    } else {
                        double rad = rotation * Math.PI / 180.0;
                        cos = Math.cos(rad);
                        sin = Math.sin(rad);
                    }
                    this.applyMatrix(cos, sin, -sin, cos, x, this.scanner.getContentContext().getBox().getHeight() - y);
                    this.beginText();
                    try {
                        try {
                            switch (alignmentX) {
                                case Left: {
                                    x = 0.0;
                                    break;
                                }
                                case Right: {
                                    x = -width;
                                    break;
                                }
                                case Center: 
                                case Justify: {
                                    x = -width / 2.0;
                                }
                            }
                            switch (alignmentY) {
                                case Top: {
                                    y = -font.getAscent(fontSize);
                                    break;
                                }
                                case Bottom: {
                                    y = height - font.getAscent(fontSize);
                                    break;
                                }
                                case Middle: {
                                    y = height / 2.0 - font.getAscent(fontSize);
                                }
                            }
                            this.translateText(x, y);
                            state = this.scanner.getState();
                            frame[0] = state.textToDeviceSpace(new Point2D.Double(0.0, descent));
                            frame[1] = state.textToDeviceSpace(new Point2D.Double(width, descent));
                            frame[2] = state.textToDeviceSpace(new Point2D.Double(width, height + descent));
                            frame[3] = state.textToDeviceSpace(new Point2D.Double(0.0, height + descent));
                            this.add(new ShowSimpleText(font.encode(value)));
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Failed to show text.", e);
                        }
                    }
                    finally {
                        this.end();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to show text.", e);
                }
            }
            finally {
                this.end();
            }
        }
        return frame;
    }

    public Link showText(String value, Point2D location, AlignmentXEnum alignmentX, AlignmentYEnum alignmentY, double rotation, Action action) {
        Point2D[] textFrame = this.showText(value, location, alignmentX, alignmentY, rotation);
        IContentContext contentContext = this.scanner.getContentContext();
        if (!(contentContext instanceof Page)) {
            throw new RuntimeException("Link can be shown only on page contexts.");
        }
        Page page = (Page)contentContext;
        Rectangle2D.Double linkBox = new Rectangle2D.Double(textFrame[0].getX(), textFrame[0].getY(), 0.0, 0.0);
        int index = 1;
        int length = textFrame.length;
        while (index < length) {
            linkBox.add(textFrame[index]);
            ++index;
        }
        return new Link(page, (Rectangle2D)linkBox, action);
    }

    public void showXObject(PdfName name) {
        this.add(new PaintXObject(name));
    }

    public void showXObject(XObject value) {
        this.showXObject(this.getXObjectName(value));
    }

    public void showXObject(PdfName name, Point2D location) {
        this.showXObject(name, location, (Dimension2D)new Dimension(0, 0));
    }

    public void showXObject(XObject value, Point2D location) {
        this.showXObject(this.getXObjectName(value), location);
    }

    public void showXObject(PdfName name, Point2D location, Dimension2D size) {
        this.showXObject(name, location, size, AlignmentXEnum.Left, AlignmentYEnum.Top, 0.0);
    }

    public void showXObject(XObject value, Point2D location, Dimension2D size) {
        this.showXObject(this.getXObjectName(value), location, size);
    }

    public void showXObject(PdfName name, Point2D location, Dimension2D size, AlignmentXEnum alignmentX, AlignmentYEnum alignmentY, double rotation) {
        double locationOffsetY;
        double locationOffsetX;
        XObject xObject = this.scanner.getContentContext().getResources().getXObjects().get(name);
        Dimension2D xObjectSize = xObject.getSize();
        if (size.getWidth() == 0.0) {
            if (size.getHeight() == 0.0) {
                size.setSize(xObjectSize);
            } else {
                size.setSize(size.getHeight() * xObjectSize.getWidth() / xObjectSize.getHeight(), size.getHeight());
            }
        } else if (size.getHeight() == 0.0) {
            size.setSize(size.getWidth(), size.getWidth() * xObjectSize.getHeight() / xObjectSize.getWidth());
        }
        double[] matrix = xObject.getMatrix();
        double scaleX = size.getWidth() / (xObjectSize.getWidth() * matrix[0]);
        double scaleY = size.getHeight() / (xObjectSize.getHeight() * matrix[3]);
        switch (alignmentX) {
            case Left: {
                locationOffsetX = 0.0;
                break;
            }
            case Right: {
                locationOffsetX = size.getWidth();
                break;
            }
            default: {
                locationOffsetX = size.getWidth() / 2.0;
            }
        }
        switch (alignmentY) {
            case Top: {
                locationOffsetY = size.getHeight();
                break;
            }
            case Bottom: {
                locationOffsetY = 0.0;
                break;
            }
            default: {
                locationOffsetY = size.getHeight() / 2.0;
            }
        }
        this.beginLocalState();
        try {
            try {
                this.translate(location.getX(), this.scanner.getContentContext().getBox().getHeight() - location.getY());
                if (rotation != 0.0) {
                    this.rotate(rotation);
                }
                this.applyMatrix(scaleX, 0.0, 0.0, scaleY, -locationOffsetX, -locationOffsetY);
                this.showXObject(name);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to show the xobject.", e);
            }
        }
        finally {
            this.end();
        }
    }

    public void showXObject(XObject value, Point2D location, Dimension2D size, AlignmentXEnum alignmentX, AlignmentYEnum alignmentY, double rotation) {
        this.showXObject(this.getXObjectName(value), location, size, alignmentX, alignmentY, rotation);
    }

    public void stroke() {
        this.add(Stroke.Value);
    }

    public void translate(double distanceX, double distanceY) {
        this.applyMatrix(1.0, 0.0, 0.0, 1.0, distanceX, distanceY);
    }

    private void beginSubpath(Point2D startPoint) {
        this.add(new BeginSubpath(startPoint.getX(), this.scanner.getContentContext().getBox().getHeight() - startPoint.getY()));
    }

    private Text beginText() {
        return (Text)this.begin(new Text());
    }

    private void drawArc(RectangularShape location, double startAngle, double endAngle, double branchWidth, double branchRatio, boolean beginPath) {
        if (startAngle > endAngle) {
            double swap = startAngle;
            startAngle = endAngle;
            endAngle = swap;
        }
        double radiusX = location.getWidth() / 2.0;
        double radiusY = location.getHeight() / 2.0;
        Point2D.Double center = new Point2D.Double(location.getX() + radiusX, location.getY() + radiusY);
        double radians1 = Math.toRadians(startAngle);
        Point2D.Double point1 = new Point2D.Double(((Point2D)center).getX() + Math.cos(radians1) * radiusX, ((Point2D)center).getY() - Math.sin(radians1) * radiusY);
        if (beginPath) {
            this.beginSubpath(point1);
        }
        double endRadians = Math.toRadians(endAngle);
        double quadrantRadians = 1.5707963267948966;
        double radians2 = Math.min(radians1 + 1.5707963267948966 - radians1 % 1.5707963267948966, endRadians);
        double kappa = 0.5522847498;
        while (true) {
            double segmentX = radiusX * 0.5522847498;
            double segmentY = radiusY * 0.5522847498;
            Point2D.Double point2 = new Point2D.Double(((Point2D)center).getX() + Math.cos(radians2) * radiusX, ((Point2D)center).getY() - Math.sin(radians2) * radiusY);
            double tangentialRadians1 = Math.atan(-(Math.pow(radiusY, 2.0) * (((Point2D)point1).getX() - ((Point2D)center).getX())) / (Math.pow(radiusX, 2.0) * (((Point2D)point1).getY() - ((Point2D)center).getY())));
            double segment1 = (segmentY * (1.0 - Math.abs(Math.sin(radians1))) + segmentX * (1.0 - Math.abs(Math.cos(radians1)))) * (radians2 - radians1) / 1.5707963267948966;
            Point2D.Double control1 = new Point2D.Double(((Point2D)point1).getX() + Math.abs(Math.cos(tangentialRadians1) * segment1) * Math.signum(-Math.sin(radians1)), ((Point2D)point1).getY() + Math.abs(Math.sin(tangentialRadians1) * segment1) * Math.signum(-Math.cos(radians1)));
            double tangentialRadians2 = Math.atan(-(Math.pow(radiusY, 2.0) * (((Point2D)point2).getX() - ((Point2D)center).getX())) / (Math.pow(radiusX, 2.0) * (((Point2D)point2).getY() - ((Point2D)center).getY())));
            double segment2 = (segmentY * (1.0 - Math.abs(Math.sin(radians2))) + segmentX * (1.0 - Math.abs(Math.cos(radians2)))) * (radians2 - radians1) / 1.5707963267948966;
            Point2D.Double control2 = new Point2D.Double(((Point2D)point2).getX() + Math.abs(Math.cos(tangentialRadians2) * segment2) * Math.signum(Math.sin(radians2)), ((Point2D)point2).getY() + Math.abs(Math.sin(tangentialRadians2) * segment2) * Math.signum(Math.cos(radians2)));
            this.drawCurve(point2, control1, control2);
            if (radians2 == endRadians) break;
            point1 = point2;
            radians1 = radians2;
            if ((radians2 += 1.5707963267948966) > endRadians) {
                radians2 = endRadians;
            }
            double quadrantRatio = (radians2 - radians1) / 1.5707963267948966;
            radiusX += branchWidth * quadrantRatio;
            radiusY += branchWidth * quadrantRatio;
            branchWidth *= branchRatio;
        }
    }

    private PdfName getFontName(Font value) {
        PdfName name;
        Resources resources = this.scanner.getContentContext().getResources();
        FontResources fonts = resources.getFonts();
        if (fonts == null) {
            fonts = new FontResources(this.scanner.getContents().getDocument());
            resources.setFonts(fonts);
            resources.update();
        }
        if ((name = ((PdfDictionary)fonts.getBaseDataObject()).getKey(value.getBaseObject())) == null) {
            int fontIndex = fonts.size();
            while (fonts.containsKey(name = new PdfName(String.valueOf(++fontIndex)))) {
            }
            fonts.put(name, value);
            fonts.update();
        }
        return name;
    }

    private PdfName getXObjectName(XObject value) {
        PdfName name;
        Resources resources = this.scanner.getContentContext().getResources();
        XObjectResources xObjects = resources.getXObjects();
        if (xObjects == null) {
            xObjects = new XObjectResources(this.scanner.getContents().getDocument());
            resources.setXObjects(xObjects);
            resources.update();
        }
        if ((name = ((PdfDictionary)xObjects.getBaseDataObject()).getKey(value.getBaseObject())) == null) {
            int xObjectIndex = xObjects.size();
            while (xObjects.containsKey(name = new PdfName(String.valueOf(++xObjectIndex)))) {
            }
            xObjects.put(name, value);
            xObjects.update();
        }
        return name;
    }

    private PdfName getColorSpaceName(ColorSpace value) {
        if (value instanceof DeviceGrayColorSpace) {
            return PdfName.DeviceGray;
        }
        if (value instanceof DeviceRGBColorSpace) {
            return PdfName.DeviceRGB;
        }
        if (value instanceof DeviceCMYKColorSpace) {
            return PdfName.DeviceCMYK;
        }
        throw new NotImplementedException("colorSpace MUST be converted to its associated name; you need to implement a method in PdfDictionary that, given a PdfDirectObject, returns its associated key.");
    }

    private void rotateText(double angle) {
        double rad = angle * Math.PI / 180.0;
        double cos = Math.cos(rad);
        double sin = Math.sin(rad);
        this.setTextMatrix(cos, sin, -sin, cos, 0.0, 0.0);
    }

    private void scaleText(double ratioX, double ratioY) {
        this.setTextMatrix(ratioX, 0.0, 0.0, ratioY, 0.0, 0.0);
    }

    private void setTextMatrix(double a, double b, double c, double d, double e, double f) {
        this.add(new SetTextMatrix(a, b, c, d, e, f));
    }

    private void translateText(double distanceX, double distanceY) {
        this.setTextMatrix(1.0, 0.0, 0.0, 1.0, distanceX, distanceY);
    }

    private void translateTextRelative(double offsetX, double offsetY) {
        this.add(new TranslateTextRelative(offsetX, -offsetY));
    }

    private void translateTextToNextLine() {
        this.add(TranslateTextToNextLine.Value);
    }
}

