/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.contents.composition;

import it.stefanochizzolini.clown.bytes.IOutputStream;
import it.stefanochizzolini.clown.documents.contents.ContentScanner;
import it.stefanochizzolini.clown.documents.contents.composition.AlignmentXEnum;
import it.stefanochizzolini.clown.documents.contents.composition.AlignmentYEnum;
import it.stefanochizzolini.clown.documents.contents.composition.PrimitiveFilter;
import it.stefanochizzolini.clown.documents.contents.composition.TextFitter;
import it.stefanochizzolini.clown.documents.contents.fonts.Font;
import it.stefanochizzolini.clown.documents.contents.objects.ContainerObject;
import it.stefanochizzolini.clown.documents.contents.objects.ContentObject;
import it.stefanochizzolini.clown.documents.contents.objects.LocalGraphicsState;
import it.stefanochizzolini.clown.documents.contents.objects.ModifyCTM;
import it.stefanochizzolini.clown.documents.contents.objects.Operation;
import it.stefanochizzolini.clown.documents.contents.objects.SetWordSpace;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public final class BlockFilter {
    private PrimitiveFilter context;
    private ContentScanner scanner;
    private AlignmentXEnum alignmentX;
    private AlignmentYEnum alignmentY;
    private boolean hyphenation;
    private Rectangle2D frame;
    private Rectangle2D.Double boundBox;
    private Row currentRow;
    private boolean rowEnded;
    private LocalGraphicsState container;

    public BlockFilter(PrimitiveFilter context) {
        this.context = context;
        this.scanner = context.getScanner();
    }

    public void begin(Rectangle2D frame, AlignmentXEnum alignmentX, AlignmentYEnum alignmentY) {
        this.frame = frame;
        this.alignmentX = alignmentX;
        this.alignmentY = alignmentY;
        this.container = this.context.beginLocalState();
        this.boundBox = new Rectangle2D.Double(frame.getX(), frame.getY(), frame.getWidth(), 0.0);
        this.beginRow();
    }

    public void end() {
        this.endRow(true);
        this.container.getObjects().add(0, new ModifyCTM(1.0, 0.0, 0.0, 1.0, this.boundBox.x, -this.boundBox.y));
        this.context.end();
    }

    public Rectangle2D getBoundBox() {
        return this.boundBox;
    }

    public ContentScanner getScanner() {
        return this.scanner;
    }

    public PrimitiveFilter getContext() {
        return this.context;
    }

    public Rectangle2D getFrame() {
        return this.frame;
    }

    public boolean isHyphenation() {
        return this.hyphenation;
    }

    public void setHyphenation(boolean value) {
        this.hyphenation = value;
    }

    public void showBreak() {
        this.endRow(true);
        this.beginRow();
    }

    public void showBreak(Dimension2D offset) {
        this.showBreak();
        this.currentRow.y += offset.getHeight();
        this.currentRow.width = offset.getWidth();
    }

    public void showBreak(AlignmentXEnum alignmentX) {
        this.showBreak();
        this.alignmentX = alignmentX;
    }

    public void showBreak(Dimension2D offset, AlignmentXEnum alignmentX) {
        this.showBreak(offset);
        this.alignmentX = alignmentX;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int showText(String text) {
        if (this.currentRow == null) return 0;
        if (text == null) {
            return 0;
        }
        ContentScanner.GraphicsState state = this.context.getState();
        Font font = state.font;
        double fontSize = state.fontSize;
        double lineHeight = font.getLineHeight(fontSize);
        TextFitter textFitter = new TextFitter(text, 0.0, font, fontSize, this.hyphenation);
        int textLength = text.length();
        int index = 0;
        block4: while (true) {
            if (this.currentRow.width == 0.0) {
                while (true) {
                    if (index == textLength) {
                        return index;
                    }
                    if (text.charAt(index) != ' ') break;
                    ++index;
                }
            }
            if (lineHeight > this.currentRow.height) {
                if (lineHeight > this.frame.getHeight() - this.currentRow.y) {
                    this.endRow(false);
                    return index;
                }
                this.currentRow.height = lineHeight;
            }
            if (textFitter.fit(index, this.frame.getWidth() - this.currentRow.width)) {
                String textChunk = textFitter.getFittedText();
                double textChunkWidth = textFitter.getFittedWidth();
                Point2D.Double textChunkLocation = new Point2D.Double(this.currentRow.width, this.currentRow.y);
                RowObject object = new RowObject(this.context.beginLocalState(), lineHeight, textChunkWidth, this.countOccurrence(' ', textChunk));
                this.currentRow.objects.add(object);
                this.currentRow.spaceCount += object.spaceCount;
                this.context.showText(textChunk, textChunkLocation);
                this.context.end();
                this.currentRow.width += textChunkWidth;
                index = textFitter.getEndIndex();
            }
            while (true) {
                if (index == textLength) {
                    return index;
                }
                switch (text.charAt(index)) {
                    case '\r': {
                        break;
                    }
                    case '\n': {
                        ++index;
                        this.showBreak();
                        continue block4;
                    }
                    default: {
                        this.endRow(false);
                        this.beginRow();
                        continue block4;
                    }
                }
                ++index;
            }
            break;
        }
    }

    private void beginRow() {
        this.rowEnded = false;
        this.currentRow = new Row((ContentPlaceholder)this.context.add(new ContentPlaceholder()), this.boundBox.height);
    }

    private int countOccurrence(char value, String text) {
        int count = 0;
        int fromIndex = 0;
        int foundIndex;
        while ((foundIndex = text.indexOf(value, fromIndex)) != -1) {
            ++count;
            fromIndex = foundIndex + 1;
        }
        return count;
    }

    private void endRow(boolean broken) {
        double xOffset;
        if (this.rowEnded) {
            return;
        }
        this.rowEnded = true;
        double[] objectXOffsets = new double[this.currentRow.objects.size()];
        double wordSpace = 0.0;
        double rowXOffset = 0.0;
        ArrayList<RowObject> objects = this.currentRow.objects;
        AlignmentXEnum alignmentX = this.alignmentX;
        switch (alignmentX) {
            case Left: {
                break;
            }
            case Right: {
                rowXOffset = this.frame.getWidth() - this.currentRow.width;
                break;
            }
            case Center: {
                rowXOffset = (this.frame.getWidth() - this.currentRow.width) / 2.0;
                break;
            }
            case Justify: {
                if (this.currentRow.spaceCount == 0 || broken) {
                    alignmentX = AlignmentXEnum.Left;
                    break;
                }
                wordSpace = (this.frame.getWidth() - this.currentRow.width) / (double)this.currentRow.spaceCount;
                int index = 1;
                int count = objects.size();
                while (index < count) {
                    objectXOffsets[index] = objectXOffsets[index - 1] + (double)((RowObject)objects.get((int)(index - 1))).spaceCount * wordSpace;
                    ++index;
                }
                break;
            }
        }
        SetWordSpace wordSpaceOperation = new SetWordSpace(wordSpace);
        int index = objects.size() - 1;
        while (index >= 0) {
            RowObject object = (RowObject)objects.get(index);
            double objectYOffset = 0.0;
            objectYOffset = -(this.currentRow.height - object.height);
            List<ContentObject> containedGraphics = object.container.getObjects();
            containedGraphics.add(0, wordSpaceOperation);
            containedGraphics.add(0, new ModifyCTM(1.0, 0.0, 0.0, 1.0, objectXOffsets[index] + rowXOffset, objectYOffset));
            --index;
        }
        this.boundBox.height = this.currentRow.y + this.currentRow.height;
        switch (this.alignmentY) {
            case Bottom: {
                xOffset = this.frame.getHeight() - this.boundBox.height;
                break;
            }
            case Middle: {
                xOffset = (this.frame.getHeight() - this.boundBox.height) / 2.0;
                break;
            }
            default: {
                xOffset = 0.0;
            }
        }
        this.boundBox.y = this.frame.getY() + xOffset;
        this.currentRow = null;
    }

    private static final class ContentPlaceholder
    extends Operation {
        public List<ContentObject> objects = new ArrayList<ContentObject>();

        public ContentPlaceholder() {
            super(null);
        }

        public List<ContentObject> getObjects() {
            return this.objects;
        }

        @Override
        public void writeTo(IOutputStream stream) {
            for (ContentObject object : this.objects) {
                object.writeTo(stream);
            }
        }
    }

    private static final class Row {
        public ArrayList<RowObject> objects = new ArrayList();
        public int spaceCount = 0;
        public ContentPlaceholder container;
        public double height;
        public double y;
        public double width;

        Row(ContentPlaceholder container, double y) {
            this.container = container;
            this.y = y;
        }
    }

    private static final class RowObject {
        public ContainerObject container;
        public double height;
        public double width;
        public int spaceCount;

        RowObject(ContainerObject container, double height, double width, int spaceCount) {
            this.container = container;
            this.height = height;
            this.width = width;
            this.spaceCount = spaceCount;
        }
    }
}

