/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.contents.colorSpaces;

import it.stefanochizzolini.clown.documents.contents.colorSpaces.DeviceColor;
import it.stefanochizzolini.clown.documents.contents.colorSpaces.DeviceRGBColorSpace;

public class DeviceRGBColor
extends DeviceColor {
    public static final DeviceRGBColor Black = new DeviceRGBColor(0.0, 0.0, 0.0);
    public static final DeviceRGBColor White = new DeviceRGBColor(1.0, 1.0, 1.0);
    public static final DeviceRGBColor Default = Black;
    private double blueComponent;
    private double greenComponent;
    private double redComponent;

    public DeviceRGBColor(double redComponent, double greenComponent, double blueComponent) {
        super(DeviceRGBColorSpace.Default);
        this.setRedComponent(redComponent);
        this.setGreenComponent(greenComponent);
        this.setBlueComponent(blueComponent);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DeviceRGBColor)) {
            return false;
        }
        DeviceRGBColor other = (DeviceRGBColor)object;
        return other.redComponent == this.redComponent && other.greenComponent == this.greenComponent && other.blueComponent == this.blueComponent;
    }

    public double getBlueComponent() {
        return this.blueComponent;
    }

    @Override
    public double[] getComponents() {
        return new double[]{this.redComponent, this.greenComponent, this.blueComponent};
    }

    public double getGreenComponent() {
        return this.greenComponent;
    }

    public double getRedComponent() {
        return this.redComponent;
    }

    public int hashCode() {
        return new Double(this.redComponent).hashCode() ^ new Double(this.greenComponent).hashCode() ^ new Double(this.blueComponent).hashCode();
    }

    public void setBlueComponent(double value) {
        this.blueComponent = DeviceRGBColor.normalizeComponent(value);
    }

    public void setGreenComponent(double value) {
        this.greenComponent = DeviceRGBColor.normalizeComponent(value);
    }

    public void setRedComponent(double value) {
        this.redComponent = DeviceRGBColor.normalizeComponent(value);
    }
}

