/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.contents;

import it.stefanochizzolini.clown.documents.contents.Contents;
import it.stefanochizzolini.clown.documents.contents.IContentContext;
import it.stefanochizzolini.clown.documents.contents.ITextString;
import it.stefanochizzolini.clown.documents.contents.LineCapEnum;
import it.stefanochizzolini.clown.documents.contents.LineDash;
import it.stefanochizzolini.clown.documents.contents.LineJoinEnum;
import it.stefanochizzolini.clown.documents.contents.TextChar;
import it.stefanochizzolini.clown.documents.contents.TextRenderModeEnum;
import it.stefanochizzolini.clown.documents.contents.TextStyle;
import it.stefanochizzolini.clown.documents.contents.colorSpaces.Color;
import it.stefanochizzolini.clown.documents.contents.colorSpaces.ColorSpace;
import it.stefanochizzolini.clown.documents.contents.colorSpaces.DeviceGrayColor;
import it.stefanochizzolini.clown.documents.contents.colorSpaces.DeviceGrayColorSpace;
import it.stefanochizzolini.clown.documents.contents.fonts.Font;
import it.stefanochizzolini.clown.documents.contents.objects.CompositeObject;
import it.stefanochizzolini.clown.documents.contents.objects.ContainerObject;
import it.stefanochizzolini.clown.documents.contents.objects.ContentObject;
import it.stefanochizzolini.clown.documents.contents.objects.InlineImage;
import it.stefanochizzolini.clown.documents.contents.objects.ShowText;
import it.stefanochizzolini.clown.documents.contents.objects.Text;
import it.stefanochizzolini.clown.documents.contents.objects.XObject;
import it.stefanochizzolini.clown.objects.PdfName;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class ContentScanner {
    private static final int StartIndex = -1;
    private ContentScanner childLevel;
    private Contents contents;
    private int index;
    private List<ContentObject> objects;
    private ContentScanner parentLevel;
    private GraphicsState state;

    public ContentScanner(Contents contents) {
        this.parentLevel = null;
        this.objects = this.contents = contents;
        this.moveStart();
    }

    public ContentScanner(IContentContext contentContext) {
        this(contentContext.getContents());
    }

    private ContentScanner(ContentScanner parentLevel) {
        this.parentLevel = parentLevel;
        this.contents = parentLevel.contents;
        this.objects = ((CompositeObject)parentLevel.getCurrent()).getObjects();
        this.moveStart();
    }

    public ContentScanner getChildLevel() {
        return this.childLevel;
    }

    public IContentContext getContentContext() {
        return this.contents.getContentContext();
    }

    public Contents getContents() {
        return this.contents;
    }

    public ContentObject getCurrent() {
        try {
            return this.objects.get(this.index);
        }
        catch (Exception e) {
            return null;
        }
    }

    public GraphicsObjectWrapper getCurrentWrapper() {
        return GraphicsObjectWrapper.get(this);
    }

    public int getIndex() {
        return this.index;
    }

    public CompositeObject getParent() {
        return this.parentLevel == null ? null : (CompositeObject)this.parentLevel.getCurrent();
    }

    public ContentScanner getParentLevel() {
        return this.parentLevel;
    }

    public GraphicsState getState() {
        return this.state;
    }

    public void insert(ContentObject object) {
        if (this.index == -1) {
            this.index = 0;
        }
        this.objects.add(this.index, object);
        this.refresh();
    }

    public void insert(Collection<? extends ContentObject> objects) {
        int index = 0;
        int size = objects.size();
        for (ContentObject contentObject : objects) {
            this.insert(contentObject);
            if (++index >= size) continue;
            this.moveNext();
        }
    }

    public boolean move(int index) {
        if (this.index > index) {
            this.moveStart();
        }
        while (this.index < index && this.moveNext()) {
        }
        return this.getCurrent() != null;
    }

    public void moveEnd() {
        this.moveLast();
        this.moveNext();
    }

    public boolean moveFirst() {
        this.moveStart();
        return this.moveNext();
    }

    public boolean moveLast() {
        int lastIndex = this.objects.size() - 1;
        while (this.index < lastIndex) {
            this.moveNext();
        }
        return this.getCurrent() != null;
    }

    public boolean moveNext() {
        ContentObject currentObject = this.getCurrent();
        if (currentObject != null) {
            currentObject.applyTo(this.state);
        }
        if (this.index < this.objects.size()) {
            ++this.index;
            this.refresh();
        }
        return this.getCurrent() != null;
    }

    public void moveStart() {
        this.index = -1;
        if (this.state == null) {
            this.state = this.parentLevel == null ? new GraphicsState(this) : this.parentLevel.state.clone(this);
        } else if (this.parentLevel == null) {
            this.state.initialize();
        } else {
            this.parentLevel.state.copyTo(this.state);
        }
        this.refresh();
    }

    public ContentObject remove() {
        ContentObject removedObject = this.objects.remove(this.index);
        this.refresh();
        return removedObject;
    }

    public ContentObject setCurrent(ContentObject value) {
        ContentObject replacedObject = this.objects.set(this.index, value);
        this.refresh();
        return replacedObject;
    }

    private void refresh() {
        this.childLevel = this.getCurrent() instanceof CompositeObject ? new ContentScanner(this) : null;
    }

    public static abstract class GraphicsObjectWrapper<TDataObject extends ContentObject> {
        protected Rectangle2D box;
        private TDataObject baseDataObject;

        private static GraphicsObjectWrapper get(ContentScanner scanner) {
            ContentObject object = scanner.getCurrent();
            if (object instanceof ShowText) {
                return new TextStringWrapper(scanner);
            }
            if (object instanceof Text) {
                return new TextWrapper(scanner);
            }
            if (object instanceof XObject) {
                return new XObjectWrapper(scanner);
            }
            if (object instanceof InlineImage) {
                return new InlineImageWrapper(scanner);
            }
            return null;
        }

        protected GraphicsObjectWrapper(TDataObject baseDataObject) {
            this.baseDataObject = baseDataObject;
        }

        public TDataObject getBaseDataObject() {
            return this.baseDataObject;
        }

        public Rectangle2D getBox() {
            return this.box;
        }
    }

    public static final class GraphicsState
    implements Cloneable {
        public double charSpace;
        public double[] ctm;
        public Color fillColor;
        public ColorSpace fillColorSpace;
        public Font font;
        public double fontSize;
        public double lead;
        public LineCapEnum lineCap;
        public LineDash lineDash;
        public LineJoinEnum lineJoin;
        public double lineWidth;
        public double miterLimit;
        public TextRenderModeEnum renderMode;
        public double rise;
        public double scale;
        public Color strokeColor;
        public ColorSpace strokeColorSpace;
        public double[] tlm;
        public double[] tm;
        public double wordSpace;
        private ContentScanner scanner;

        public static double[] concat(double[] matrix1, double[] matrix2) {
            double[] result = new double[]{matrix1[0] * matrix2[0] + matrix1[1] * matrix2[2], matrix1[0] * matrix2[1] + matrix1[1] * matrix2[3], matrix1[2] * matrix2[0] + matrix1[3] * matrix2[2], matrix1[2] * matrix2[1] + matrix1[3] * matrix2[3], matrix1[4] * matrix2[0] + matrix1[5] * matrix2[2] + 1.0 * matrix2[4], matrix1[4] * matrix2[1] + matrix1[5] * matrix2[3] + 1.0 * matrix2[5]};
            return result;
        }

        private GraphicsState(ContentScanner scanner) {
            this.scanner = scanner;
            this.initialize();
        }

        public GraphicsState clone() {
            GraphicsState clone;
            try {
                clone = (GraphicsState)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
            return clone;
        }

        public void copyTo(GraphicsState state) {
            ContentScanner stateScanner = state.scanner;
            Field[] fieldArray = GraphicsState.class.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                try {
                    field.set(state, field.get(this));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                ++n2;
            }
            state.scanner = stateScanner;
            if (!(state.scanner.getParent() instanceof Text)) {
                state.tlm = new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
                state.tm = new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
            }
        }

        public ContentScanner getScanner() {
            return this.scanner;
        }

        public Point2D textToDeviceSpace(Point2D point) {
            double[] trm = GraphicsState.concat(this.tm, this.ctm);
            return new Point2D.Double(trm[0] * point.getX() + trm[2] * point.getY() + trm[4], this.scanner.getContentContext().getBox().getHeight() - (trm[1] * point.getX() + trm[3] * point.getY() + trm[5]));
        }

        public Point2D userToDeviceSpace(Point2D point) {
            return new Point2D.Double(this.ctm[0] * point.getX() + this.ctm[2] * point.getY() + this.ctm[4], this.ctm[1] * point.getX() + this.ctm[3] * point.getY() + this.ctm[5]);
        }

        private GraphicsState clone(ContentScanner scanner) {
            GraphicsState state = this.clone();
            state.scanner = scanner;
            return state;
        }

        private void initialize() {
            this.charSpace = 0.0;
            this.ctm = new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
            this.fillColor = DeviceGrayColor.Default;
            this.fillColorSpace = DeviceGrayColorSpace.Default;
            this.font = null;
            this.fontSize = 0.0;
            this.lead = 0.0;
            this.lineCap = LineCapEnum.Butt;
            this.lineDash = new LineDash();
            this.lineJoin = LineJoinEnum.Miter;
            this.lineWidth = 1.0;
            this.miterLimit = 10.0;
            this.renderMode = TextRenderModeEnum.Fill;
            this.rise = 0.0;
            this.scale = 100.0;
            this.strokeColor = DeviceGrayColor.Default;
            this.strokeColorSpace = DeviceGrayColorSpace.Default;
            this.tlm = new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
            this.tm = new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
            this.wordSpace = 0.0;
        }
    }

    public static final class InlineImageWrapper
    extends GraphicsObjectWrapper<InlineImage> {
        private InlineImageWrapper(ContentScanner scanner) {
            super((InlineImage)scanner.getCurrent());
            double[] ctm = scanner.getState().ctm;
            this.box = new Rectangle2D.Double(ctm[4], scanner.getContentContext().getBox().getHeight() - ctm[5], ctm[0], Math.abs(ctm[3]));
        }

        public InlineImage getInlineImage() {
            return (InlineImage)this.getBaseDataObject();
        }
    }

    public static final class TextStringWrapper
    extends GraphicsObjectWrapper<ShowText>
    implements ITextString {
        private TextStyle style;
        private List<TextChar> textChars = new ArrayList<TextChar>();

        TextStringWrapper(ContentScanner scanner) {
            super((ShowText)scanner.getCurrent());
            GraphicsState state = scanner.getState();
            this.style = new TextStyle(state.font, state.fontSize, state.renderMode, state.strokeColor, state.strokeColorSpace, state.fillColor, state.fillColorSpace);
            ((ShowText)this.getBaseDataObject()).scan(state, new ShowText.IScanner(){

                @Override
                public void scanChar(char textChar, Rectangle2D textCharBox) {
                    TextStringWrapper.this.textChars.add(new TextChar(textChar, textCharBox, TextStringWrapper.this.style, false));
                }

                @Override
                public void scanFont(double fontSize) {
                    ((TextStringWrapper)TextStringWrapper.this).style.fontSize = fontSize;
                }
            });
        }

        @Override
        public Rectangle2D getBox() {
            if (this.box == null) {
                for (TextChar textChar : this.textChars) {
                    if (this.box == null) {
                        this.box = (Rectangle2D)textChar.box.clone();
                        continue;
                    }
                    this.box.add(textChar.box);
                }
            }
            return this.box;
        }

        public TextStyle getStyle() {
            return this.style;
        }

        @Override
        public String getText() {
            StringBuilder textBuilder = new StringBuilder();
            for (TextChar textChar : this.textChars) {
                textBuilder.append(textChar);
            }
            return textBuilder.toString();
        }

        @Override
        public List<TextChar> getTextChars() {
            return this.textChars;
        }
    }

    public static final class TextWrapper
    extends GraphicsObjectWrapper<Text> {
        private List<TextStringWrapper> textStrings = new ArrayList<TextStringWrapper>();

        private TextWrapper(ContentScanner scanner) {
            super((Text)scanner.getCurrent());
            this.extract(scanner.getChildLevel());
        }

        @Override
        public Rectangle2D getBox() {
            if (this.box == null) {
                for (TextStringWrapper textString : this.textStrings) {
                    if (this.box == null) {
                        this.box = (Rectangle2D)textString.getBox().clone();
                        continue;
                    }
                    this.box.add(textString.getBox());
                }
            }
            return this.box;
        }

        public List<TextStringWrapper> getTextStrings() {
            return this.textStrings;
        }

        /*
         * Unable to fully structure code
         */
        private void extract(ContentScanner level) {
            if (level != null) ** GOTO lbl10
            return;
lbl-1000:
            // 1 sources

            {
                content = level.getCurrent();
                if (content instanceof ShowText) {
                    this.textStrings.add((TextStringWrapper)level.getCurrentWrapper());
                    continue;
                }
                if (!(content instanceof ContainerObject)) continue;
                this.extract(level.getChildLevel());
lbl10:
                // 4 sources

                ** while (level.moveNext())
            }
lbl11:
            // 1 sources

        }
    }

    public static final class XObjectWrapper
    extends GraphicsObjectWrapper<XObject> {
        private PdfName name;
        private it.stefanochizzolini.clown.documents.contents.xObjects.XObject xObject;

        private XObjectWrapper(ContentScanner scanner) {
            super((XObject)scanner.getCurrent());
            IContentContext context = scanner.getContentContext();
            double[] ctm = scanner.getState().ctm;
            this.box = new Rectangle2D.Double(ctm[4], context.getBox().getHeight() - ctm[5], ctm[0], Math.abs(ctm[3]));
            this.name = ((XObject)this.getBaseDataObject()).getName();
            this.xObject = context.getResources().getXObjects().get(this.name);
        }

        public PdfName getName() {
            return this.name;
        }

        public it.stefanochizzolini.clown.documents.contents.xObjects.XObject getXObject() {
            return this.xObject;
        }
    }
}

