/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents;

import it.stefanochizzolini.clown.documents.DocumentActions;
import it.stefanochizzolini.clown.documents.Names;
import it.stefanochizzolini.clown.documents.Page;
import it.stefanochizzolini.clown.documents.PageFormat;
import it.stefanochizzolini.clown.documents.PageLayoutEnum;
import it.stefanochizzolini.clown.documents.PageModeEnum;
import it.stefanochizzolini.clown.documents.Pages;
import it.stefanochizzolini.clown.documents.contents.Resources;
import it.stefanochizzolini.clown.documents.interaction.forms.Form;
import it.stefanochizzolini.clown.documents.interaction.navigation.document.Bookmarks;
import it.stefanochizzolini.clown.documents.interaction.navigation.document.Destination;
import it.stefanochizzolini.clown.documents.interaction.viewer.ViewerPreferences;
import it.stefanochizzolini.clown.documents.interchange.metadata.Information;
import it.stefanochizzolini.clown.files.File;
import it.stefanochizzolini.clown.objects.IPdfNumber;
import it.stefanochizzolini.clown.objects.PdfArray;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfObjectWrapper;
import it.stefanochizzolini.clown.objects.PdfReal;
import it.stefanochizzolini.clown.objects.PdfReference;
import it.stefanochizzolini.clown.objects.PdfString;
import it.stefanochizzolini.clown.objects.Rectangle;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;

public class Document
extends PdfObjectWrapper<PdfDictionary> {
    public Hashtable<PdfReference, Object> cache = new Hashtable();

    public static <T extends PdfObjectWrapper<?>> T resolve(Class<T> type, PdfDirectObject baseObject, PdfIndirectObject container) {
        if (Destination.class.isAssignableFrom(type)) {
            return (T)Destination.wrap(baseObject, container, null);
        }
        throw new UnsupportedOperationException("Type '" + type.getName() + "' wrapping is not supported.");
    }

    public static <T extends PdfObjectWrapper<?>> T resolveName(Class<T> type, PdfDirectObject namedBaseObject, PdfIndirectObject container) {
        if (namedBaseObject instanceof PdfString) {
            return container.getFile().getDocument().getNames().resolve(type, (PdfString)namedBaseObject);
        }
        return Document.resolve(type, namedBaseObject, container);
    }

    public Document(File context) {
        super(context, new PdfDictionary(new PdfName[]{PdfName.Type}, new PdfDirectObject[]{PdfName.Catalog}));
        context.getTrailer().put(PdfName.Root, this.getBaseObject());
        this.setPages(new Pages(this));
        this.setPageSize(PageFormat.getSize());
        this.setResources(new Resources(this));
    }

    public Document(PdfDirectObject baseObject) {
        super(baseObject, null);
    }

    @Override
    public Document clone(Document context) {
        throw new NotImplementedException();
    }

    public Object contextualize(PdfObjectWrapper<?> object) {
        if (object.getFile() == this.getFile()) {
            return object;
        }
        return object.clone(this);
    }

    public Collection<? extends PdfObjectWrapper<?>> contextualize(Collection<? extends PdfObjectWrapper<?>> objects) {
        ArrayList<PdfObjectWrapper> contextualizedObjects = new ArrayList<PdfObjectWrapper>(objects.size());
        for (PdfObjectWrapper<?> object : objects) {
            contextualizedObjects.add((PdfObjectWrapper)this.contextualize(object));
        }
        return contextualizedObjects;
    }

    public void decontextualize(PdfObjectWrapper<?> object) {
        if (object.getFile() != this.getFile()) {
            return;
        }
        object.delete();
    }

    public void decontextualize(Collection<? extends PdfObjectWrapper<?>> objects) {
        for (PdfObjectWrapper<?> object : objects) {
            this.decontextualize(object);
        }
    }

    public DocumentActions getActions() {
        PdfDirectObject actionsObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.AA);
        if (actionsObject == null) {
            return null;
        }
        return new DocumentActions(actionsObject, this.getContainer());
    }

    public Bookmarks getBookmarks() {
        PdfDirectObject bookmarksObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.Outlines);
        if (bookmarksObject == null) {
            return null;
        }
        return new Bookmarks(bookmarksObject);
    }

    public Form getForm() {
        PdfDirectObject formObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.AcroForm);
        if (formObject == null) {
            return null;
        }
        return new Form(formObject, this.getContainer());
    }

    public Information getInformation() {
        PdfDirectObject informationObject = this.getFile().getTrailer().get(PdfName.Info);
        if (informationObject == null) {
            return null;
        }
        return new Information(informationObject);
    }

    public Names getNames() {
        PdfDirectObject namesObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.Names);
        if (namesObject == null) {
            return null;
        }
        return new Names(namesObject, ((PdfReference)this.getBaseObject()).getIndirectObject());
    }

    public PageLayoutEnum getPageLayout() {
        PdfName value = (PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.PageLayout);
        if (value.equals(PdfName.OneColumn)) {
            return PageLayoutEnum.OneColumn;
        }
        if (value.equals(PdfName.TwoColumnLeft)) {
            return PageLayoutEnum.TwoColumns;
        }
        return PageLayoutEnum.SinglePage;
    }

    public PageModeEnum getPageMode() {
        PdfName value = (PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.PageMode);
        if (value.equals(PdfName.UseOutlines)) {
            return PageModeEnum.Outlines;
        }
        if (value.equals(PdfName.UseThumbs)) {
            return PageModeEnum.Thumbnails;
        }
        if (value.equals(PdfName.FullScreen)) {
            return PageModeEnum.FullScreen;
        }
        return PageModeEnum.Simple;
    }

    public Pages getPages() {
        return new Pages(((PdfDictionary)this.getBaseDataObject()).get(PdfName.Pages));
    }

    public Dimension2D getPageSize() {
        PdfArray box = this.getMediaBox();
        if (box == null) {
            return null;
        }
        return new Dimension((int)((IPdfNumber)((Object)box.get(2))).getNumberValue(), (int)((IPdfNumber)((Object)box.get(3))).getNumberValue());
    }

    public Resources getResources() {
        PdfReference pages = (PdfReference)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Pages);
        PdfDirectObject resources = ((PdfDictionary)File.resolve(pages)).get(PdfName.Resources);
        if (resources == null) {
            return null;
        }
        return new Resources(resources, pages.getIndirectObject());
    }

    public Dimension2D getSize() {
        int height = 0;
        int width = 0;
        for (Page page : this.getPages()) {
            Dimension2D pageSize = page.getSize();
            if (pageSize == null) continue;
            height = Math.max(height, (int)pageSize.getHeight());
            width = Math.max(width, (int)pageSize.getWidth());
        }
        return new Dimension(width, height);
    }

    public String getVersion() {
        String[] versionDigits;
        String[] fileVersionDigits;
        String fileVersion = this.getFile().getVersion();
        PdfName versionObject = (PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Version);
        if (versionObject == null) {
            return fileVersion;
        }
        String version = (String)versionObject.getRawValue();
        if (this.getFile().getReader() == null) {
            return version;
        }
        try {
            fileVersionDigits = fileVersion.split("\\.");
            versionDigits = version.split("\\.");
        }
        catch (Exception exception) {
            throw new RuntimeException("Version decomposition failed.", exception);
        }
        try {
            if (Integer.parseInt(versionDigits[0]) > Integer.parseInt(fileVersionDigits[0]) || Integer.parseInt(versionDigits[0]) == Integer.parseInt(fileVersionDigits[0]) && Integer.parseInt(versionDigits[1]) > Integer.parseInt(fileVersionDigits[1])) {
                return version;
            }
            return fileVersion;
        }
        catch (Exception exception) {
            throw new RuntimeException("Wrong version format.", exception);
        }
    }

    public ViewerPreferences getViewerPreferences() {
        PdfDirectObject viewerPreferences = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.ViewerPreferences);
        if (viewerPreferences == null) {
            return null;
        }
        return new ViewerPreferences(viewerPreferences, ((PdfReference)this.getBaseObject()).getIndirectObject());
    }

    public void setActions(DocumentActions value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.AA, value.getBaseObject());
    }

    public void setBookmarks(Bookmarks value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Outlines, value.getBaseObject());
    }

    public void setForm(Form value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.AcroForm, value.getBaseObject());
    }

    public void setInformation(Information value) {
        this.getFile().getTrailer().put(PdfName.Info, value.getBaseObject());
    }

    public void setNames(Names value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Names, value.getBaseObject());
    }

    public void setPageLayout(PageLayoutEnum value) {
        switch (value) {
            case SinglePage: {
                ((PdfDictionary)this.getBaseDataObject()).put(PdfName.PageLayout, PdfName.SinglePage);
                break;
            }
            case OneColumn: {
                ((PdfDictionary)this.getBaseDataObject()).put(PdfName.PageLayout, PdfName.OneColumn);
                break;
            }
            case TwoColumns: {
                ((PdfDictionary)this.getBaseDataObject()).put(PdfName.PageLayout, PdfName.TwoColumnLeft);
            }
        }
    }

    public void setPageMode(PageModeEnum value) {
        switch (value) {
            case Simple: {
                ((PdfDictionary)this.getBaseDataObject()).put(PdfName.PageMode, PdfName.UseNone);
                break;
            }
            case Outlines: {
                ((PdfDictionary)this.getBaseDataObject()).put(PdfName.PageMode, PdfName.UseOutlines);
                break;
            }
            case Thumbnails: {
                ((PdfDictionary)this.getBaseDataObject()).put(PdfName.PageMode, PdfName.UseThumbs);
                break;
            }
            case FullScreen: {
                ((PdfDictionary)this.getBaseDataObject()).put(PdfName.PageMode, PdfName.FullScreen);
            }
        }
    }

    public void setPages(Pages value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Pages, value.getBaseObject());
    }

    public void setPageSize(Dimension2D value) {
        PdfArray mediaBox = this.getMediaBox();
        if (mediaBox == null) {
            mediaBox = (PdfArray)new Rectangle(0.0, 0.0, 0.0, 0.0).getBaseDataObject();
            ((PdfDictionary)File.resolve(((PdfDictionary)this.getBaseDataObject()).get(PdfName.Pages))).put(PdfName.MediaBox, mediaBox);
        }
        mediaBox.set(2, new PdfReal(value.getWidth()));
        mediaBox.set(3, new PdfReal(value.getHeight()));
    }

    public void setResources(Resources value) {
        PdfReference pages = (PdfReference)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Pages);
        ((PdfDictionary)File.resolve(pages)).put(PdfName.Resources, value.getBaseObject());
        value.setContainer(pages.getIndirectObject());
    }

    public void setVersion(String value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Version, new PdfName(value));
    }

    public void setViewerPreferences(ViewerPreferences value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.ViewerPreferences, value.getBaseObject());
        value.setContainer(((PdfReference)this.getBaseObject()).getIndirectObject());
    }

    private PdfArray getMediaBox() {
        return (PdfArray)((PdfDictionary)((PdfDictionary)this.getBaseDataObject()).resolve(PdfName.Pages)).resolve(PdfName.MediaBox);
    }
}

