/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.bytes.filters;

import it.stefanochizzolini.clown.bytes.filters.Filter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class FlateFilter
extends Filter {
    FlateFilter() {
    }

    @Override
    public byte[] decode(byte[] data, int offset, int length) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            InflaterInputStream inputFilter = new InflaterInputStream(new ByteArrayInputStream(data, offset, length));
            this.transform(inputFilter, outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Decoding failed.", e);
        }
        return outputStream.toByteArray();
    }

    @Override
    public byte[] encode(byte[] data, int offset, int length) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            DeflaterOutputStream outputFilter = new DeflaterOutputStream(outputStream);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data, offset, length);
            this.transform(inputStream, outputFilter);
        }
        catch (IOException e) {
            throw new RuntimeException("Encoding failed.", e);
        }
        return outputStream.toByteArray();
    }

    private void transform(InputStream input, OutputStream output) throws IOException {
        int bufferLength;
        byte[] buffer = new byte[8192];
        while ((bufferLength = input.read(buffer, 0, buffer.length)) != -1) {
            output.write(buffer, 0, bufferLength);
        }
        input.close();
        output.close();
    }
}

