/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.epsg31287;

import com.jhlabs.map.proj.ProjectionFactory;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionSubPrefs;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectionEPSG31287
implements Projection,
ProjectionSubPrefs {
    private double dx = 85.0;
    private double dy = 45.0;
    private static final String projCode = "EPSG:31287";
    private final com.jhlabs.map.proj.Projection projection = ProjectionFactory.fromPROJ4Specification(new String[]{"+proj=lcc", "+lat_1=49", "+lat_2=46", "+lat_0=47.5", "+lon_0=13.33333333333333", "+x_0=400000", "+y_0=400000", "+ellps=bessel", "+towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232", "+units=m", "+no_defs"});

    public void setupPreferencePanel(JPanel p) {
        p.setLayout(new GridBagLayout());
        JTextField gdx = new JTextField("" + this.dx);
        JTextField gdy = new JTextField("" + this.dy);
        p.add((Component)new JLabel(I18n.tr((String)"dx")), GBC.std().insets(5, 5, 0, 5));
        p.add(GBC.glue((int)1, (int)0), GBC.std().fill(2));
        p.add((Component)gdx, GBC.eop().fill(2));
        p.add((Component)new JLabel(I18n.tr((String)"dy")), GBC.std().insets(5, 5, 0, 5));
        p.add(GBC.glue((int)1, (int)0), GBC.std().fill(2));
        p.add((Component)gdy, GBC.eop().fill(2));
        p.add(GBC.glue((int)1, (int)1), GBC.eol().fill(1));
    }

    public Collection<String> getPreferences(JPanel p) {
        this.dx = new Double(((JTextField)p.getComponent(2)).getText());
        this.dy = new Double(((JTextField)p.getComponent(5)).getText());
        return Arrays.asList("" + this.dx, "" + this.dy);
    }

    public Collection<String> getPreferencesFromCode(String code) {
        this.dx = 85.0;
        this.dy = 45.0;
        return null;
    }

    public void setPreferences(Collection<String> args) {
        if (args != null) {
            String[] array = args.toArray(new String[0]);
            if (array.length > 0) {
                try {
                    this.dx = Double.parseDouble(array[0]);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (array.length > 1) {
                try {
                    this.dy = Double.parseDouble(array[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public double getDefaultZoomInPPD() {
        return 1.01;
    }

    public EastNorth latlon2eastNorth(LatLon p) {
        Point2D.Double c = new Point2D.Double();
        c.x = p.lon();
        c.y = p.lat();
        this.projection.transform(c, c);
        return new EastNorth(c.x + this.dx, c.y + this.dy);
    }

    public LatLon eastNorth2latlon(EastNorth p) {
        Point2D.Double c = new Point2D.Double();
        c.x = p.east() - this.dx;
        c.y = p.north() - this.dy;
        this.projection.inverseTransform(c, c);
        return new LatLon(c.y, c.x);
    }

    public String toString() {
        return I18n.tr((String)"EPSG:31287 - Bessel 1841 in Lambert Conformal Conic");
    }

    public String toCode() {
        return projCode;
    }

    public String getCacheDirectoryName() {
        return "EPSG_31287";
    }

    public Bounds getWorldBoundsLatLon() {
        return new Bounds(new LatLon(45.4, 8.7), new LatLon(49.4, 17.5));
    }

    public static String getProjCode() {
        return projCode;
    }
}

