/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.slippymap;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.gui.jmapviewer.OsmTileSource;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.bbox.SlippyMapBBoxChooser;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.slippymap.SlippyMapLayer;
import org.openstreetmap.josm.plugins.slippymap.SlippyMapPreferenceSetting;
import org.openstreetmap.josm.plugins.slippymap.SlippyMapPreferences;

public class SlippyMapPlugin
extends Plugin
implements Preferences.PreferenceChangedListener {
    public SlippyMapPlugin(PluginInformation info) {
        super(info);
        Main.pref.addPreferenceChangeListener((Preferences.PreferenceChangedListener)this);
        SlippyMapBBoxChooser.addTileSourceProvider((SlippyMapBBoxChooser.TileSourceProvider)new SlippyMapBBoxChooser.TileSourceProvider(){

            public List<TileSource> getTileSources() {
                ArrayList<TileSource> result = new ArrayList<TileSource>();
                for (TileSource ts : SlippyMapPreferences.getAllMapSources()) {
                    if (ts instanceof OsmTileSource.Mapnik || ts instanceof OsmTileSource.CycleMap || ts instanceof OsmTileSource.TilesAtHome) continue;
                    result.add(ts);
                }
                return result;
            }
        });
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (newFrame != null && SlippyMapPreferences.getMapSource() != SlippyMapPreferences.NO_DEFAULT_TILE_SOURCE) {
            SlippyMapLayer smlayer = new SlippyMapLayer();
            Main.main.addLayer((Layer)smlayer);
        }
    }

    public PreferenceSetting getPreferenceSetting() {
        return new SlippyMapPreferenceSetting();
    }

    public void preferenceChanged(Preferences.PreferenceChangeEvent event) {
        SlippyMapLayer layer;
        if (!Main.isDisplayingMapView()) {
            return;
        }
        List layes = Main.map.mapView.getLayersOfType(SlippyMapLayer.class);
        assert (layes.size() <= 1);
        SlippyMapLayer slippyMapLayer = layer = layes.isEmpty() ? null : (SlippyMapLayer)layes.get(0);
        if (event.getKey().equals("slippymap.tile_source")) {
            if (layer == null && SlippyMapPreferences.getMapSource() != SlippyMapPreferences.NO_DEFAULT_TILE_SOURCE) {
                Main.map.mapView.addLayer((Layer)new SlippyMapLayer());
            } else if (layer != null && SlippyMapPreferences.getMapSource() == SlippyMapPreferences.NO_DEFAULT_TILE_SOURCE) {
                Main.map.mapView.removeLayer((Layer)layer);
            } else if (layer != null || SlippyMapPreferences.getMapSource() != SlippyMapPreferences.NO_DEFAULT_TILE_SOURCE) {
                layer.newTileStorage();
            }
        } else if (event.getKey().startsWith("slippymap") && layer != null) {
            if (!event.getKey().equals("slippymap.fade_background")) {
                layer.autoZoomPopup.setSelected(SlippyMapPreferences.getAutozoom());
            }
            layer.redraw();
        }
    }
}

