/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.slippymap;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.openstreetmap.gui.jmapviewer.JobDispatcher;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.OsmFileCacheTileLoader;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.slippymap.SlippyMapPreferences;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlippyMapLayer
extends Layer
implements ImageObserver,
TileLoaderListener {
    boolean debug = false;
    protected MemoryTileCache tileCache;
    protected TileSource tileSource;
    protected TileLoader tileLoader;
    JobDispatcher jobDispatcher = JobDispatcher.getInstance();
    HashSet<Tile> tileRequestsOutstanding = new HashSet();
    public int currentZoomLevel;
    LatLon lastTopLeft;
    LatLon lastBotRight;
    private Image bufferImage;
    private Tile clickedTile;
    private boolean needRedraw;
    private JPopupMenu tileOptionMenu;
    JCheckBoxMenuItem autoZoomPopup;
    Tile showMetadataTile;
    Image lastScaledImage = null;
    Double lastImageScale = null;
    boolean az_disable = false;

    void out(String s) {
        Main.debug((String)s);
    }

    public synchronized void tileLoadingFinished(Tile tile, boolean success) {
        tile.setLoaded(true);
        this.needRedraw = true;
        Main.map.repaint(100L);
        this.tileRequestsOutstanding.remove(tile);
        if (this.debug) {
            this.out("tileLoadingFinished() tile: " + tile + " success: " + success);
        }
    }

    public TileCache getTileCache() {
        return this.tileCache;
    }

    void clearTileCache() {
        if (this.debug) {
            this.out("clearing tile storage");
        }
        this.tileCache = new MemoryTileCache();
        this.tileCache.setCacheSize(200);
    }

    void redraw() {
        this.needRedraw = true;
        Main.map.repaint();
    }

    void newTileStorage() {
        int origZoom = this.currentZoomLevel;
        this.tileSource = SlippyMapPreferences.getMapSource();
        if (this.tileSource.getMaxZoom() < this.currentZoomLevel) {
            this.currentZoomLevel = this.tileSource.getMaxZoom();
        }
        if (this.tileSource.getMinZoom() > this.currentZoomLevel) {
            this.currentZoomLevel = this.tileSource.getMinZoom();
        }
        if (this.currentZoomLevel != origZoom) {
            this.out("changed currentZoomLevel loading new tile store from " + origZoom + " to " + this.currentZoomLevel);
            this.out("tileSource.getMinZoom(): " + this.tileSource.getMinZoom());
            this.out("tileSource.getMaxZoom(): " + this.tileSource.getMaxZoom());
            SlippyMapPreferences.setLastZoom(this.currentZoomLevel);
        }
        this.clearTileCache();
        this.tileLoader = new OsmFileCacheTileLoader((TileLoaderListener)this);
    }

    public SlippyMapLayer() {
        super(I18n.tr((String)"Slippy Map"));
        this.setBackgroundLayer(true);
        this.setVisible(true);
        this.currentZoomLevel = SlippyMapPreferences.getLastZoom();
        this.newTileStorage();
        this.tileOptionMenu = new JPopupMenu();
        this.autoZoomPopup = new JCheckBoxMenuItem();
        this.autoZoomPopup.setAction(new AbstractAction(I18n.tr((String)"Auto Zoom")){

            public void actionPerformed(ActionEvent ae) {
                boolean new_state = !SlippyMapPreferences.getAutozoom();
                SlippyMapPreferences.setAutozoom(new_state);
            }
        });
        this.autoZoomPopup.setSelected(SlippyMapPreferences.getAutozoom());
        this.tileOptionMenu.add(this.autoZoomPopup);
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Load Tile")){

            public void actionPerformed(ActionEvent ae) {
                if (SlippyMapLayer.this.clickedTile != null) {
                    SlippyMapLayer.this.loadTile(SlippyMapLayer.this.clickedTile);
                    SlippyMapLayer.this.redraw();
                }
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Show Tile Info")){

            public void actionPerformed(ActionEvent ae) {
                SlippyMapLayer.this.out("info tile: " + SlippyMapLayer.this.clickedTile);
                if (SlippyMapLayer.this.clickedTile != null) {
                    SlippyMapLayer.this.showMetadataTile = SlippyMapLayer.this.clickedTile;
                    SlippyMapLayer.this.redraw();
                }
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Load All Tiles")){

            public void actionPerformed(ActionEvent ae) {
                SlippyMapLayer.this.loadAllTiles(true);
                SlippyMapLayer.this.redraw();
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Increase zoom")){

            public void actionPerformed(ActionEvent ae) {
                SlippyMapLayer.this.increaseZoomLevel();
                SlippyMapLayer.this.redraw();
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Decrease zoom")){

            public void actionPerformed(ActionEvent ae) {
                SlippyMapLayer.this.decreaseZoomLevel();
                SlippyMapLayer.this.redraw();
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Snap to tile size")){

            public void actionPerformed(ActionEvent ae) {
                if (SlippyMapLayer.this.lastImageScale == null) {
                    SlippyMapLayer.this.out("please wait for a tile to be loaded before snapping");
                    return;
                }
                double new_factor = Math.sqrt(SlippyMapLayer.this.lastImageScale);
                if (SlippyMapLayer.this.debug) {
                    SlippyMapLayer.this.out("tile snap: scale was: " + SlippyMapLayer.this.lastImageScale + ", new factor: " + new_factor);
                }
                Main.map.mapView.zoomToFactor(new_factor);
                SlippyMapLayer.this.redraw();
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Flush Tile Cache")){

            public void actionPerformed(ActionEvent ae) {
                System.out.print("flushing all tiles...");
                SlippyMapLayer.this.clearTileCache();
                System.out.println("done");
            }
        }));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Main.map.mapView.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        if (e.getButton() != 3) {
                            return;
                        }
                        SlippyMapLayer.this.clickedTile = SlippyMapLayer.this.getTileForPixelpos(e.getX(), e.getY());
                        SlippyMapLayer.this.tileOptionMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                });
                MapView.addLayerChangeListener((MapView.LayerChangeListener)new MapView.LayerChangeListener(){

                    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
                    }

                    public void layerAdded(Layer newLayer) {
                    }

                    public void layerRemoved(Layer oldLayer) {
                        MapView.removeLayerChangeListener((MapView.LayerChangeListener)this);
                    }
                });
            }
        });
    }

    void zoomChanged() {
        if (this.debug) {
            this.out("zoomChanged(): " + this.currentZoomLevel);
        }
        this.needRedraw = true;
        this.jobDispatcher.cancelOutstandingJobs();
        this.tileRequestsOutstanding.clear();
        SlippyMapPreferences.setLastZoom(this.currentZoomLevel);
    }

    int getMaxZoomLvl() {
        int ret = SlippyMapPreferences.getMaxZoomLvl();
        if (this.tileSource.getMaxZoom() < ret) {
            ret = this.tileSource.getMaxZoom();
        }
        return ret;
    }

    int getMinZoomLvl() {
        int ret = SlippyMapPreferences.getMinZoomLvl();
        if (this.tileSource.getMinZoom() > ret) {
            ret = this.tileSource.getMinZoom();
        }
        return ret;
    }

    public boolean zoomIncreaseAllowed() {
        boolean zia;
        boolean bl = zia = this.currentZoomLevel < this.getMaxZoomLvl();
        if (this.debug) {
            this.out("zoomIncreaseAllowed(): " + zia + " " + this.currentZoomLevel + " vs. " + this.getMaxZoomLvl());
        }
        return zia;
    }

    public boolean increaseZoomLevel() {
        this.lastImageScale = null;
        if (this.zoomIncreaseAllowed()) {
            ++this.currentZoomLevel;
            if (this.debug) {
                this.out("increasing zoom level to: " + this.currentZoomLevel);
            }
        } else {
            System.err.println("current zoom lvl (" + this.currentZoomLevel + ") couldnt be increased. " + "MaxZoomLvl (" + this.getMaxZoomLvl() + ") reached.");
            return false;
        }
        this.zoomChanged();
        return true;
    }

    public boolean zoomDecreaseAllowed() {
        return this.currentZoomLevel > this.getMinZoomLvl();
    }

    public boolean decreaseZoomLevel() {
        int minZoom = this.getMinZoomLvl();
        this.lastImageScale = null;
        if (this.zoomDecreaseAllowed()) {
            if (this.debug) {
                this.out("decreasing zoom level to: " + this.currentZoomLevel);
            }
            --this.currentZoomLevel;
        } else {
            System.err.println("current zoom lvl couldnt be decreased. MinZoomLvl(" + minZoom + ") reached.");
            return false;
        }
        this.zoomChanged();
        return true;
    }

    synchronized Tile tempCornerTile(Tile t) {
        int zoom;
        int y;
        int x = t.getXtile() + 1;
        Tile tile = this.getTile(x, y = t.getYtile() + 1, zoom = t.getZoom());
        if (tile != null) {
            return tile;
        }
        return new Tile(this.tileSource, x, y, zoom);
    }

    synchronized Tile getOrCreateTile(int x, int y, int zoom) {
        Tile tile = this.getTile(x, y, zoom);
        if (tile == null) {
            tile = new Tile(this.tileSource, x, y, zoom);
            this.tileCache.addTile(tile);
            tile.loadPlaceholderFromCache((TileCache)this.tileCache);
        }
        return tile;
    }

    synchronized Tile getTile(int x, int y, int zoom) {
        int max = 1 << zoom;
        if (x < 0 || x >= max || y < 0 || y >= max) {
            return null;
        }
        Tile tile = this.tileCache.getTile(this.tileSource, x, y, zoom);
        return tile;
    }

    synchronized boolean loadTile(Tile tile) {
        if (tile == null) {
            return false;
        }
        if (tile.hasError()) {
            return false;
        }
        if (tile.isLoaded()) {
            return false;
        }
        if (tile.isLoading()) {
            return false;
        }
        if (this.tileRequestsOutstanding.contains(tile)) {
            return false;
        }
        this.tileRequestsOutstanding.add(tile);
        this.jobDispatcher.addJob(this.tileLoader.createTileLoaderJob(this.tileSource, tile.getXtile(), tile.getYtile(), tile.getZoom()));
        return true;
    }

    void loadAllTiles(boolean force) {
        LatLon botRight;
        MapView mv = Main.map.mapView;
        LatLon topLeft = mv.getLatLon(0, 0);
        TileSet ts = new TileSet(topLeft, botRight = mv.getLatLon(mv.getWidth(), mv.getHeight()), this.currentZoomLevel);
        if (ts.tooLarge()) {
            System.out.println("Not downloading all tiles because there is more than 18 tiles on an axis!");
            return;
        }
        ts.loadAllTiles(force);
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        boolean done = (infoflags & 0x70) != 0;
        this.needRedraw = true;
        if (this.debug) {
            this.out("imageUpdate() done: " + done + " calling repaint");
        }
        Main.map.repaint(done ? 0L : 100L);
        return !done;
    }

    boolean imageLoaded(Image i) {
        if (i == null) {
            return false;
        }
        int status = Toolkit.getDefaultToolkit().checkImage(i, -1, -1, this);
        return (status & 0x20) != 0;
    }

    Image getLoadedTileImage(Tile tile) {
        if (!tile.isLoaded()) {
            return null;
        }
        BufferedImage img = tile.getImage();
        if (!this.imageLoaded(img)) {
            return null;
        }
        return img;
    }

    double getImageScaling(Image img, Rectangle r) {
        int realWidth = -1;
        int realHeight = -1;
        if (img != null) {
            realWidth = img.getHeight(this);
            realWidth = img.getWidth(this);
        }
        if (realWidth == -1 || realHeight == -1) {
            if (this.lastScaledImage != null) {
                return this.getImageScaling(this.lastScaledImage, r);
            }
            realWidth = 256;
            realHeight = 256;
        } else {
            this.lastScaledImage = img;
        }
        double drawWidth = r.width;
        double drawHeight = r.height;
        double drawArea = drawWidth * drawHeight;
        double realArea = realWidth * realHeight;
        return drawArea / realArea;
    }

    LatLon tileLatLon(Tile t) {
        int zoom = t.getZoom();
        return new LatLon(this.tileYToLat(t.getYtile(), zoom), this.tileXToLon(t.getXtile(), zoom));
    }

    int paintFromOtherZooms(Graphics g, Tile topLeftTile, Tile botRightTile) {
        LatLon topLeft = this.tileLatLon(topLeftTile);
        LatLon botRight = this.tileLatLon(botRightTile);
        int[] otherZooms = new int[]{-1, 1, -2, 2, -3, -4, -5};
        int painted = 0;
        this.debug = true;
        for (int zoomOff : otherZooms) {
            int zoom = this.currentZoomLevel + zoomOff;
            if (zoom < this.getMinZoomLvl() || zoom > this.getMaxZoomLvl()) continue;
            TileSet ts = new TileSet(topLeft, botRight, zoom);
            int zoom_painted = 0;
            this.paintTileImages(g, ts, zoom, null);
            if (this.debug && zoom_painted > 0) {
                this.out("painted " + zoom_painted + "/" + ts.size() + " tiles from zoom(" + zoomOff + "): " + zoom);
            }
            painted += zoom_painted;
            if (!((double)zoom_painted >= ts.size())) continue;
            if (!this.debug) break;
            this.out("broke after drawing " + zoom_painted + "/" + ts.size() + " at zoomOff: " + zoomOff);
            break;
        }
        this.debug = false;
        return painted;
    }

    Rectangle tileToRect(Tile t1) {
        Tile t2 = this.tempCornerTile(t1);
        Rectangle rect = new Rectangle(this.pixelPos(t1));
        rect.add(this.pixelPos(t2));
        return rect;
    }

    void drawImageInside(Graphics g, Image sourceImg, Rectangle source, Rectangle border) {
        Rectangle target = source;
        if (border != null) {
            target = source.intersection(border);
            if (this.debug) {
                this.out("source: " + source + "\nborder: " + border + "\nintersection: " + target);
            }
        }
        double imageYScaling = (double)sourceImg.getHeight(this) / source.getHeight();
        double imageXScaling = (double)sourceImg.getWidth(this) / source.getWidth();
        int screen_x_offset = target.x - source.x;
        int screen_y_offset = target.y - source.y;
        int img_x_offset = (int)((double)screen_x_offset * imageXScaling);
        int img_y_offset = (int)((double)screen_y_offset * imageYScaling);
        int img_x_end = img_x_offset + (int)(target.getWidth() * imageXScaling);
        int img_y_end = img_y_offset + (int)(target.getHeight() * imageYScaling);
        if (this.debug) {
            this.out("drawing image into target rect: " + target);
        }
        g.drawImage(sourceImg, target.x, target.y, target.x + target.width, target.y + target.height, img_x_offset, img_y_offset, img_x_end, img_y_end, this);
        float fadeBackground = SlippyMapPreferences.getFadeBackground();
        if (fadeBackground != 0.0f) {
            g.setColor(new Color(1.0f, 1.0f, 1.0f, fadeBackground));
            g.fillRect(target.x, target.y, target.width, target.height);
        }
    }

    List<Tile> paintTileImages(Graphics g, TileSet ts, int zoom, Tile border) {
        Rectangle borderRect = null;
        if (border != null) {
            borderRect = this.tileToRect(border);
        }
        LinkedList<Tile> missedTiles = new LinkedList<Tile>();
        boolean imageScaleRecorded = false;
        for (Tile tile : ts.allTiles()) {
            Image img = this.getLoadedTileImage(tile);
            if (img == null) {
                if (this.debug) {
                    this.out("missed tile: " + tile);
                }
                missedTiles.add(tile);
                continue;
            }
            Rectangle sourceRect = this.tileToRect(tile);
            if (borderRect != null && !sourceRect.intersects(borderRect)) continue;
            this.drawImageInside(g, img, sourceRect, borderRect);
            if (imageScaleRecorded || zoom != this.currentZoomLevel) continue;
            this.lastImageScale = new Double(this.getImageScaling(img, sourceRect));
            imageScaleRecorded = true;
        }
        return missedTiles;
    }

    void paintTileText(TileSet ts, Tile tile, Graphics g, MapView mv, int zoom, Tile t) {
        String md;
        int fontHeight = g.getFontMetrics().getHeight();
        if (tile == null) {
            return;
        }
        Point p = this.pixelPos(t);
        int texty = p.y + 2 + fontHeight;
        if (SlippyMapPreferences.getDrawDebug()) {
            g.drawString("x=" + t.getXtile() + " y=" + t.getYtile() + " z=" + zoom + "", p.x + 2, texty);
            texty += 1 + fontHeight;
            if (t.getXtile() % 32 == 0 && t.getYtile() % 32 == 0) {
                g.drawString("x=" + t.getXtile() / 32 + " y=" + t.getYtile() / 32 + " z=7", p.x + 2, texty);
                texty += 1 + fontHeight;
            }
        }
        if (tile == this.showMetadataTile && (md = tile.toString()) != null) {
            g.drawString(md, p.x + 2, texty);
            texty += 1 + fontHeight;
        }
        String tileStatus = tile.getStatus();
        if (!tile.isLoaded()) {
            g.drawString(I18n.tr((String)("image " + tileStatus)), p.x + 2, texty);
            texty += 1 + fontHeight;
        }
        int xCursor = -1;
        int yCursor = -1;
        if (SlippyMapPreferences.getDrawDebug()) {
            if (yCursor < t.getYtile()) {
                if (t.getYtile() % 32 == 31) {
                    g.fillRect(0, p.y - 1, mv.getWidth(), 3);
                } else {
                    g.drawLine(0, p.y, mv.getWidth(), p.y);
                }
                yCursor = t.getYtile();
            }
            if (xCursor < t.getXtile()) {
                if (SlippyMapPreferences.getDrawDebug()) {
                    if (t.getXtile() % 32 == 0) {
                        g.fillRect(p.x - 1, 0, 3, mv.getHeight());
                    } else {
                        g.drawLine(p.x, 0, p.x, mv.getHeight());
                    }
                }
                xCursor = t.getXtile();
            }
        }
    }

    public Point pixelPos(LatLon ll) {
        return Main.map.mapView.getPoint(ll);
    }

    public Point pixelPos(Tile t) {
        double lon = this.tileXToLon(t.getXtile(), t.getZoom());
        LatLon tmpLL = new LatLon(this.tileYToLat(t.getYtile(), t.getZoom()), lon);
        return this.pixelPos(tmpLL);
    }

    boolean autoZoomEnabled() {
        if (this.az_disable) {
            return false;
        }
        return this.autoZoomPopup.isSelected();
    }

    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        int[] otherZooms;
        LatLon topLeft = mv.getLatLon(0, 0);
        LatLon botRight = mv.getLatLon(mv.getWidth(), mv.getHeight());
        Graphics2D oldg = g;
        if (botRight.lon() == 0.0 || botRight.lat() == 0.0) {
            Main.debug((String)"still initializing??");
            return;
        }
        if (this.lastTopLeft != null && this.lastBotRight != null && topLeft.equalsEpsilon(this.lastTopLeft) && botRight.equalsEpsilon(this.lastBotRight) && this.bufferImage != null && mv.getWidth() == this.bufferImage.getWidth(null) && mv.getHeight() == this.bufferImage.getHeight(null) && !this.needRedraw) {
            if (this.debug) {
                this.out("drawing buffered image");
            }
            g.drawImage(this.bufferImage, 0, 0, null);
            return;
        }
        this.needRedraw = false;
        this.lastTopLeft = topLeft;
        this.lastBotRight = botRight;
        this.bufferImage = mv.createImage(mv.getWidth(), mv.getHeight());
        g = (Graphics2D)this.bufferImage.getGraphics();
        int zoom = this.currentZoomLevel;
        TileSet ts = new TileSet(topLeft, botRight, zoom);
        if (this.autoZoomEnabled()) {
            if (this.zoomDecreaseAllowed() && ts.tooLarge()) {
                if (this.debug) {
                    this.out("too many tiles, decreasing zoom from " + this.currentZoomLevel);
                }
                if (this.decreaseZoomLevel()) {
                    this.paint(oldg, mv, bounds);
                }
                return;
            }
            if (this.zoomIncreaseAllowed() && ts.tooSmall()) {
                if (this.debug) {
                    this.out("too zoomed in, (" + ts.tilesSpanned() + "), increasing zoom from " + this.currentZoomLevel);
                }
                boolean tmp = this.az_disable;
                this.az_disable = true;
                if (this.increaseZoomLevel()) {
                    this.paint(oldg, mv, bounds);
                }
                this.az_disable = tmp;
                return;
            }
        }
        if (!ts.tooLarge()) {
            ts.loadAllTiles(false);
        }
        g.setColor(Color.DARK_GRAY);
        List<Tile> missedTiles = this.paintTileImages(g, ts, this.currentZoomLevel, null);
        for (int zoomOffset : otherZooms = new int[]{-1, 1, -2, 2, -3, -4, -5}) {
            if (!this.autoZoomEnabled() || !SlippyMapPreferences.getAutoloadTiles()) break;
            int newzoom = this.currentZoomLevel + zoomOffset;
            if (missedTiles.size() <= 0) break;
            LinkedList<Tile> newlyMissedTiles = new LinkedList<Tile>();
            for (Tile missed : missedTiles) {
                LatLon botRight2;
                Tile t2 = this.tempCornerTile(missed);
                LatLon topLeft2 = this.tileLatLon(missed);
                TileSet ts2 = new TileSet(topLeft2, botRight2 = this.tileLatLon(t2), newzoom);
                if (ts2.tooLarge()) continue;
                newlyMissedTiles.addAll(this.paintTileImages(g, ts2, newzoom, missed));
            }
            missedTiles = newlyMissedTiles;
        }
        if (this.debug && missedTiles.size() > 0) {
            this.out("still missed " + missedTiles.size() + " in the end");
        }
        g.setColor(Color.red);
        for (Tile t : ts.allTiles()) {
            this.paintTileText(ts, t, g, mv, this.currentZoomLevel, t);
        }
        oldg.drawImage(this.bufferImage, 0, 0, null);
        if (this.autoZoomEnabled() && this.lastImageScale != null) {
            if (this.lastImageScale > 3.0 && this.zoomIncreaseAllowed()) {
                if (this.debug) {
                    this.out("autozoom increase: scale: " + this.lastImageScale);
                }
                this.increaseZoomLevel();
                this.paint(oldg, mv, bounds);
            } else if (this.lastImageScale < 0.45 && this.lastImageScale > 0.0 && this.zoomDecreaseAllowed()) {
                if (this.debug) {
                    this.out("autozoom decrease: scale: " + this.lastImageScale);
                }
                this.decreaseZoomLevel();
                this.paint(oldg, mv, bounds);
            }
        }
        oldg.setColor(Color.black);
        if (ts.insane()) {
            oldg.drawString("zoom in to load any tiles", 120, 120);
        } else if (ts.tooLarge()) {
            oldg.drawString("zoom in to load more tiles", 120, 120);
        } else if (ts.tooSmall()) {
            oldg.drawString("increase zoom level to see more detail", 120, 120);
        }
    }

    Tile getTileForPixelpos(int px, int py) {
        int z;
        LatLon botRight;
        if (this.debug) {
            this.out("getTileForPixelpos(" + px + ", " + py + ")");
        }
        MapView mv = Main.map.mapView;
        Point clicked = new Point(px, py);
        LatLon topLeft = mv.getLatLon(0, 0);
        TileSet ts = new TileSet(topLeft, botRight = mv.getLatLon(mv.getWidth(), mv.getHeight()), z = this.currentZoomLevel);
        if (!ts.tooLarge()) {
            ts.loadAllTiles(false);
        }
        Tile clickedTile = null;
        for (Tile t1 : ts.allTiles()) {
            Tile t2 = this.tempCornerTile(t1);
            Rectangle r = new Rectangle(this.pixelPos(t1));
            r.add(this.pixelPos(t2));
            if (this.debug) {
                this.out("r: " + r + " clicked: " + clicked);
            }
            if (!r.contains(clicked)) continue;
            clickedTile = t1;
            break;
        }
        if (clickedTile == null) {
            return null;
        }
        System.out.println("clicked on tile: " + clickedTile.getXtile() + " " + clickedTile.getYtile() + " scale: " + this.lastImageScale + " currentZoomLevel: " + this.currentZoomLevel);
        return clickedTile;
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"slippymap");
    }

    public Object getInfoComponent() {
        return null;
    }

    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new RenameLayerAction(this.getAssociatedFile(), (Layer)this), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction((Layer)this)};
    }

    public String getToolTipText() {
        return null;
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    private int latToTileY(double lat, int zoom) {
        double l = lat / 180.0 * Math.PI;
        double pf = Math.log(Math.tan(l) + 1.0 / Math.cos(l));
        return (int)(Math.pow(2.0, zoom - 1) * (Math.PI - pf) / Math.PI);
    }

    private int lonToTileX(double lon, int zoom) {
        return (int)(Math.pow(2.0, zoom - 3) * (lon + 180.0) / 45.0);
    }

    private double tileYToLat(int y, int zoom) {
        return Math.atan(Math.sinh(Math.PI - Math.PI * (double)y / Math.pow(2.0, zoom - 1))) * 180.0 / Math.PI;
    }

    private double tileXToLon(int x, int zoom) {
        return (double)x * 45.0 / Math.pow(2.0, zoom - 3) - 180.0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TileSet {
        int z12x0;
        int z12x1;
        int z12y0;
        int z12y1;
        int zoom;
        int tileMax = -1;

        TileSet(LatLon topLeft, LatLon botRight, int zoom) {
            int tmp;
            this.zoom = zoom;
            this.z12x0 = SlippyMapLayer.this.lonToTileX(topLeft.lon(), zoom);
            this.z12y0 = SlippyMapLayer.this.latToTileY(topLeft.lat(), zoom);
            this.z12x1 = SlippyMapLayer.this.lonToTileX(botRight.lon(), zoom);
            this.z12y1 = SlippyMapLayer.this.latToTileY(botRight.lat(), zoom);
            if (this.z12x0 > this.z12x1) {
                tmp = this.z12x0;
                this.z12x0 = this.z12x1;
                this.z12x1 = tmp;
            }
            if (this.z12y0 > this.z12y1) {
                tmp = this.z12y0;
                this.z12y0 = this.z12y1;
                this.z12y1 = tmp;
            }
            this.tileMax = (int)Math.pow(2.0, zoom);
            if (this.z12x0 < 0) {
                this.z12x0 = 0;
            }
            if (this.z12y0 < 0) {
                this.z12y0 = 0;
            }
            if (this.z12x1 > this.tileMax) {
                this.z12x1 = this.tileMax;
            }
            if (this.z12y1 > this.tileMax) {
                this.z12y1 = this.tileMax;
            }
        }

        boolean tooSmall() {
            return this.tilesSpanned() < 2.1;
        }

        boolean tooLarge() {
            return this.tilesSpanned() > 10.0;
        }

        boolean insane() {
            return this.tilesSpanned() > 100.0;
        }

        double tilesSpanned() {
            return Math.sqrt(1.0 * this.size());
        }

        double size() {
            double x_span = (double)(this.z12x1 - this.z12x0) + 1.0;
            double y_span = (double)(this.z12y1 - this.z12y0) + 1.0;
            return x_span * y_span;
        }

        List<Tile> allTiles() {
            return this.allTiles(false);
        }

        private List<Tile> allTiles(boolean create) {
            ArrayList<Tile> ret = new ArrayList<Tile>();
            if (this.insane()) {
                return ret;
            }
            for (int x = this.z12x0; x <= this.z12x1; ++x) {
                for (int y = this.z12y0; y <= this.z12y1; ++y) {
                    Tile t = create ? SlippyMapLayer.this.getOrCreateTile(x % this.tileMax, y % this.tileMax, this.zoom) : SlippyMapLayer.this.getTile(x % this.tileMax, y % this.tileMax, this.zoom);
                    if (t == null) continue;
                    ret.add(t);
                }
            }
            return ret;
        }

        void loadAllTiles(boolean force) {
            List<Tile> tiles = this.allTiles(true);
            boolean autoload = SlippyMapPreferences.getAutoloadTiles();
            if (!autoload && !force) {
                return;
            }
            int nr_queued = 0;
            for (Tile t : tiles) {
                if (!SlippyMapLayer.this.loadTile(t)) continue;
                ++nr_queued;
            }
            if (SlippyMapLayer.this.debug && nr_queued > 0) {
                SlippyMapLayer.this.out("queued to load: " + nr_queued + "/" + tiles.size() + " tiles at zoom: " + this.zoom);
            }
        }
    }
}

