/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.util.Collection;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UntaggedNode
extends Test {
    protected static final int UNTAGGED_NODE_BLANK = 201;
    protected static final int UNTAGGED_NODE_FIXME = 202;
    protected static final int UNTAGGED_NODE_NOTE = 203;
    protected static final int UNTAGGED_NODE_CREATED_BY = 204;
    protected static final int UNTAGGED_NODE_WATCH = 205;
    protected static final int UNTAGGED_NODE_SOURCE = 206;
    protected static final int UNTAGGED_NODE_OTHER = 207;

    public UntaggedNode() {
        super(I18n.tr((String)"Untagged and unconnected nodes") + ".", I18n.tr((String)"This test checks for untagged nodes that are not part of any way."));
    }

    @Override
    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
    }

    @Override
    public void visit(Collection<OsmPrimitive> selection) {
        for (OsmPrimitive p : selection) {
            if (!p.isUsable() || !(p instanceof Node)) continue;
            p.visit((Visitor)this);
        }
    }

    @Override
    public void visit(Node n) {
        if (n.isUsable() && !n.isTagged() && n.getReferrers().isEmpty()) {
            if (!n.hasKeys()) {
                String msg = I18n.marktr((String)"No tags");
                this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr((String)"Unconnected nodes without physical tags"), I18n.tr((String)msg), msg, 201, (OsmPrimitive)n));
                return;
            }
            for (Map.Entry<String, String> entry : n.getKeys().entrySet()) {
                String msg;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (this.contains(entry, "fixme") || this.contains(entry, "FIXME")) {
                    msg = I18n.marktr((String)"Has tag containing ''fixme'' or ''FIXME''");
                    this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr((String)"Unconnected nodes without physical tags"), I18n.tr((String)msg), msg, 202, (OsmPrimitive)n));
                    return;
                }
                msg = null;
                int code = 0;
                if (key.startsWith("note") || key.startsWith("comment") || key.startsWith("description")) {
                    msg = I18n.marktr((String)"Has key ''note'' or ''comment'' or ''description''");
                    code = 203;
                } else if (key.startsWith("created_by") || key.startsWith("converted_by")) {
                    msg = I18n.marktr((String)"Has key ''created_by'' or ''converted_by''");
                    code = 204;
                } else if (key.startsWith("watch")) {
                    msg = I18n.marktr((String)"Has key ''watch''");
                    code = 205;
                } else if (key.startsWith("source")) {
                    msg = I18n.marktr((String)"Has key ''source''");
                    code = 206;
                }
                if (msg == null) continue;
                this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr((String)"Unconnected nodes without physical tags"), I18n.tr((String)msg), msg, code, (OsmPrimitive)n));
                return;
            }
            this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr((String)"Unconnected nodes without physical tags"), I18n.tr((String)"Other"), "Other", 207, (OsmPrimitive)n));
        }
    }

    private boolean contains(Map.Entry<String, String> tag, String s) {
        return tag.getKey().indexOf(s) != -1 || tag.getValue().indexOf(s) != -1;
    }

    @Override
    public Command fixError(TestError testError) {
        return DeleteCommand.delete((OsmDataLayer)Main.map.mapView.getEditLayer(), testError.getPrimitives());
    }

    @Override
    public boolean isFixable(TestError testError) {
        if (testError.getTester() instanceof UntaggedNode) {
            int code = testError.getCode();
            switch (code) {
                case 201: 
                case 204: 
                case 205: 
                case 206: {
                    return true;
                }
            }
        }
        return false;
    }
}

