/*
 * Decompiled with CFR 0.152.
 */
package com.innovant.josm.jrt.core;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.Main;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoutingProfile {
    static Logger logger = Logger.getLogger(RoutingProfile.class);
    private boolean useOneway;
    private boolean useRestrictions;
    private boolean useMaxAllowedSpeed;
    private String name;
    private Map<String, Double> waySpeeds;
    private Map<String, Boolean> allowedModes;

    public RoutingProfile(String name) {
        logger.debug("Init RoutingProfile with name: " + name);
        this.name = name;
        this.waySpeeds = new HashMap<String, Double>();
        Map prefs = Main.pref.getAllPrefix("routing.profile." + name + ".speed");
        for (String key : prefs.keySet()) {
            this.waySpeeds.put(key.split("\\.")[4], Double.valueOf((String)prefs.get(key)));
        }
        for (String key : this.waySpeeds.keySet()) {
            logger.debug(key + "-- speed: " + this.waySpeeds.get(key));
        }
        logger.debug("End init RoutingProfile with name: " + name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setOnewayUse(boolean useOneway) {
        this.useOneway = useOneway;
    }

    public boolean isOnewayUsed() {
        return this.useOneway;
    }

    public void setRestrictionsUse(boolean useRestrictions) {
        this.useRestrictions = useRestrictions;
    }

    public boolean isRestrictionsUsed() {
        return this.useRestrictions;
    }

    public void setMaxAllowedSpeedUse(boolean useMaxAllowedSpeed) {
        this.useMaxAllowedSpeed = useMaxAllowedSpeed;
    }

    public boolean isMaxAllowedSpeedUsed() {
        return this.useMaxAllowedSpeed;
    }

    public void setWayTypeSpeed(String type, double speed) {
        this.waySpeeds.put(type, speed);
    }

    public void setTransportModePermission(String mode, boolean permission) {
        this.allowedModes.put(mode, permission);
    }

    public boolean isWayTypeAllowed(String type) {
        return this.waySpeeds.get(type) != 0.0;
    }

    public boolean isTransportModeAllowed(String mode) {
        return this.allowedModes.get(mode);
    }

    public double getSpeed(String key) {
        if (!this.waySpeeds.containsKey(key)) {
            return 0.0;
        }
        return this.waySpeeds.get(key);
    }

    public Map<String, Double> getWaySpeeds() {
        return this.waySpeeds;
    }

    public void setWaySpeeds(Map<String, Double> waySpeeds) {
        this.waySpeeds = waySpeeds;
    }
}

