/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.ExceptValueModel;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionEditorModel;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class VehicleExceptionEditor
extends JPanel
implements Observer {
    private static final Logger logger = Logger.getLogger(VehicleExceptionEditor.class.getName());
    private TurnRestrictionEditorModel model;
    private JCheckBox cbPsv;
    private JCheckBox cbBicyle;
    private JCheckBox cbHgv;
    private JCheckBox cbMotorcar;
    private JTextField tfNonStandardValue;
    private ButtonGroup bgStandardOrNonStandard;
    private JRadioButton rbStandardException;
    private JRadioButton rbNonStandardException;
    private JPanel pnlStandard;
    private JPanel pnlNonStandard;
    private ExceptValueModel exceptValue = new ExceptValueModel();

    private JPanel buildMessagePanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        HtmlPanel msg = new HtmlPanel();
        pnl.add((Component)msg, "Center");
        msg.setText("<html><body>" + I18n.tr((String)"Select the vehicle types this turn restriction is <strong>not</strong> applicable for.") + "</body></html>");
        return pnl;
    }

    private JPanel buildStandardInputPanel() {
        if (this.pnlStandard != null) {
            return this.pnlStandard;
        }
        StandardVehicleTypeChangeListener changeHandler = new StandardVehicleTypeChangeListener();
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.gridx = 0;
        gc.gridy = 0;
        this.pnlStandard = new JPanel(new GridBagLayout());
        this.cbPsv = new JCheckBox();
        this.cbPsv.addItemListener(changeHandler);
        JLabel lbl = new JLabel();
        lbl.setText(I18n.tr((String)"Public Service Vehicles"));
        lbl.setToolTipText(I18n.tr((String)"Public service vehicles like buses, tramways, etc."));
        lbl.setIcon(ImageProvider.get((String)"vehicle", (String)"psv"));
        gc.weightx = 0.0;
        this.pnlStandard.add((Component)this.cbPsv, gc);
        gc.weightx = 1.0;
        ++gc.gridx;
        this.pnlStandard.add((Component)lbl, gc);
        this.cbHgv = new JCheckBox();
        this.cbHgv.addItemListener(changeHandler);
        lbl = new JLabel();
        lbl.setText(I18n.tr((String)"Heavy Goods Vehicles"));
        lbl.setIcon(ImageProvider.get((String)"vehicle", (String)"hgv"));
        gc.weightx = 0.0;
        ++gc.gridx;
        this.pnlStandard.add((Component)this.cbHgv, gc);
        gc.weightx = 1.0;
        ++gc.gridx;
        this.pnlStandard.add((Component)lbl, gc);
        this.cbMotorcar = new JCheckBox();
        this.cbMotorcar.addItemListener(changeHandler);
        lbl = new JLabel();
        lbl.setText(I18n.tr((String)"Motorcars"));
        lbl.setIcon(ImageProvider.get((String)"vehicle", (String)"motorcar"));
        gc.weightx = 0.0;
        gc.gridx = 0;
        gc.gridy = 1;
        this.pnlStandard.add((Component)this.cbMotorcar, gc);
        gc.weightx = 1.0;
        ++gc.gridx;
        this.pnlStandard.add((Component)lbl, gc);
        this.cbBicyle = new JCheckBox();
        this.cbBicyle.addItemListener(changeHandler);
        lbl = new JLabel();
        lbl.setText(I18n.tr((String)"Bicycles"));
        lbl.setIcon(ImageProvider.get((String)"vehicle", (String)"bicycle"));
        gc.weightx = 0.0;
        ++gc.gridx;
        this.pnlStandard.add((Component)this.cbBicyle, gc);
        gc.weightx = 1.0;
        ++gc.gridx;
        this.pnlStandard.add((Component)lbl, gc);
        return this.pnlStandard;
    }

    private JPanel buildNonStandardInputPanel() {
        if (this.pnlNonStandard != null) {
            return this.pnlNonStandard;
        }
        this.pnlNonStandard = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 0.0;
        gc.insets = new Insets(0, 0, 4, 0);
        gc.gridx = 0;
        gc.gridy = 0;
        this.pnlNonStandard.add((Component)new JLabel(I18n.tr((String)"Value:")), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfNonStandardValue = new JTextField();
        this.pnlNonStandard.add((Component)this.tfNonStandardValue, gc);
        SelectAllOnFocusGainedDecorator.decorate((JTextComponent)this.tfNonStandardValue);
        NonStandardVehicleTypesHandler inputChangedHandler = new NonStandardVehicleTypesHandler();
        this.tfNonStandardValue.addActionListener(inputChangedHandler);
        this.tfNonStandardValue.addFocusListener(inputChangedHandler);
        return this.pnlNonStandard;
    }

    protected void buildStandard() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.gridx = 0;
        gc.gridy = 0;
        this.add((Component)this.buildMessagePanel(), gc);
        gc.gridy = 1;
        this.add((Component)this.buildStandardInputPanel(), gc);
    }

    protected void buildNonStandard() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.gridx = 0;
        gc.gridy = 0;
        this.add((Component)this.buildMessagePanel(), gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.insets = new Insets(0, 0, 0, 0);
        this.rbStandardException = new JRadioButton(I18n.tr((String)"Use standard exceptions"));
        this.add((Component)this.rbStandardException, gc);
        gc.gridx = 0;
        gc.gridy = 2;
        gc.insets = new Insets(0, 20, 0, 0);
        this.add((Component)this.buildStandardInputPanel(), gc);
        gc.gridx = 0;
        gc.gridy = 3;
        gc.insets = new Insets(0, 0, 0, 0);
        this.rbNonStandardException = new JRadioButton(I18n.tr((String)"Use non-standard exceptions"));
        this.add((Component)this.rbNonStandardException, gc);
        gc.gridx = 0;
        gc.gridy = 4;
        gc.insets = new Insets(0, 20, 0, 0);
        this.add((Component)this.buildNonStandardInputPanel(), gc);
        this.bgStandardOrNonStandard = new ButtonGroup();
        this.bgStandardOrNonStandard.add(this.rbNonStandardException);
        this.bgStandardOrNonStandard.add(this.rbStandardException);
        StandardNonStandardChangeHander changeHandler = new StandardNonStandardChangeHander();
        this.rbNonStandardException.addItemListener(changeHandler);
        this.rbStandardException.addItemListener(changeHandler);
    }

    protected void build() {
        this.removeAll();
        this.buildNonStandardInputPanel();
        this.buildStandardInputPanel();
        if (this.exceptValue.isStandard()) {
            this.buildStandard();
        } else {
            this.buildNonStandard();
        }
        this.init();
        this.invalidate();
    }

    protected void init() {
        this.cbPsv.setSelected(this.exceptValue.isVehicleException("psv"));
        this.cbBicyle.setSelected(this.exceptValue.isVehicleException("bicycle"));
        this.cbMotorcar.setSelected(this.exceptValue.isVehicleException("motorcar"));
        this.cbHgv.setSelected(this.exceptValue.isVehicleException("hgv"));
        if (!this.exceptValue.isStandard()) {
            this.rbNonStandardException.setSelected(true);
            this.tfNonStandardValue.setText(this.exceptValue.getValue());
            this.setEnabledNonStandardInputPanel(true);
            this.setEnabledStandardInputPanel(false);
        } else {
            this.setEnabledNonStandardInputPanel(false);
            this.setEnabledStandardInputPanel(true);
        }
    }

    protected void setEnabledStandardInputPanel(boolean enabled) {
        for (Component c : this.pnlStandard.getComponents()) {
            c.setEnabled(enabled);
        }
    }

    protected void setEnabledNonStandardInputPanel(boolean enabled) {
        for (Component c : this.pnlNonStandard.getComponents()) {
            c.setEnabled(enabled);
        }
    }

    public VehicleExceptionEditor(TurnRestrictionEditorModel model) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)model, (String)"model");
        this.model = model;
        this.build();
        model.addObserver(this);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (!this.exceptValue.equals(this.model.getExcept())) {
            this.exceptValue = this.model.getExcept();
            this.build();
        }
    }

    class NonStandardVehicleTypesHandler
    implements ActionListener,
    FocusListener {
        NonStandardVehicleTypesHandler() {
        }

        public void persist() {
            VehicleExceptionEditor.this.exceptValue.setValue(VehicleExceptionEditor.this.tfNonStandardValue.getText());
            VehicleExceptionEditor.this.model.setExcept(VehicleExceptionEditor.this.exceptValue);
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.persist();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.persist();
        }
    }

    class StandardVehicleTypeChangeListener
    implements ItemListener {
        StandardVehicleTypeChangeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            VehicleExceptionEditor.this.exceptValue.setVehicleException("bicycle", VehicleExceptionEditor.this.cbBicyle.isSelected());
            VehicleExceptionEditor.this.exceptValue.setVehicleException("hgv", VehicleExceptionEditor.this.cbHgv.isSelected());
            VehicleExceptionEditor.this.exceptValue.setVehicleException("psv", VehicleExceptionEditor.this.cbPsv.isSelected());
            VehicleExceptionEditor.this.exceptValue.setVehicleException("motorcar", VehicleExceptionEditor.this.cbMotorcar.isSelected());
            VehicleExceptionEditor.this.model.setExcept(VehicleExceptionEditor.this.exceptValue);
        }
    }

    class StandardNonStandardChangeHander
    implements ItemListener {
        StandardNonStandardChangeHander() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (VehicleExceptionEditor.this.rbNonStandardException.isSelected()) {
                VehicleExceptionEditor.this.setEnabledNonStandardInputPanel(true);
                VehicleExceptionEditor.this.setEnabledStandardInputPanel(false);
                VehicleExceptionEditor.this.exceptValue.setStandard(false);
            } else {
                VehicleExceptionEditor.this.setEnabledNonStandardInputPanel(false);
                VehicleExceptionEditor.this.setEnabledStandardInputPanel(true);
                VehicleExceptionEditor.this.exceptValue.setStandard(true);
            }
            VehicleExceptionEditor.this.model.setExcept(VehicleExceptionEditor.this.exceptValue);
        }
    }
}

