/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListSelectionModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.turnrestrictions.dnd.PrimitiveIdListProvider;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class JosmSelectionListModel
extends AbstractListModel
implements MapView.EditLayerChangeListener,
SelectionChangedListener,
DataSetListener,
PrimitiveIdListProvider {
    private static final Logger logger = Logger.getLogger(JosmSelectionListModel.class.getName());
    private final List<OsmPrimitive> selection = new ArrayList<OsmPrimitive>();
    private DefaultListSelectionModel selectionModel;
    private OsmDataLayer layer;

    public JosmSelectionListModel(OsmDataLayer layer, DefaultListSelectionModel selectionModel) {
        CheckParameterUtil.ensureParameterNotNull((Object)selectionModel, (String)"selectionModel");
        CheckParameterUtil.ensureParameterNotNull((Object)layer, (String)"layer");
        this.layer = layer;
        this.selectionModel = selectionModel;
        this.setJOSMSelection(layer.data.getSelected());
    }

    @Override
    public Object getElementAt(int index) {
        return this.selection.get(index);
    }

    @Override
    public int getSize() {
        return this.selection.size();
    }

    public Collection<OsmPrimitive> getSelected() {
        HashSet<OsmPrimitive> sel = new HashSet<OsmPrimitive>();
        for (int i = 0; i < this.getSize(); ++i) {
            if (!this.selectionModel.isSelectedIndex(i)) continue;
            sel.add(this.selection.get(i));
        }
        return sel;
    }

    public void setSelected(Collection<OsmPrimitive> sel) {
        this.selectionModel.clearSelection();
        if (sel == null) {
            return;
        }
        for (OsmPrimitive p : sel) {
            int i = this.selection.indexOf(p);
            if (i < 0) continue;
            this.selectionModel.addSelectionInterval(i, i);
        }
    }

    @Override
    protected void fireContentsChanged(Object source, int index0, int index1) {
        Collection<OsmPrimitive> sel = this.getSelected();
        super.fireContentsChanged(source, index0, index1);
        this.setSelected(sel);
    }

    public void setJOSMSelection(Collection<? extends OsmPrimitive> selection) {
        Collection<OsmPrimitive> sel = this.getSelected();
        this.selection.clear();
        if (selection == null) {
            this.fireContentsChanged(this, 0, this.getSize());
            return;
        }
        this.selection.addAll(selection);
        this.fireContentsChanged(this, 0, this.getSize());
        this.setSelected(sel);
    }

    public void update(Collection<? extends OsmPrimitive> toUpdate) {
        if (toUpdate == null) {
            return;
        }
        if (toUpdate.isEmpty()) {
            return;
        }
        Collection<OsmPrimitive> sel = this.getSelected();
        for (OsmPrimitive osmPrimitive : toUpdate) {
            int i = this.selection.indexOf(osmPrimitive);
            if (i < 0) continue;
            super.fireContentsChanged(this, i, i);
        }
        this.setSelected(sel);
    }

    public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
        if (newLayer == null) {
            this.setJOSMSelection(null);
        } else if (newLayer != this.layer) {
            this.setJOSMSelection(null);
        } else {
            this.setJOSMSelection(newLayer.data.getSelected());
        }
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        OsmDataLayer layer = Main.main.getEditLayer();
        if (layer == null) {
            return;
        }
        if (layer != this.layer) {
            return;
        }
        this.setJOSMSelection(newSelection);
    }

    public void dataChanged(DataChangedEvent event) {
        if (event.getDataset() != this.layer.data) {
            return;
        }
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public void nodeMoved(NodeMovedEvent event) {
        if (event.getDataset() != this.layer.data) {
            return;
        }
        this.update(event.getPrimitives());
    }

    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
        if (event.getDataset() != this.layer.data) {
            return;
        }
        this.update(event.getPrimitives());
    }

    public void relationMembersChanged(RelationMembersChangedEvent event) {
        if (event.getDataset() != this.layer.data) {
            return;
        }
        this.update(event.getPrimitives());
    }

    public void tagsChanged(TagsChangedEvent event) {
        if (event.getDataset() != this.layer.data) {
            return;
        }
        this.update(event.getPrimitives());
    }

    public void wayNodesChanged(WayNodesChangedEvent event) {
        if (event.getDataset() != this.layer.data) {
            return;
        }
        this.update(event.getPrimitives());
    }

    public void primtivesAdded(PrimitivesAddedEvent event) {
    }

    public void primtivesRemoved(PrimitivesRemovedEvent event) {
    }

    @Override
    public List<PrimitiveId> getSelectedPrimitiveIds() {
        ArrayList<PrimitiveId> ret = new ArrayList<PrimitiveId>(this.getSelected().size());
        for (int i = 0; i < this.selection.size(); ++i) {
            if (!this.selectionModel.isSelectedIndex(i)) continue;
            ret.add(this.selection.get(i).getPrimitiveId());
        }
        return ret;
    }
}

