/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class TurnRestrictionBuilder {
    private Way from;
    private Way to;
    private final ArrayList<OsmPrimitive> vias = new ArrayList();

    protected void initFromLeg(List<OsmPrimitive> primitives) {
        if (primitives == null || primitives.isEmpty()) {
            return;
        }
        OsmPrimitive p = primitives.get(0);
        if (!(p instanceof Way)) {
            return;
        }
        Way fromLeg = (Way)p;
        if (fromLeg.isDeleted() || !fromLeg.isVisible()) {
            return;
        }
        this.from = fromLeg;
    }

    protected void initToLeg(List<OsmPrimitive> primitives) {
        if (primitives == null || primitives.isEmpty()) {
            return;
        }
        if (primitives.size() < 2) {
            return;
        }
        OsmPrimitive p = primitives.get(primitives.size() - 1);
        if (!(p instanceof Way)) {
            return;
        }
        Way toLeg = (Way)p;
        if (toLeg.isDeleted() || !toLeg.isVisible()) {
            return;
        }
        this.to = toLeg;
    }

    protected void initViaFromLegs() {
        if (this.from == null || this.to == null) {
            return;
        }
        HashSet nodes = new HashSet();
        nodes.addAll(this.from.getNodes());
        nodes.retainAll(this.to.getNodes());
        if (nodes.size() == 1) {
            this.vias.add((OsmPrimitive)nodes.iterator().next());
        }
    }

    protected void initViasFromPrimitives(List<OsmPrimitive> primitives) {
        if (primitives == null || primitives.size() <= 2) {
            return;
        }
        if (this.from == null || this.to == null) {
            return;
        }
        for (int i = 1; i < primitives.size() - 2; ++i) {
            OsmPrimitive p = primitives.get(i);
            if (p == null || p instanceof Relation || p.isDeleted() || !p.isVisible()) continue;
            this.vias.add(p);
        }
    }

    protected void reset() {
        this.from = null;
        this.to = null;
        this.vias.clear();
    }

    public synchronized Relation buildFromSelection(OsmDataLayer layer) {
        CheckParameterUtil.ensureParameterNotNull((Object)layer, (String)"layer");
        ArrayList<OsmPrimitive> selection = new ArrayList<OsmPrimitive>(layer.data.getSelected());
        return this.build(selection);
    }

    public synchronized Relation build(List<OsmPrimitive> primitives) {
        Relation tr = new Relation();
        tr.put("type", "restriction");
        if (primitives == null || primitives.isEmpty()) {
            return tr;
        }
        if (primitives.size() <= 2) {
            this.initFromLeg(primitives);
            this.initToLeg(primitives);
            this.initViaFromLegs();
        } else if (primitives.size() > 2) {
            this.initFromLeg(primitives);
            this.initToLeg(primitives);
            this.initViasFromPrimitives(primitives);
        }
        if (this.from != null) {
            tr.addMember(new RelationMember("from", (OsmPrimitive)this.from));
        }
        if (this.to != null) {
            tr.addMember(new RelationMember("to", (OsmPrimitive)this.to));
        }
        for (OsmPrimitive via : this.vias) {
            tr.addMember(new RelationMember("via", via));
        }
        return tr;
    }
}

