/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.preferences;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.plugins.turnrestrictions.CreateOrEditTurnRestrictionAction;
import org.openstreetmap.josm.tools.I18n;

public class ShortcutPreferencePanel
extends JPanel {
    private JCheckBox cbCtrl;
    private JCheckBox cbAlt;
    private JCheckBox cbShift;
    private JCheckBox cbMeta;
    private JComboBox cmKeyCodes;

    protected JPanel buildMessagePanel() {
        HtmlPanel pnl = new HtmlPanel();
        pnl.setText("<html><body>" + I18n.tr((String)"Please configure the <strong>keyboard shortcut</strong> which triggers creating/editing a turn restriction from the current JOSM selection.") + "</body></html>");
        return pnl;
    }

    protected JPanel buildShortCutConfigPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 0.0;
        gc.gridx = 0;
        gc.gridy = 0;
        pnl.add((Component)new JLabel(I18n.trc((String)"keyboard-key", (String)"Key:")), gc);
        ++gc.gridx;
        gc.gridwidth = 4;
        gc.weightx = 1.0;
        this.cmKeyCodes = new JComboBox(new VKeyComboBoxModel());
        pnl.add(this.cmKeyCodes, gc);
        this.cmKeyCodes.setRenderer(new VKeyCellRenderer());
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel(I18n.trc((String)"keyboard-modifiers", (String)"Modifiers:")), gc);
        ++gc.gridx;
        this.cbShift = new JCheckBox(I18n.trc((String)"keyboard-modifiers", (String)"Shift"));
        pnl.add((Component)this.cbShift, gc);
        ++gc.gridx;
        this.cbCtrl = new JCheckBox(I18n.trc((String)"keyboard-modifiers", (String)"Ctrl"));
        pnl.add((Component)this.cbCtrl, gc);
        ++gc.gridx;
        this.cbAlt = new JCheckBox(I18n.trc((String)"keyboard-modifiers", (String)"Alt"));
        pnl.add((Component)this.cbAlt, gc);
        ++gc.gridx;
        gc.weightx = 1.0;
        this.cbMeta = new JCheckBox(I18n.trc((String)"keyboard-modifiers", (String)"Meta"));
        pnl.add((Component)this.cbMeta, gc);
        return pnl;
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.gridx = 0;
        gc.gridy = 0;
        this.add((Component)this.buildMessagePanel(), gc);
        ++gc.gridy;
        this.add((Component)this.buildShortCutConfigPanel(), gc);
    }

    public ShortcutPreferencePanel() {
        this.build();
    }

    public void initFromPreferences(Preferences pref) {
        String value = pref.get("turnrestrictions.edit-shortcut", "shift ctrl T");
        KeyStroke key = KeyStroke.getKeyStroke(value);
        if (key == null) {
            System.out.println(I18n.tr((String)"Warning: illegal value ''{0}'' for preference key ''{1}''. Falling back to default value ''shift ctrl T''.", (Object[])new Object[]{value, "turnrestrictions.edit-shortcut"}));
            key = KeyStroke.getKeyStroke("shift ctrl T");
        }
        this.cmKeyCodes.getModel().setSelectedItem(key.getKeyCode());
        this.cbAlt.setSelected((key.getModifiers() & 0x200) != 0);
        this.cbCtrl.setSelected((key.getModifiers() & 0x80) != 0);
        this.cbShift.setSelected((key.getModifiers() & 0x40) != 0);
        this.cbMeta.setSelected((key.getModifiers() & 0x100) != 0);
    }

    public void saveToPreferences(Preferences pref) {
        Integer code = (Integer)this.cmKeyCodes.getModel().getSelectedItem();
        if (code == null) {
            code = 84;
        }
        int modifiers = 0;
        if (this.cbAlt.isSelected()) {
            modifiers |= 0x200;
        }
        if (this.cbCtrl.isSelected()) {
            modifiers |= 0x80;
        }
        if (this.cbShift.isSelected()) {
            modifiers |= 0x40;
        }
        if (this.cbMeta.isSelected()) {
            modifiers |= 0x100;
        }
        KeyStroke ks = KeyStroke.getKeyStroke(code, modifiers);
        pref.put("turnrestrictions.edit-shortcut", ks.toString());
        Main.registerActionShortcut((Action)((Object)CreateOrEditTurnRestrictionAction.getInstance()), (KeyStroke)ks);
    }

    private static class KeyCodeComparator
    implements Comparator<Integer> {
        private static final Map<Integer, String> keyNames = new HashMap<Integer, String>();

        private KeyCodeComparator() {
        }

        protected String keyName(Integer code) {
            String name = keyNames.get(code);
            if (name == null) {
                name = KeyEvent.getKeyText(code);
                keyNames.put(code, name);
            }
            return name;
        }

        @Override
        public int compare(Integer kc1, Integer kc2) {
            String n1 = this.keyName(kc1);
            String n2 = this.keyName(kc2);
            if (n1.length() == 1 && n2.length() == 1) {
                return n1.compareTo(n2);
            }
            if (n1.length() == 1) {
                return -1;
            }
            if (n2.length() == 1) {
                return 1;
            }
            if (n1.matches("F\\d+") && n2.matches("F\\d+")) {
                int f1 = Integer.parseInt(n1.substring(1));
                int f2 = Integer.parseInt(n2.substring(1));
                return new Integer(f1).compareTo(f2);
            }
            return n1.compareTo(n2);
        }
    }

    private static class VKeyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private VKeyCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(UIManager.getColor("ComboBox.selectionBackground"));
                this.setForeground(UIManager.getColor("ComboBox.selectionForeground"));
            } else {
                this.setBackground(UIManager.getColor("ComboBox.background"));
                this.setForeground(UIManager.getColor("ComboBox.foreground"));
            }
            this.setText(KeyEvent.getKeyText((Integer)value));
            return this;
        }
    }

    private static class VKeyComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private final ArrayList<Integer> keys = new ArrayList();
        private Integer selected = null;

        public VKeyComboBoxModel() {
            this.populate();
        }

        public void populate() {
            Field[] fieldArray = KeyEvent.class.getFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                if (Modifier.isStatic(f.getModifiers()) && f.getName().startsWith("VK_")) {
                    try {
                        this.keys.add((Integer)f.get(null));
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            Collections.sort(this.keys, new KeyCodeComparator());
        }

        @Override
        public Object getSelectedItem() {
            return this.selected;
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.selected = (Integer)anItem;
        }

        @Override
        public Object getElementAt(int index) {
            return this.keys.get(index);
        }

        @Override
        public int getSize() {
            return this.keys.size();
        }
    }
}

