/*
 * Decompiled with CFR 0.152.
 */
package toms.seamarks.buoys;

import java.util.Map;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import toms.Messages;
import toms.dialogs.SmpDialogAction;
import toms.seamarks.buoys.Buoy;

public class BuoySpec
extends Buoy {
    public BuoySpec(SmpDialogAction dia, Node node) {
        super(dia);
        String str;
        Map keys = node.getKeys();
        this.setNode(node);
        this.resetMask();
        this.dlg.cbM01TypeOfMark.setSelectedIndex(5);
        this.dlg.cbM01StyleOfMark.removeAllItems();
        this.dlg.cbM01StyleOfMark.addItem(Messages.getString("SmpDialogAction.212"));
        this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.01"));
        this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.02"));
        this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.03"));
        this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.04"));
        this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.05"));
        this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.06"));
        this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.07"));
        this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.08"));
        this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.09"));
        this.dlg.cbM01StyleOfMark.setVisible(true);
        this.dlg.lM01StyleOfMark.setVisible(true);
        this.dlg.cbM01TopMark.removeAllItems();
        this.dlg.cbM01TopMark.addItem(Messages.getString("SmpDialogAction.212"));
        this.dlg.cbM01TopMark.addItem(Messages.getString("SmpDialogAction.210"));
        this.dlg.cbM01TopMark.addItem(Messages.getString("SmpDialogAction.211"));
        this.dlg.cbM01TopMark.addItem(Messages.getString("SmpDialogAction.214"));
        this.dlg.cbM01TopMark.addItem(Messages.getString("SmpDialogAction.215"));
        this.dlg.cM01TopMark.setEnabled(true);
        this.setBuoyIndex(5);
        this.setColour(11);
        this.setLightColour("W");
        this.setRegion(Main.pref.get("tomsplugin.IALA").equals("B"));
        if (keys.containsKey("name")) {
            this.setName((String)keys.get("name"));
        }
        if (keys.containsKey("seamark:name")) {
            this.setName((String)keys.get("seamark:name"));
        }
        if (keys.containsKey("seamark:buoy_special_purpose:name")) {
            this.setName((String)keys.get("seamark:buoy_special_purpose:name"));
        } else if (keys.containsKey("seamark:beacon_special_purpose:name")) {
            this.setName((String)keys.get("seamark:beacon_special_purpose:name"));
        } else if (keys.containsKey("seamark:light_float:name")) {
            this.setName((String)keys.get("seamark:light_float:name"));
        }
        if (keys.containsKey("seamark:buoy_special_purpose:shape")) {
            str = (String)keys.get("seamark:buoy_special_purpose:shape");
            if (str.equals("pillar")) {
                this.setStyleIndex(1);
            } else if (str.equals("can")) {
                this.setStyleIndex(2);
            } else if (str.equals("conical")) {
                this.setStyleIndex(3);
            } else if (str.equals("spar")) {
                this.setStyleIndex(4);
            } else if (str.equals("sphere")) {
                this.setStyleIndex(8);
            } else if (str.equals("barrel")) {
                this.setStyleIndex(9);
            }
        }
        if (keys.containsKey("seamark:beacon_special_purpose:shape")) {
            str = (String)keys.get("seamark:beacon_special_purpose:shape");
            if (str.equals("tower")) {
                this.setStyleIndex(6);
            } else {
                this.setStyleIndex(5);
            }
        }
        if (keys.containsKey("seamark:light_float:colour")) {
            this.setStyleIndex(7);
        }
        if (keys.containsKey("seamark:type") && ((String)keys.get("seamark:type")).equals("beacon_special_purpose") || keys.containsKey("seamark:beacon_special_purpose:colour") || keys.containsKey("seamark:beacon_special_purpose:shape")) {
            if (keys.containsKey("seamark:beacon_special_purpose:shape") && ((String)keys.get("seamark:beacon_special_purpose:shape")).equals("tower")) {
                this.setStyleIndex(6);
            } else {
                this.setStyleIndex(5);
            }
        } else if (keys.containsKey("seamark:light_float:colour") && ((String)keys.get("seamark:light_float:colour")).equals("yellow")) {
            this.setStyleIndex(7);
        }
        if (this.getStyleIndex() >= this.dlg.cbM01StyleOfMark.getItemCount()) {
            this.setStyleIndex(0);
        }
        if ((keys = node.getKeys()).containsKey("seamark:topmark:shape")) {
            str = (String)keys.get("seamark:topmark:shape");
            this.setTopMark(true);
            if (str.equals("x-shape")) {
                if (keys.containsKey("seamark:topmark:colour")) {
                    if (((String)keys.get("seamark:topmark:colour")).equals("red")) {
                        this.setTopMarkIndex(2);
                    } else {
                        this.setTopMarkIndex(1);
                    }
                }
            } else if (str.equals("cone, point up")) {
                this.setTopMarkIndex(4);
            } else if (str.equals("cylinder")) {
                this.setTopMarkIndex(3);
            }
        }
        this.refreshLights();
        this.parseLights(keys);
        this.parseFogRadar(keys);
        this.dlg.cbM01StyleOfMark.setSelectedIndex(this.getStyleIndex());
        this.dlg.tfM01Name.setText(this.getName());
        this.dlg.cM01TopMark.setSelected(this.hasTopMark());
    }

    public void refreshLights() {
        super.refreshLights();
        switch (this.getStyleIndex()) {
            case 9: {
                this.dlg.cM01Fired.setSelected(false);
                this.dlg.cM01Fired.setEnabled(false);
                this.dlg.cM01TopMark.setEnabled(true);
                break;
            }
            default: {
                this.dlg.cM01Fired.setEnabled(true);
                this.dlg.cM01TopMark.setEnabled(true);
            }
        }
    }

    public boolean isValid() {
        return this.getBuoyIndex() > 0 && this.getStyleIndex() > 0;
    }

    public void setLightColour() {
        super.setLightColour("W");
    }

    public void paintSign() {
        if (this.dlg.paintlock) {
            return;
        }
        super.paintSign();
        this.dlg.sM01StatusBar.setText(this.getErrMsg());
        if (this.isValid()) {
            this.dlg.tfM01Name.setEnabled(true);
            this.dlg.tfM01Name.setText(this.getName());
            this.dlg.cM01Radar.setVisible(true);
            this.dlg.cM01Racon.setVisible(true);
            this.dlg.cM01TopMark.setEnabled(true);
            this.dlg.cM01TopMark.setVisible(true);
            if (this.hasTopMark()) {
                this.dlg.cbM01TopMark.setEnabled(true);
                this.dlg.cbM01TopMark.setVisible(true);
            } else {
                this.dlg.cbM01TopMark.setVisible(false);
            }
            this.dlg.cM01Fog.setVisible(true);
            this.dlg.cM01Fired.setVisible(true);
            this.dlg.cM01Fired.setEnabled(true);
            if (!this.isSectored()) {
                this.dlg.cbM01Colour.setVisible(false);
                this.dlg.lM01Colour.setVisible(false);
            }
            this.dlg.rbM01Fired1.setVisible(false);
            this.dlg.rbM01FiredN.setVisible(false);
            this.dlg.lM01Height.setVisible(false);
            this.dlg.tfM01Height.setVisible(false);
            this.dlg.lM01Range.setVisible(false);
            this.dlg.tfM01Range.setVisible(false);
            if (this.isFired()) {
                switch (this.getStyleIndex()) {
                    case 5: 
                    case 6: 
                    case 7: {
                        this.dlg.lM01Height.setVisible(true);
                        this.dlg.tfM01Height.setVisible(true);
                        this.dlg.lM01Range.setVisible(true);
                        this.dlg.tfM01Range.setVisible(true);
                        break;
                    }
                }
            }
            String image = "/images/Special_Purpose";
            switch (this.getStyleIndex()) {
                case 1: {
                    image = image + "_Pillar";
                    break;
                }
                case 2: {
                    image = image + "_Can";
                    break;
                }
                case 3: {
                    image = image + "_Cone";
                    break;
                }
                case 4: {
                    image = image + "_Spar";
                    break;
                }
                case 8: {
                    image = image + "_Sphere";
                    break;
                }
                case 9: {
                    image = image + "_Barrel";
                    break;
                }
                case 7: {
                    image = image + "_Float";
                    break;
                }
                case 5: {
                    image = image + "_Beacon";
                    break;
                }
                case 6: {
                    image = image + "_Tower";
                    break;
                }
            }
            if (!image.equals("/images/Special_Purpose")) {
                image = image + ".png";
                this.dlg.lM01Icon.setIcon(new ImageIcon(this.getClass().getResource(image)));
                if (this.hasTopMark()) {
                    image = "";
                    block14 : switch (this.getStyleIndex()) {
                        case 1: 
                        case 4: {
                            switch (this.getTopMarkIndex()) {
                                case 1: {
                                    image = "/images/Top_X_Yellow_Buoy.png";
                                    break;
                                }
                                case 2: {
                                    image = "/images/Top_X_Red_Buoy.png";
                                    break;
                                }
                                case 3: {
                                    image = "/images/Top_Can_Yellow_Buoy.png";
                                    break;
                                }
                                case 4: {
                                    image = "/images/Top_Cone_Yellow_Buoy.png";
                                }
                            }
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 8: 
                        case 9: {
                            switch (this.getTopMarkIndex()) {
                                case 1: {
                                    image = "/images/Top_X_Yellow_Buoy_Small.png";
                                    break;
                                }
                                case 2: {
                                    image = "/images/Top_X_Red_Buoy_Small.png";
                                    break;
                                }
                                case 3: {
                                    image = "/images/Top_Can_Yellow_Buoy_Small.png";
                                    break;
                                }
                                case 4: {
                                    image = "/images/Top_Cone_Yellow_Buoy_Small.png";
                                }
                            }
                            break;
                        }
                        case 5: 
                        case 6: {
                            switch (this.getTopMarkIndex()) {
                                case 1: {
                                    image = "/images/Top_X_Yellow_Beacon.png";
                                    break;
                                }
                                case 2: {
                                    image = "/images/Top_X_Red_Beacon.png";
                                    break;
                                }
                                case 3: {
                                    image = "/images/Top_Can_Yellow_Beacon.png";
                                    break;
                                }
                                case 4: {
                                    image = "/images/Top_Cone_Yellow_Beacon.png";
                                }
                            }
                            break;
                        }
                        case 7: {
                            switch (this.getTopMarkIndex()) {
                                case 1: {
                                    image = "/images/Top_X_Yellow_Float.png";
                                    break block14;
                                }
                                case 2: {
                                    image = "/images/Top_X_Red_Float.png";
                                    break block14;
                                }
                                case 3: {
                                    image = "/images/Top_Can_Yellow_Float.png";
                                    break block14;
                                }
                                case 4: {
                                    image = "/images/Top_Cone_Yellow_Float.png";
                                }
                            }
                        }
                    }
                    if (!image.isEmpty()) {
                        this.dlg.lM06Icon.setIcon(new ImageIcon(this.getClass().getResource(image)));
                    }
                }
            } else {
                this.dlg.lM01Icon.setIcon(null);
            }
        }
    }

    public void saveSign() {
        Node node = this.getNode();
        if (node == null) {
            return;
        }
        switch (this.getStyleIndex()) {
            case 1: {
                super.saveSign("buoy_special_purpose");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_special_purpose:shape", "pillar"));
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_special_purpose:colour", "yellow"));
                break;
            }
            case 4: {
                super.saveSign("buoy_special_purpose");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_special_purpose:shape", "spar"));
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_special_purpose:colour", "yellow"));
                break;
            }
            case 2: {
                super.saveSign("buoy_special_purpose");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_special_purpose:shape", "can"));
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_special_purpose:colour", "yellow"));
                break;
            }
            case 3: {
                super.saveSign("buoy_special_purpose");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_special_purpose:shape", "conical"));
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_special_purpose:colour", "yellow"));
                break;
            }
            case 8: {
                super.saveSign("buoy_special_purpose");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_special_purpose:shape", "sphere"));
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_special_purpose:colour", "yellow"));
                break;
            }
            case 9: {
                super.saveSign("buoy_special_purpose");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_special_purpose:shape", "barrel"));
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_special_purpose:colour", "yellow"));
                break;
            }
            case 7: {
                super.saveSign("light_float");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour", "yellow"));
                break;
            }
            case 5: {
                super.saveSign("beacon_special_purpose");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_special_purpose:colour", "yellow"));
                break;
            }
            case 6: {
                super.saveSign("beacon_special_purpose");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_special_purpose:shape", "tower"));
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_special_purpose:colour", "yellow"));
                break;
            }
        }
        switch (this.getTopMarkIndex()) {
            case 1: {
                this.saveTopMarkData("x-shape", "yellow");
                break;
            }
            case 2: {
                this.saveTopMarkData("x-shape", "red");
                break;
            }
            case 3: {
                this.saveTopMarkData("cylinder", "yellow");
                break;
            }
            case 4: {
                this.saveTopMarkData("cone, point up", "yellow");
            }
        }
        this.saveLightData();
        this.saveRadarFogData();
    }
}

