/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import wmsplugin.AddWMSLayerPanel;
import wmsplugin.WMSInfo;
import wmsplugin.WMSPlugin;

public class WMSPreferenceEditor
implements PreferenceSetting {
    private WMSLayerTableModel model;
    private JComboBox browser;
    JCheckBox overlapCheckBox;
    JSpinner spinEast;
    JSpinner spinNorth;
    JSpinner spinSimConn;
    JCheckBox remoteCheckBox;
    boolean allowRemoteControl = true;
    WMSPlugin plugin = WMSPlugin.instance;

    public void addGui(final PreferenceTabbedPane gui) {
        JPanel p = gui.createPreferenceTab("wms", I18n.tr((String)"WMS Plugin Preferences"), I18n.tr((String)"Modify list of WMS servers displayed in the WMS plugin menu"));
        this.model = new WMSLayerTableModel();
        final JTable list = new JTable(this.model){

            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                return (String)WMSPreferenceEditor.this.model.getValueAt(this.rowAtPoint(p), this.columnAtPoint(p));
            }
        };
        JScrollPane scroll = new JScrollPane(list);
        p.add((Component)scroll, GBC.eol().fill(1));
        scroll.setPreferredSize(new Dimension(200, 200));
        final WMSDefaultLayerTableModel modeldef = new WMSDefaultLayerTableModel();
        final JTable listdef = new JTable(modeldef){

            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                return (String)modeldef.getValueAt(this.rowAtPoint(p), this.columnAtPoint(p));
            }
        };
        JScrollPane scrolldef = new JScrollPane(listdef);
        scrolldef.setPreferredSize(new Dimension(200, 200));
        TableColumnModel mod = listdef.getColumnModel();
        mod.getColumn(1).setPreferredWidth(800);
        mod.getColumn(0).setPreferredWidth(200);
        mod = list.getColumnModel();
        mod.getColumn(2).setPreferredWidth(50);
        mod.getColumn(1).setPreferredWidth(800);
        mod.getColumn(0).setPreferredWidth(200);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton add = new JButton(I18n.tr((String)"Add"));
        buttonPanel.add((Component)add, GBC.std().insets(0, 5, 0, 0));
        add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddWMSLayerPanel p = new AddWMSLayerPanel();
                int answer = JOptionPane.showConfirmDialog((Component)gui, p, I18n.tr((String)"Add WMS URL"), 2);
                if (answer == 0) {
                    WMSPreferenceEditor.this.model.addRow(new WMSInfo(p.getUrlName(), p.getUrl()));
                }
            }
        });
        JButton delete = new JButton(I18n.tr((String)"Delete"));
        buttonPanel.add((Component)delete, GBC.std().insets(0, 5, 0, 0));
        delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (list.getSelectedRow() == -1) {
                    JOptionPane.showMessageDialog((Component)gui, I18n.tr((String)"Please select the row to delete."));
                } else {
                    Integer i;
                    while ((i = Integer.valueOf(list.getSelectedRow())) != -1) {
                        WMSPreferenceEditor.this.model.removeRow(i);
                    }
                }
            }
        });
        JButton copy = new JButton(I18n.tr((String)"Copy Selected Default(s)"));
        buttonPanel.add((Component)copy, GBC.std().insets(0, 5, 0, 0));
        copy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int[] lines = listdef.getSelectedRows();
                if (lines.length == 0) {
                    JOptionPane.showMessageDialog((Component)gui, I18n.tr((String)"Please select at least one row to copy."), I18n.tr((String)"Information"), 1);
                    return;
                }
                block0: for (int i = 0; i < lines.length; ++i) {
                    WMSInfo info = modeldef.getRow(lines[i]);
                    for (int j = 0; j < WMSPreferenceEditor.this.model.getRowCount(); ++j) {
                        if (!info.equalsBaseValues(WMSPreferenceEditor.this.model.getRow(j))) continue;
                        list.getSelectionModel().setSelectionInterval(j, j);
                        list.scrollRectToVisible(list.getCellRect(j, 0, true));
                        continue block0;
                    }
                    if (info.eulaAcceptanceRequired != null && !WMSPreferenceEditor.this.confirmeEulaAcceptance(gui, info.eulaAcceptanceRequired)) continue;
                    WMSPreferenceEditor.this.model.addRow(new WMSInfo(info));
                    int lastLine = WMSPreferenceEditor.this.model.getRowCount() - 1;
                    list.getSelectionModel().setSelectionInterval(lastLine, lastLine);
                    list.scrollRectToVisible(list.getCellRect(lastLine, 0, true));
                }
            }
        });
        p.add(buttonPanel);
        p.add(Box.createHorizontalGlue(), GBC.eol().fill(2));
        p.add((Component)scrolldef, GBC.eol().insets(0, 5, 0, 0).fill(1));
        this.browser = new JComboBox<String>(new String[]{"webkit-image {0}", "gnome-web-photo --mode=photo --format=png {0} /dev/stdout", "gnome-web-photo-fixed {0}", "webkit-image-gtk {0}"});
        this.browser.setEditable(true);
        this.browser.setSelectedItem(Main.pref.get("wmsplugin.browser", "webkit-image {0}"));
        p.add((Component)new JLabel(I18n.tr((String)"Downloader:")), GBC.eol().fill(2));
        p.add(this.browser);
        p.add(Box.createHorizontalGlue(), GBC.eol().fill(2));
        this.overlapCheckBox = new JCheckBox(I18n.tr((String)"Overlap tiles"), this.plugin.PROP_OVERLAP.get());
        JLabel labelEast = new JLabel(I18n.tr((String)"% of east:"));
        JLabel labelNorth = new JLabel(I18n.tr((String)"% of north:"));
        this.spinEast = new JSpinner(new SpinnerNumberModel(this.plugin.PROP_OVERLAP_EAST.get(), 1, 50, 1));
        this.spinNorth = new JSpinner(new SpinnerNumberModel(this.plugin.PROP_OVERLAP_NORTH.get(), 1, 50, 1));
        JPanel overlapPanel = new JPanel(new FlowLayout());
        overlapPanel.add(this.overlapCheckBox);
        overlapPanel.add(labelEast);
        overlapPanel.add(this.spinEast);
        overlapPanel.add(labelNorth);
        overlapPanel.add(this.spinNorth);
        p.add(overlapPanel);
        p.add(Box.createHorizontalGlue(), GBC.eol().fill(2));
        JLabel labelSimConn = new JLabel(I18n.tr((String)"Simultaneous connections"));
        this.spinSimConn = new JSpinner(new SpinnerNumberModel(this.plugin.PROP_SIMULTANEOUS_CONNECTIONS.get(), 1, 30, 1));
        JPanel overlapPanelSimConn = new JPanel(new FlowLayout());
        overlapPanelSimConn.add(labelSimConn);
        overlapPanelSimConn.add(this.spinSimConn);
        p.add((Component)overlapPanelSimConn, GBC.eol().fill(2));
        this.allowRemoteControl = Main.pref.getBoolean("wmsplugin.remotecontrol", true);
        this.remoteCheckBox = new JCheckBox(I18n.tr((String)"Allow remote control (reqires remotecontrol plugin)"), this.allowRemoteControl);
        JPanel remotePanel = new JPanel(new FlowLayout());
        remotePanel.add(this.remoteCheckBox);
        p.add(remotePanel);
    }

    public boolean ok() {
        this.plugin.info.save();
        this.plugin.refreshMenu();
        this.plugin.PROP_OVERLAP.put(this.overlapCheckBox.getModel().isSelected());
        this.plugin.PROP_OVERLAP_EAST.put(((Integer)this.spinEast.getModel().getValue()).intValue());
        this.plugin.PROP_OVERLAP_NORTH.put(((Integer)this.spinNorth.getModel().getValue()).intValue());
        this.plugin.PROP_SIMULTANEOUS_CONNECTIONS.put(((Integer)this.spinSimConn.getModel().getValue()).intValue());
        this.allowRemoteControl = this.remoteCheckBox.getModel().isSelected();
        Main.pref.put("wmsplugin.browser", this.browser.getEditor().getItem().toString());
        Main.pref.put("wmsplugin.remotecontrol", String.valueOf(this.allowRemoteControl));
        return false;
    }

    public void setServerUrl(String server, String url) {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            if (!server.equals(this.model.getValueAt(i, 0).toString())) continue;
            this.model.setValueAt(url, i, 1);
            return;
        }
        this.model.addRow(new String[]{server, url});
    }

    public String getServerUrl(String server) {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            if (!server.equals(this.model.getValueAt(i, 0).toString())) continue;
            return this.model.getValueAt(i, 1).toString();
        }
        return null;
    }

    private boolean confirmeEulaAcceptance(PreferenceTabbedPane gui, String eulaUrl) {
        URL url = null;
        try {
            url = new URL(eulaUrl.replaceAll("\\{lang\\}", Locale.getDefault().toString()));
            JEditorPane htmlPane = null;
            try {
                htmlPane = new JEditorPane(url);
            }
            catch (IOException e1) {
                try {
                    url = new URL(eulaUrl.replaceAll("\\{lang\\}", "en"));
                    htmlPane = new JEditorPane(url);
                }
                catch (IOException e2) {
                    JOptionPane.showMessageDialog((Component)gui, I18n.tr((String)"EULA license URL not available: {0}", (Object[])new Object[]{eulaUrl}));
                    return false;
                }
            }
            Box box = Box.createVerticalBox();
            htmlPane.setEditable(false);
            JScrollPane scrollPane = new JScrollPane(htmlPane);
            scrollPane.setPreferredSize(new Dimension(400, 400));
            box.add(scrollPane);
            int option = JOptionPane.showConfirmDialog(Main.parent, box, I18n.tr((String)"Please abort if you are not sure"), 0, 2);
            if (option == 0) {
                return true;
            }
        }
        catch (MalformedURLException e2) {
            JOptionPane.showMessageDialog((Component)gui, I18n.tr((String)"Malformed URL for the EULA licence: {0}", (Object[])new Object[]{eulaUrl}));
        }
        return false;
    }

    class WMSDefaultLayerTableModel
    extends DefaultTableModel {
        public WMSDefaultLayerTableModel() {
            this.setColumnIdentifiers(new String[]{I18n.tr((String)"Menu Name (Default)"), I18n.tr((String)"WMS URL (Default)")});
        }

        public WMSInfo getRow(int row) {
            return WMSPreferenceEditor.this.plugin.info.defaultLayers.get(row);
        }

        public int getRowCount() {
            return WMSPreferenceEditor.this.plugin.info.defaultLayers.size();
        }

        public Object getValueAt(int row, int column) {
            WMSInfo info = WMSPreferenceEditor.this.plugin.info.defaultLayers.get(row);
            switch (column) {
                case 0: {
                    return info.name;
                }
                case 1: {
                    return info.getFullURL();
                }
            }
            return null;
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }

    class WMSLayerTableModel
    extends DefaultTableModel {
        public WMSLayerTableModel() {
            this.setColumnIdentifiers(new String[]{I18n.tr((String)"Menu Name"), I18n.tr((String)"WMS URL"), I18n.trc((String)"layer", (String)"Zoom")});
        }

        public WMSInfo getRow(int row) {
            return WMSPreferenceEditor.this.plugin.info.layers.get(row);
        }

        public void addRow(WMSInfo i) {
            WMSPreferenceEditor.this.plugin.info.add(i);
            int p = this.getRowCount() - 1;
            this.fireTableRowsInserted(p, p);
        }

        public void removeRow(int i) {
            WMSPreferenceEditor.this.plugin.info.remove(this.getRow(i));
            this.fireTableRowsDeleted(i, i);
        }

        public int getRowCount() {
            return WMSPreferenceEditor.this.plugin.info.layers.size();
        }

        public Object getValueAt(int row, int column) {
            WMSInfo info = WMSPreferenceEditor.this.plugin.info.layers.get(row);
            switch (column) {
                case 0: {
                    return info.name;
                }
                case 1: {
                    return info.getFullURL();
                }
                case 2: {
                    return info.pixelPerDegree == 0.0 ? "" : Double.valueOf(info.pixelPerDegree);
                }
            }
            return null;
        }

        public void setValueAt(Object o, int row, int column) {
            WMSInfo info = WMSPreferenceEditor.this.plugin.info.layers.get(row);
            switch (column) {
                case 0: {
                    info.name = (String)o;
                }
                case 1: {
                    info.setURL((String)o);
                }
            }
        }

        public boolean isCellEditable(int row, int column) {
            return column != 2;
        }
    }
}

