/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.ImageImportPlugin;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.openstreetmap.josm.plugins.ImageImportPlugin.ImageImportPlugin;
import org.openstreetmap.josm.plugins.ImageImportPlugin.ImageLayer;
import org.openstreetmap.josm.plugins.ImageImportPlugin.PluginOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerPropertiesDialog
extends JFrame {
    private Vector<String> supportedCRS;
    private ImageLayer imageLayer;
    private JPanel mainPanel = null;
    private JPanel jPanel = null;
    private JPanel buttonPanel = null;
    private JTabbedPane jTabbedPane = null;
    private JPanel infoPanel = null;
    private JPanel crsPanel = null;
    private JButton okButton = null;
    private JLabel layerNameLabel = null;
    private JLabel layerNameValueLabel = null;
    private JLabel imageFileLabel = null;
    private JLabel imageFileValueLabel = null;
    private JLabel sizeLabel = null;
    private JLabel sizeValueLabel = null;
    private JLabel crsLabel = null;
    private JLabel crsValueLabel = null;
    private JLabel extentLabel = null;
    private JLabel defaultCRSDescriptorLabel = null;
    private JLabel defaultCRSLabel = null;
    private JTextField searchField = null;
    private JScrollPane crsListScrollPane = null;
    private JList crsJList = null;
    private JButton useDefaultCRSButton = null;
    private JButton applySelectedCRSButton = null;
    private JButton setSelectedCRSAsDefaultButton = null;
    private JLabel searchFieldLabel = null;
    private JCheckBox eastingFirstCheckBox = null;
    private JLabel eastingFirstLabel = null;
    private JLabel tabDescriptionLabel = null;
    private JLabel upperLeftLabel = null;
    private JLabel lowerLeftLabel = null;
    private JLabel upperRightLabel = null;
    private JLabel lowerRightLabel = null;
    private JLabel upperLeftValueLabel = null;
    private JLabel upperRightValueLabel = null;
    private JLabel lowerLeftValueLabel = null;
    private JLabel lowerRightValueLabel = null;
    private JLabel currentCRSLabel = null;
    private JLabel currentCRSValueLabel = null;

    public LayerPropertiesDialog(ImageLayer imageLayer, Vector<String> supportedCRS) {
        super(imageLayer.getName());
        this.supportedCRS = supportedCRS;
        this.imageLayer = imageLayer;
        this.initialize();
    }

    public LayerPropertiesDialog(Vector<String> supportedCRS) {
        this.supportedCRS = supportedCRS;
        this.initialize();
    }

    private void initialize() {
        this.setMinimumSize(new Dimension(404, 485));
        this.setContentPane(this.getMainPanel());
        this.setPreferredSize(new Dimension(404, 485));
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(null);
            this.mainPanel.add((Component)this.getJPanel(), null);
            this.mainPanel.add((Component)this.getButtonPanel(), null);
        }
        return this.mainPanel;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.setBounds(new Rectangle(0, 0, 391, 406));
            this.jPanel.add((Component)this.getJTabbedPane(), gridBagConstraints);
        }
        return this.jPanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(null);
            this.buttonPanel.setBounds(new Rectangle(0, 405, 391, 46));
            this.buttonPanel.add((Component)this.getOkButton(), null);
        }
        return this.buttonPanel;
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.addTab("General Information", null, this.getInfoPanel(), null);
            this.jTabbedPane.addTab("Source Reference System", null, this.getCrsPanel(), null);
        }
        return this.jTabbedPane;
    }

    private JPanel getInfoPanel() {
        if (this.infoPanel == null) {
            this.lowerRightValueLabel = new JLabel();
            this.lowerRightValueLabel.setBounds(new Rectangle(210, 315, 134, 16));
            this.lowerRightValueLabel.setHorizontalAlignment(4);
            this.lowerRightValueLabel.setText((float)this.imageLayer.getBbox().getMinX() + ", " + (float)this.imageLayer.getBbox().getMaxY());
            this.lowerLeftValueLabel = new JLabel();
            this.lowerLeftValueLabel.setBounds(new Rectangle(30, 315, 133, 16));
            this.lowerLeftValueLabel.setHorizontalAlignment(2);
            this.lowerLeftValueLabel.setText((float)this.imageLayer.getBbox().getMinX() + ", " + (float)this.imageLayer.getBbox().getMinY());
            this.upperRightValueLabel = new JLabel();
            this.upperRightValueLabel.setBounds(new Rectangle(210, 255, 138, 16));
            this.upperRightValueLabel.setHorizontalAlignment(4);
            this.upperRightValueLabel.setText((float)this.imageLayer.getBbox().getMaxX() + ", " + (float)this.imageLayer.getBbox().getMaxY());
            this.upperLeftValueLabel = new JLabel();
            this.upperLeftValueLabel.setBounds(new Rectangle(30, 255, 133, 16));
            this.upperLeftValueLabel.setHorizontalAlignment(2);
            this.upperLeftValueLabel.setText((float)this.imageLayer.getBbox().getMaxX() + ", " + (float)this.imageLayer.getBbox().getMinY());
            this.lowerRightLabel = new JLabel();
            this.lowerRightLabel.setBounds(new Rectangle(287, 344, 74, 16));
            this.lowerRightLabel.setText("Lower Right");
            this.upperRightLabel = new JLabel();
            this.upperRightLabel.setBounds(new Rectangle(285, 225, 91, 16));
            this.upperRightLabel.setText("Upper Right");
            this.lowerLeftLabel = new JLabel();
            this.lowerLeftLabel.setBounds(new Rectangle(15, 345, 92, 16));
            this.lowerLeftLabel.setText("Lower Left");
            this.upperLeftLabel = new JLabel();
            this.upperLeftLabel.setBounds(new Rectangle(15, 224, 91, 16));
            this.upperLeftLabel.setText("Upper Left");
            this.extentLabel = new JLabel();
            this.extentLabel.setBounds(new Rectangle(120, 195, 136, 16));
            this.extentLabel.setEnabled(false);
            this.extentLabel.setHorizontalAlignment(0);
            this.extentLabel.setDisplayedMnemonic(0);
            this.extentLabel.setText("Extent");
            this.crsValueLabel = new JLabel();
            this.crsValueLabel.setBounds(new Rectangle(150, 150, 226, 16));
            String crsDescription = "";
            try {
                crsDescription = ((ReferenceIdentifier)this.imageLayer.getBbox().getCoordinateReferenceSystem().getIdentifiers().iterator().next()).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.crsValueLabel.setText(crsDescription + "(" + this.imageLayer.getBbox().getCoordinateReferenceSystem().getName().toString() + ")");
            this.crsLabel = new JLabel();
            this.crsLabel.setBounds(new Rectangle(15, 150, 118, 16));
            this.crsLabel.setText("Reference System");
            this.sizeValueLabel = new JLabel();
            this.sizeValueLabel.setBounds(new Rectangle(150, 105, 226, 16));
            this.sizeValueLabel.setText(this.imageLayer.getImage().getHeight() + " x " + this.imageLayer.getImage().getWidth());
            this.sizeLabel = new JLabel();
            this.sizeLabel.setBounds(new Rectangle(15, 105, 121, 16));
            this.sizeLabel.setText("Image size");
            this.imageFileValueLabel = new JLabel();
            this.imageFileValueLabel.setBounds(new Rectangle(150, 60, 226, 16));
            this.imageFileValueLabel.setText(this.imageLayer.getImageFile().getAbsolutePath());
            this.imageFileValueLabel.setToolTipText(this.imageLayer.getImageFile().getAbsolutePath());
            this.imageFileLabel = new JLabel();
            this.imageFileLabel.setBounds(new Rectangle(15, 60, 121, 16));
            this.imageFileLabel.setText("Image file");
            this.layerNameValueLabel = new JLabel();
            this.layerNameValueLabel.setBounds(new Rectangle(150, 15, 226, 16));
            this.layerNameValueLabel.setText(this.imageLayer.getName());
            this.layerNameLabel = new JLabel();
            this.layerNameLabel.setBounds(new Rectangle(15, 15, 121, 16));
            this.layerNameLabel.setText("Layer name");
            this.infoPanel = new JPanel();
            this.infoPanel.setLayout(null);
            this.infoPanel.setFont(new Font("Dialog", 1, 12));
            this.infoPanel.add((Component)this.layerNameLabel, null);
            this.infoPanel.add((Component)this.layerNameValueLabel, null);
            this.infoPanel.add((Component)this.imageFileLabel, null);
            this.infoPanel.add((Component)this.imageFileValueLabel, null);
            this.infoPanel.add((Component)this.sizeLabel, null);
            this.infoPanel.add((Component)this.sizeValueLabel, null);
            this.infoPanel.add((Component)this.crsLabel, null);
            this.infoPanel.add((Component)this.crsValueLabel, null);
            this.infoPanel.add((Component)this.extentLabel, null);
            this.infoPanel.add((Component)this.upperLeftLabel, null);
            this.infoPanel.add((Component)this.lowerLeftLabel, null);
            this.infoPanel.add((Component)this.upperRightLabel, null);
            this.infoPanel.add((Component)this.lowerRightLabel, null);
            this.infoPanel.add((Component)this.upperLeftValueLabel, null);
            this.infoPanel.add((Component)this.upperRightValueLabel, null);
            this.infoPanel.add((Component)this.lowerLeftValueLabel, null);
            this.infoPanel.add((Component)this.lowerRightValueLabel, null);
        }
        return this.infoPanel;
    }

    private JPanel getCrsPanel() {
        if (this.crsPanel == null) {
            this.currentCRSValueLabel = new JLabel();
            this.currentCRSValueLabel.setBounds(new Rectangle(78, 33, 297, 16));
            String crsDescription = "unknown";
            try {
                crsDescription = ((ReferenceIdentifier)this.imageLayer.getSourceRefSys().getIdentifiers().iterator().next()).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.currentCRSValueLabel.setText(crsDescription);
            this.currentCRSLabel = new JLabel();
            this.currentCRSLabel.setBounds(new Rectangle(15, 33, 52, 16));
            this.currentCRSLabel.setText("Current:");
            this.tabDescriptionLabel = new JLabel();
            this.tabDescriptionLabel.setBounds(new Rectangle(15, 9, 361, 16));
            this.tabDescriptionLabel.setText("Set here the source reference system of the image");
            this.eastingFirstLabel = new JLabel();
            this.eastingFirstLabel.setBounds(new Rectangle(315, 210, 76, 46));
            this.eastingFirstLabel.setHorizontalTextPosition(11);
            this.eastingFirstLabel.setHorizontalAlignment(0);
            this.eastingFirstLabel.setText("<html>Easting<br>first</html>");
            this.searchFieldLabel = new JLabel();
            this.searchFieldLabel.setBounds(new Rectangle(298, 114, 84, 16));
            this.searchFieldLabel.setDisplayedMnemonic(0);
            this.searchFieldLabel.setHorizontalTextPosition(11);
            this.searchFieldLabel.setHorizontalAlignment(0);
            this.searchFieldLabel.setText("Search");
            this.defaultCRSLabel = new JLabel();
            this.defaultCRSLabel.setBounds(new Rectangle(15, 89, 361, 16));
            this.defaultCRSLabel.setText(PluginOperations.defaultSourceCRSDescription);
            this.defaultCRSDescriptorLabel = new JLabel();
            this.defaultCRSDescriptorLabel.setBounds(new Rectangle(15, 63, 226, 16));
            this.defaultCRSDescriptorLabel.setText("Default Reference System:");
            this.crsPanel = new JPanel();
            this.crsPanel.setLayout(null);
            this.crsPanel.add((Component)this.defaultCRSDescriptorLabel, null);
            this.crsPanel.add((Component)this.defaultCRSLabel, null);
            this.crsPanel.add((Component)this.getSearchField(), null);
            this.crsPanel.add((Component)this.getCrsListScrollPane(), null);
            this.crsPanel.add((Component)this.getUseDefaultCRSButton(), null);
            this.crsPanel.add((Component)this.getApplySelectedCRSButton(), null);
            this.crsPanel.add((Component)this.getSetSelectedCRSAsDefaultButton(), null);
            this.crsPanel.add((Component)this.searchFieldLabel, null);
            this.crsPanel.add((Component)this.getEastingFirstCheckBox(), null);
            this.crsPanel.add((Component)this.eastingFirstLabel, null);
            this.crsPanel.add((Component)this.tabDescriptionLabel, null);
            this.crsPanel.add((Component)this.currentCRSLabel, null);
            this.crsPanel.add((Component)this.currentCRSValueLabel, null);
        }
        return this.crsPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setBounds(new Rectangle(134, 5, 136, 31));
            this.okButton.setText("OK");
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LayerPropertiesDialog.this.setVisible(false);
                    LayerPropertiesDialog.this.dispose();
                }
            });
        }
        return this.okButton;
    }

    private JTextField getSearchField() {
        if (this.searchField == null) {
            this.searchField = new JTextField();
            this.searchField.setBounds(new Rectangle(13, 111, 282, 20));
            this.searchField.setToolTipText("Enter keywords or EPSG codes");
            this.searchField.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    for (String type : LayerPropertiesDialog.this.supportedCRS) {
                        if (!type.contains(LayerPropertiesDialog.this.searchField.getText())) continue;
                        LayerPropertiesDialog.this.crsJList.setSelectedIndex(LayerPropertiesDialog.this.supportedCRS.indexOf(type));
                        LayerPropertiesDialog.this.crsJList.ensureIndexIsVisible(LayerPropertiesDialog.this.supportedCRS.indexOf(type));
                        break;
                    }
                }
            });
        }
        return this.searchField;
    }

    private JScrollPane getCrsListScrollPane() {
        if (this.crsListScrollPane == null) {
            this.crsListScrollPane = new JScrollPane();
            this.crsListScrollPane.setBounds(new Rectangle(15, 135, 301, 241));
            this.crsListScrollPane.setViewportView(this.getCrsJList());
        }
        return this.crsListScrollPane;
    }

    private JList getCrsJList() {
        if (this.crsJList == null) {
            this.crsJList = new JList<String>(this.supportedCRS);
            this.crsJList.addListSelectionListener(new ListSelectionHandler());
        }
        return this.crsJList;
    }

    private JButton getUseDefaultCRSButton() {
        if (this.useDefaultCRSButton == null) {
            this.useDefaultCRSButton = new JButton();
            this.useDefaultCRSButton.setBounds(new Rectangle(253, 54, 118, 28));
            this.useDefaultCRSButton.setText("Apply Default");
            this.useDefaultCRSButton.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent e) {
                    try {
                        LayerPropertiesDialog.this.setCursor(new Cursor(3));
                        if (PluginOperations.defaultSourceCRS != null) {
                            LayerPropertiesDialog.this.imageLayer.resample(PluginOperations.defaultSourceCRS);
                        } else {
                            JOptionPane.showMessageDialog(LayerPropertiesDialog.this.getContentPane(), "<html>No default reference system available.<br>Please select one from the list</html>");
                        }
                    }
                    catch (NoSuchAuthorityCodeException e1) {
                        e1.printStackTrace();
                    }
                    catch (FactoryException e1) {
                        e1.printStackTrace();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    finally {
                        LayerPropertiesDialog.this.setCursor(new Cursor(0));
                    }
                }
            });
        }
        return this.useDefaultCRSButton;
    }

    private JButton getApplySelectedCRSButton() {
        if (this.applySelectedCRSButton == null) {
            this.applySelectedCRSButton = new JButton();
            this.applySelectedCRSButton.setBounds(new Rectangle(315, 135, 69, 61));
            this.applySelectedCRSButton.setHorizontalAlignment(0);
            this.applySelectedCRSButton.setHorizontalTextPosition(11);
            this.applySelectedCRSButton.setText("<html>Apply<br>Selection</html>");
            this.applySelectedCRSButton.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent e) {
                    String selection = (String)LayerPropertiesDialog.this.crsJList.getSelectedValue();
                    String code = selection.substring(selection.indexOf("[-") + 2, selection.indexOf("-]"));
                    CoordinateReferenceSystem newRefSys = null;
                    try {
                        newRefSys = CRS.decode((String)code, (boolean)LayerPropertiesDialog.this.eastingFirstCheckBox.isSelected());
                        LayerPropertiesDialog.this.setCursor(new Cursor(3));
                        LayerPropertiesDialog.this.imageLayer.resample(newRefSys);
                    }
                    catch (NoSuchAuthorityCodeException e1) {
                        e1.printStackTrace();
                    }
                    catch (FactoryException e1) {
                        e1.printStackTrace();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    finally {
                        LayerPropertiesDialog.this.setCursor(new Cursor(0));
                    }
                }
            });
        }
        return this.applySelectedCRSButton;
    }

    private JButton getSetSelectedCRSAsDefaultButton() {
        if (this.setSelectedCRSAsDefaultButton == null) {
            this.setSelectedCRSAsDefaultButton = new JButton();
            this.setSelectedCRSAsDefaultButton.setBounds(new Rectangle(315, 300, 69, 61));
            this.setSelectedCRSAsDefaultButton.setText("<html>Set as<br>Default</html>");
            this.setSelectedCRSAsDefaultButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (LayerPropertiesDialog.this.crsJList.getSelectedValue() != null) {
                        String selection = (String)LayerPropertiesDialog.this.crsJList.getSelectedValue();
                        String code = selection.substring(selection.indexOf("[-") + 2, selection.indexOf("-]"));
                        try {
                            PluginOperations.defaultSourceCRS = CRS.decode((String)code, (boolean)LayerPropertiesDialog.this.eastingFirstCheckBox.isSelected());
                            PluginOperations.defaultSourceCRSDescription = selection;
                            ImageImportPlugin.pluginProps.setProperty("default_crs_eastingfirst", "" + LayerPropertiesDialog.this.eastingFirstCheckBox.isSelected());
                            ImageImportPlugin.pluginProps.setProperty("default_crs_srid", code);
                            FileWriter fileWriter = new FileWriter(new File(ImageImportPlugin.PLUGINPROPERTIES_PATH));
                            ImageImportPlugin.pluginProps.store(fileWriter, null);
                            fileWriter.close();
                            LayerPropertiesDialog.this.defaultCRSLabel.setText(selection);
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                        catch (NoSuchAuthorityCodeException e3) {
                            e3.printStackTrace();
                        }
                        catch (FactoryException e4) {
                            e4.printStackTrace();
                        }
                    } else {
                        JOptionPane.showMessageDialog(LayerPropertiesDialog.this.getContentPane(), "Please make a selection from the list.");
                    }
                }
            });
        }
        return this.setSelectedCRSAsDefaultButton;
    }

    private JCheckBox getEastingFirstCheckBox() {
        if (this.eastingFirstCheckBox == null) {
            this.eastingFirstCheckBox = new JCheckBox();
            this.eastingFirstCheckBox.setBounds(new Rectangle(345, 255, 21, 21));
        }
        return this.eastingFirstCheckBox;
    }

    class ListSelectionHandler
    implements ListSelectionListener {
        ListSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                LayerPropertiesDialog.this.searchField.setText((String)LayerPropertiesDialog.this.supportedCRS.get(e.getLastIndex()));
                LayerPropertiesDialog.this.searchField.setEditable(true);
            }
        }
    }
}

