/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitiveIdTransferable
implements Transferable {
    public static final DataFlavor PRIMITIVE_ID_LIST_FLAVOR = new DataFlavor(Set.class, "a set of OSM primitive ids");
    public static final DataFlavor[] SUPPORTED_FLAVORS = new DataFlavor[]{PRIMITIVE_ID_LIST_FLAVOR, DataFlavor.stringFlavor};
    private List<PrimitiveId> ids = new ArrayList<PrimitiveId>();

    public PrimitiveIdTransferable(List<PrimitiveId> ids) {
        if (ids == null) {
            return;
        }
        for (PrimitiveId id : ids) {
            this.ids.add((PrimitiveId)new SimplePrimitiveId(id.getUniqueId(), id.getType()));
        }
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (PRIMITIVE_ID_LIST_FLAVOR.equals(flavor)) {
            return this.getPrimitiveIds();
        }
        if (DataFlavor.stringFlavor.equals(flavor)) {
            return this.getAsString();
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public List<PrimitiveId> getPrimitiveIds() {
        return this.ids;
    }

    public String getAsString() {
        StringBuffer sb = new StringBuffer();
        for (PrimitiveId id : this.ids) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(id.getType().getAPIName()).append("/").append(id.getUniqueId());
        }
        return sb.toString();
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return SUPPORTED_FLAVORS;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (DataFlavor df : SUPPORTED_FLAVORS) {
            if (!df.equals(flavor)) continue;
            return true;
        }
        return false;
    }
}

