/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.plugins.remotecontrol.RequestHandler;
import org.openstreetmap.josm.plugins.remotecontrol.RequestHandlerErrorException;
import org.openstreetmap.josm.tools.I18n;
import wmsplugin.WMSInfo;
import wmsplugin.WMSLayer;

public class WMSRemoteHandler
extends RequestHandler {
    public static final String command = "wms";

    public String getPermissionMessage() {
        return I18n.tr((String)"Remote Control has been asked to load a WMS layer from the following URL:") + "<br>" + (String)this.args.get("url");
    }

    public PermissionPrefWithDefault getPermissionPref() {
        return new PermissionPrefWithDefault("wmsplugin.remotecontrol", true, "RemoteControl: WMS forbidden by preferences");
    }

    protected String[] getMandatoryParams() {
        return new String[]{"url"};
    }

    protected void handleRequest() throws RequestHandlerErrorException {
        String url = (String)this.args.get("url");
        String title = (String)this.args.get("title");
        if (title == null || title.length() == 0) {
            title = I18n.tr((String)"Remote WMS");
        }
        String cookies = (String)this.args.get("cookies");
        WMSLayer wmsLayer = new WMSLayer(new WMSInfo(title, url, cookies));
        Main.main.addLayer((Layer)wmsLayer);
    }

    public void parseArgs() {
        int urlpos;
        StringTokenizer st = new StringTokenizer(this.request, "&?");
        HashMap<String, String> args = new HashMap<String, String>();
        if (st.hasMoreTokens()) {
            st.nextToken();
        }
        while (st.hasMoreTokens()) {
            String param = st.nextToken();
            int eq = param.indexOf("=");
            if (eq <= -1) continue;
            String key = param.substring(0, eq);
            if ("url".equals(key)) break;
            String value = param.substring(eq + 1);
            try {
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            args.put(key, value);
        }
        if ((urlpos = this.request.indexOf("&url=")) < 0) {
            urlpos = this.request.indexOf("?url=");
        }
        if (urlpos >= 0) {
            String value = this.request.substring(urlpos + 5);
            String urldecode = (String)args.get("urldecode");
            if (urldecode == null || Boolean.valueOf(urldecode).booleanValue()) {
                try {
                    value = URLDecoder.decode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            args.put("url", value);
        }
        this.args = args;
    }
}

