/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMSInfo
implements Comparable<WMSInfo> {
    String name;
    String url = null;
    String cookies = null;
    boolean html = false;
    double pixelPerDegree = 0.0;

    public WMSInfo(String name) {
        this.name = name;
    }

    public WMSInfo(String name, String url) {
        this.name = name;
        this.setURL(url);
    }

    public WMSInfo(String name, String url, String cookies) {
        this.name = name;
        this.setURL(url);
        this.cookies = cookies;
    }

    public WMSInfo(String name, String url, String cookies, double pixelPerDegree) {
        this.name = name;
        this.setURL(url);
        this.cookies = cookies;
        this.pixelPerDegree = pixelPerDegree;
    }

    public ArrayList<String> getInfoArray() {
        String e2 = null;
        String e3 = null;
        String e4 = null;
        if (this.url != null && !this.url.isEmpty()) {
            e2 = this.getFullURL();
        }
        if (this.cookies != null && !this.cookies.isEmpty()) {
            e3 = this.cookies;
        }
        if (this.pixelPerDegree != 0.0) {
            e4 = String.valueOf(this.pixelPerDegree);
        }
        if (e4 != null && e3 == null) {
            e3 = "";
        }
        if (e3 != null && e2 == null) {
            e2 = "";
        }
        ArrayList<String> res = new ArrayList<String>();
        res.add(this.name);
        if (e2 != null) {
            res.add(e2);
        }
        if (e3 != null) {
            res.add(e3);
        }
        if (e4 != null) {
            res.add(e4);
        }
        return res;
    }

    public WMSInfo(Collection<String> list) {
        ArrayList<String> array = new ArrayList<String>(list);
        this.name = array.get(0);
        if (array.size() >= 2) {
            this.setURL(array.get(1));
        }
        if (array.size() >= 3) {
            this.cookies = array.get(2);
        }
        if (array.size() >= 4) {
            this.pixelPerDegree = Double.valueOf(array.get(3));
        }
    }

    public WMSInfo(WMSInfo i) {
        this.name = i.name;
        this.url = i.url;
        this.cookies = i.cookies;
        this.html = i.html;
        this.pixelPerDegree = i.pixelPerDegree;
    }

    @Override
    public int compareTo(WMSInfo in) {
        int i = this.name.compareTo(in.name);
        if (i == 0) {
            i = this.url.compareTo(in.url);
        }
        if (i == 0) {
            i = Double.compare(this.pixelPerDegree, in.pixelPerDegree);
        }
        return i;
    }

    public boolean equalsBaseValues(WMSInfo in) {
        return this.url.equals(in.url);
    }

    public void setPixelPerDegree(double ppd) {
        this.pixelPerDegree = ppd;
    }

    public void setURL(String url) {
        if (url.startsWith("html:")) {
            this.url = url.substring(5);
            this.html = true;
        } else {
            this.url = url;
        }
    }

    public String getFullURL() {
        return this.html ? "html:" + this.url : this.url;
    }

    public String getToolbarName() {
        String res = this.name;
        if (this.pixelPerDegree != 0.0) {
            res = res + "#PPD=" + this.pixelPerDegree;
        }
        return res;
    }

    public String getMenuName() {
        String res = this.name;
        if (this.pixelPerDegree != 0.0) {
            res = res + " (" + this.pixelPerDegree + ")";
        }
        return res;
    }
}

