/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import org.geotools.styling.Description;
import org.geotools.styling.DescriptionImpl;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Stroke;
import org.geotools.styling.StrokeImpl;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.Utilities;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Symbolizer;
import org.opengis.util.Cloneable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineSymbolizerImpl
implements LineSymbolizer,
Cloneable {
    private Description description;
    private String name;
    private Expression offset;
    private Unit<Length> uom = null;
    private StrokeImpl stroke = null;
    private String geometryName = null;

    protected LineSymbolizerImpl() {
        this(null, null, null, null, null, null);
    }

    protected LineSymbolizerImpl(Stroke stroke, Expression offset, Unit<Length> uom, String geom, String name, Description desc) {
        this.stroke = StrokeImpl.cast(stroke);
        this.offset = offset;
        this.uom = uom;
        this.geometryName = geom;
        this.name = name;
        this.description = desc;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Description getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(org.opengis.style.Description description) {
        this.description = DescriptionImpl.cast(description);
    }

    public String getGeometryPropertyName() {
        return this.geometryName;
    }

    @Override
    public void setGeometryPropertyName(String name) {
        this.geometryName = name;
    }

    public Unit<Length> getUnitOfMeasure() {
        return this.uom;
    }

    @Override
    public void setUnitOfMeasure(Unit<Length> uom) {
        this.uom = uom;
    }

    public Expression getPerpendicularOffset() {
        return this.offset;
    }

    @Override
    public void setPerpendicularOffset(Expression offset) {
        this.offset = offset;
    }

    @Override
    public StrokeImpl getStroke() {
        return this.stroke;
    }

    @Override
    public void setStroke(org.opengis.style.Stroke stroke) {
        if (this.stroke == stroke) {
            return;
        }
        this.stroke = StrokeImpl.cast(stroke);
    }

    public Object accept(org.opengis.style.StyleVisitor visitor, Object data) {
        return visitor.visit((org.opengis.style.LineSymbolizer)this, data);
    }

    @Override
    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        LineSymbolizerImpl clone;
        try {
            clone = (LineSymbolizerImpl)super.clone();
            if (this.stroke != null && this.stroke instanceof Cloneable) {
                clone.stroke = (StrokeImpl)this.stroke.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return clone;
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.name != null) {
            result = 1000003 * result + this.name.hashCode();
        }
        if (this.stroke != null) {
            result = 1000003 * result + this.stroke.hashCode();
        }
        if (this.geometryName != null) {
            result = 1000003 * result + this.geometryName.hashCode();
        }
        if (this.uom != null) {
            result = 1000003 * result + this.uom.hashCode();
        }
        if (this.description != null) {
            result = 1000003 * result + this.description.hashCode();
        }
        if (this.offset != null) {
            result = 1000003 * result + this.offset.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null) {
            return false;
        }
        if (oth.getClass() != this.getClass()) {
            return false;
        }
        LineSymbolizerImpl other = (LineSymbolizerImpl)oth;
        if (this.geometryName == null ? other.geometryName != null : !this.geometryName.equals(other.geometryName)) {
            return false;
        }
        if (!Utilities.equals((Object)this.getStroke(), (Object)other.getStroke())) {
            return false;
        }
        if (!Utilities.equals(this.uom, other.uom)) {
            return false;
        }
        if (!Utilities.equals((Object)this.description, (Object)other.description)) {
            return false;
        }
        return Utilities.equals((Object)this.offset, (Object)other.offset);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<LineSymbolizerImp property=");
        buf.append(this.geometryName);
        buf.append(" uom=");
        buf.append(this.uom);
        buf.append(" stroke=");
        buf.append(this.stroke);
        buf.append(">");
        return buf.toString();
    }

    static LineSymbolizerImpl cast(Symbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        if (symbolizer instanceof LineSymbolizerImpl) {
            return (LineSymbolizerImpl)symbolizer;
        }
        if (symbolizer instanceof org.opengis.style.LineSymbolizer) {
            org.opengis.style.LineSymbolizer lineSymbolizer = (org.opengis.style.LineSymbolizer)symbolizer;
            LineSymbolizerImpl copy = new LineSymbolizerImpl();
            copy.setDescription(lineSymbolizer.getDescription());
            copy.setGeometryPropertyName(lineSymbolizer.getGeometryPropertyName());
            copy.setName(lineSymbolizer.getName());
            copy.setPerpendicularOffset(lineSymbolizer.getPerpendicularOffset());
            copy.setStroke(lineSymbolizer.getStroke());
            copy.setUnitOfMeasure((Unit<Length>)lineSymbolizer.getUnitOfMeasure());
            return copy;
        }
        return null;
    }
}

