/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.MedianVisitor;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.visitor.AbstractFilterVisitor;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Collection_MedianFunction
extends FunctionExpressionImpl
implements FunctionExpression {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.filter.function");
    FeatureCollection<? extends FeatureType, ? extends Feature> previousFeatureCollection = null;
    Object median = null;

    public Collection_MedianFunction() {
        super("Collection_Median");
    }

    @Override
    public int getArgCount() {
        return 1;
    }

    static CalcResult calculateMedian(FeatureCollection<? extends FeatureType, ? extends Feature> collection, Expression expression) throws IllegalFilterException, IOException {
        MedianVisitor medianVisitor = new MedianVisitor(expression);
        collection.accepts(medianVisitor, null);
        return medianVisitor.getResult();
    }

    @Override
    public void setParameters(List args) {
        super.setParameters(args);
        Expression expr = (Expression)this.getExpression(0);
        expr.accept(new AbstractFilterVisitor(){

            public void visit(AttributeExpression expression) {
                String xpath = expression.getAttributePath();
                if (xpath.startsWith("featureMembers/*/")) {
                    xpath = xpath.substring(17);
                } else if (xpath.startsWith("featureMember/*/")) {
                    xpath = xpath.substring(16);
                }
                try {
                    expression.setAttributePath(xpath);
                }
                catch (IllegalFilterException illegalFilterException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evaluate(Object feature) {
        FeatureCollection featureCollection;
        if (feature == null) {
            return new Integer(0);
        }
        Expression expr = (Expression)this.getExpression(0);
        FeatureCollection featureCollection2 = featureCollection = (FeatureCollection)feature;
        synchronized (featureCollection2) {
            if (featureCollection != this.previousFeatureCollection) {
                this.previousFeatureCollection = featureCollection;
                this.median = null;
                try {
                    CalcResult result = Collection_MedianFunction.calculateMedian(featureCollection, expr);
                    if (result != null) {
                        this.median = result.getValue();
                    }
                }
                catch (IllegalFilterException e) {
                    LOGGER.log(Level.FINER, e.getLocalizedMessage(), e);
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINER, e.getLocalizedMessage(), e);
                }
            }
        }
        return this.median;
    }

    public void setExpression(Expression e) {
        this.setParameters(Collections.singletonList(e));
    }
}

