/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.capability;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.geotools.filter.capability.SpatialOperatorsImpl;
import org.opengis.filter.capability.GeometryOperand;
import org.opengis.filter.capability.SpatialCapabilities;
import org.opengis.filter.capability.SpatialOperators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpatialCapabiltiesImpl
implements SpatialCapabilities {
    Set<GeometryOperand> geometryOperands;
    SpatialOperatorsImpl spatialOperators;

    public SpatialCapabiltiesImpl() {
        this.geometryOperands = new HashSet<GeometryOperand>();
        this.spatialOperators = new SpatialOperatorsImpl();
    }

    public SpatialCapabiltiesImpl(Collection<GeometryOperand> geometryOperands, SpatialOperators spatialOperators) {
        this.geometryOperands = new HashSet<GeometryOperand>();
        if (geometryOperands != null) {
            this.geometryOperands.addAll(geometryOperands);
        }
        this.spatialOperators = SpatialCapabiltiesImpl.toSpatialOperatorsImpl(spatialOperators);
    }

    public SpatialCapabiltiesImpl(GeometryOperand[] geometryOperands, SpatialOperators spatialOperators) {
        this.geometryOperands = new HashSet<GeometryOperand>();
        if (geometryOperands != null) {
            this.geometryOperands.addAll(Arrays.asList(geometryOperands));
        }
        this.spatialOperators = SpatialCapabiltiesImpl.toSpatialOperatorsImpl(spatialOperators);
    }

    public SpatialCapabiltiesImpl(SpatialCapabilities copy) {
        this.spatialOperators = new SpatialOperatorsImpl();
        this.geometryOperands = new HashSet<GeometryOperand>();
        if (copy.getGeometryOperands() != null) {
            this.geometryOperands.addAll(copy.getGeometryOperands());
        }
    }

    private static SpatialOperatorsImpl toSpatialOperatorsImpl(SpatialOperators spatialOperators) {
        if (spatialOperators == null) {
            return new SpatialOperatorsImpl();
        }
        if (spatialOperators instanceof SpatialOperatorsImpl) {
            return (SpatialOperatorsImpl)spatialOperators;
        }
        return new SpatialOperatorsImpl(spatialOperators);
    }

    public void setGeometryOperands(Collection<GeometryOperand> geometryOperands) {
        this.geometryOperands = new HashSet<GeometryOperand>(geometryOperands);
    }

    public Collection<GeometryOperand> getGeometryOperands() {
        return this.geometryOperands;
    }

    public void setSpatialOperators(SpatialOperatorsImpl spatialOperators) {
        this.spatialOperators = spatialOperators;
    }

    public SpatialOperatorsImpl getSpatialOperators() {
        if (this.spatialOperators == null) {
            this.spatialOperators = new SpatialOperatorsImpl();
        }
        return this.spatialOperators;
    }

    public void addAll(SpatialCapabilities copy) {
        if (copy.getGeometryOperands() != null) {
            this.geometryOperands.addAll(copy.getGeometryOperands());
        }
        this.spatialOperators.addAll(copy.getSpatialOperators());
    }
}

