/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.CalcUtil;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.filter.IllegalFilterException;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinVisitor
implements FeatureCalc {
    private Expression expr;
    Comparable minvalue;
    Comparable curvalue;
    boolean visited = false;

    public MinVisitor(String attributeTypeName) {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        this.expr = factory.property(attributeTypeName);
    }

    public MinVisitor(int attributeTypeIndex, SimpleFeatureType type) throws IllegalFilterException {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        this.expr = factory.property(type.getDescriptor(attributeTypeIndex).getLocalName());
    }

    public MinVisitor(String attrName, SimpleFeatureType type) throws IllegalFilterException {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        this.expr = factory.property(type.getDescriptor(attrName).getLocalName());
    }

    public MinVisitor(Expression expr) throws IllegalFilterException {
        this.expr = expr;
    }

    public void init(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) {
    }

    @Override
    public void visit(SimpleFeature feature) {
        this.visit((Feature)feature);
    }

    public void visit(Feature feature) {
        Object attribValue = this.expr.evaluate((Object)feature);
        if (attribValue == null) {
            return;
        }
        this.curvalue = (Comparable)attribValue;
        if (!this.visited || this.curvalue.compareTo(this.minvalue) < 0) {
            this.minvalue = this.curvalue;
            this.visited = true;
        }
    }

    public Comparable getMin() {
        if (!this.visited) {
            throw new IllegalStateException("Must visit before min value is ready!");
        }
        return this.minvalue;
    }

    public void reset() {
        this.visited = false;
        this.minvalue = new Integer(0);
    }

    @Override
    public CalcResult getResult() {
        if (!this.visited) {
            throw new IllegalStateException("Must visit before min value is ready!");
        }
        return new MinResult(this.minvalue);
    }

    public Expression getExpression() {
        return this.expr;
    }

    public void setValue(Object result) {
        this.visited = true;
        this.minvalue = (Comparable)result;
    }

    public static class MinResult
    extends AbstractCalcResult {
        private Comparable minValue;

        public MinResult(Comparable newMinValue) {
            this.minValue = newMinValue;
        }

        public Object getValue() {
            Comparable min = this.minValue;
            return min;
        }

        public boolean isCompatible(CalcResult targetResults) {
            return targetResults instanceof MinResult;
        }

        public CalcResult merge(CalcResult resultsToAdd) {
            if (!this.isCompatible(resultsToAdd)) {
                throw new IllegalArgumentException("Parameter is not a compatible type");
            }
            if (resultsToAdd instanceof MinResult) {
                Comparable toAdd = (Comparable)resultsToAdd.getValue();
                Comparable newMin = this.minValue;
                if (newMin.getClass() != toAdd.getClass()) {
                    Class bestClass = CalcUtil.bestClass(new Object[]{toAdd, newMin});
                    if (bestClass != toAdd.getClass()) {
                        toAdd = (Comparable)CalcUtil.convert(toAdd, bestClass);
                    }
                    if (bestClass != newMin.getClass()) {
                        newMin = (Comparable)CalcUtil.convert(newMin, bestClass);
                    }
                }
                if (newMin.compareTo(toAdd) > 0) {
                    newMin = toAdd;
                }
                return new MinResult(newMin);
            }
            throw new IllegalArgumentException("The CalcResults claim to be compatible, but the appropriate merge method has not been implemented.");
        }
    }
}

