/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.EmptyFeatureWriter;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FilteringFeatureWriter;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.store.ActiveTypeEntry;
import org.geotools.data.view.DefaultView;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.NameImpl;
import org.geotools.feature.SchemaException;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractDataStore2
implements DataStore {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data");
    private InProcessLockingManager lockingManager = this.createLockingManager();
    private List contents = null;

    protected InProcessLockingManager createLockingManager() {
        return new InProcessLockingManager();
    }

    public List entries() {
        if (this.contents == null) {
            this.contents = this.createContents();
        }
        return Collections.unmodifiableList(this.contents);
    }

    protected List createContents() {
        throw new UnsupportedOperationException("createContent not implemented");
    }

    @Override
    public String[] getTypeNames() {
        List all = this.entries();
        String[] names = new String[all.size()];
        int index = 0;
        for (ActiveTypeEntry entry : all) {
            names[index] = entry.getTypeName();
            ++index;
        }
        return names;
    }

    public ActiveTypeEntry entry(String typeName) {
        if (typeName == null) {
            return null;
        }
        for (ActiveTypeEntry entry : this.entries()) {
            if (!typeName.equals(entry.getTypeName())) continue;
            return entry;
        }
        return null;
    }

    @Override
    public ServiceInfo getInfo() {
        DefaultServiceInfo info = new DefaultServiceInfo();
        info.setDescription("Features from " + this.getClass().getSimpleName());
        info.setSchema(FeatureTypes.DEFAULT_NAMESPACE);
        return null;
    }

    @Override
    public SimpleFeatureType getSchema(String typeName) throws IOException {
        return this.entry(typeName).getFeatureType();
    }

    @Override
    public void createSchema(SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("Schema creation not supported");
    }

    @Override
    public void updateSchema(String typeName, SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("Schema modification not supported");
    }

    @Override
    public FeatureSource<SimpleFeatureType, SimpleFeature> getView(Query query) throws IOException, SchemaException {
        return new DefaultView(this.getFeatureSource(query.getTypeName()), query);
    }

    @Override
    public FeatureSource<SimpleFeatureType, SimpleFeature> getFeatureSource(String typeName) throws IOException {
        return this.entry(typeName).createFeatureSource();
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction transaction) throws IOException {
        if (query.getTypeName() == null) {
            throw new NullPointerException("getFeatureReader requires typeName: use getTypeNames() for a list of available types");
        }
        ActiveTypeEntry entry = this.entry(query.getTypeName());
        return entry.reader(query, transaction);
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        if (filter == null) {
            throw new NullPointerException("getFeatureReader requires Filter: did you mean Filter.INCLUDE?");
        }
        if (filter == Filter.EXCLUDE) {
            SimpleFeatureType featureType = this.getSchema(typeName);
            return new EmptyFeatureWriter(featureType);
        }
        FilteringFeatureWriter writer = this.getFeatureWriter(typeName, transaction);
        if (filter != Filter.INCLUDE) {
            writer = new FilteringFeatureWriter(writer, filter);
        }
        return writer;
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        return this.entry(typeName).writer(transaction);
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        return this.entry(typeName).createAppend(transaction);
    }

    @Override
    public LockingManager getLockingManager() {
        return this.lockingManager;
    }

    @Override
    public void dispose() {
    }

    @Override
    public FeatureSource<SimpleFeatureType, SimpleFeature> getFeatureSource(Name typeName) throws IOException {
        return this.getFeatureSource(typeName.getLocalPart());
    }

    @Override
    public List<Name> getNames() throws IOException {
        String[] typeNames = this.getTypeNames();
        ArrayList<Name> names = new ArrayList<Name>(typeNames.length);
        for (String typeName : typeNames) {
            names.add(new NameImpl(typeName));
        }
        return names;
    }

    @Override
    public SimpleFeatureType getSchema(Name name) throws IOException {
        return this.getSchema(name.getLocalPart());
    }

    @Override
    public void updateSchema(Name typeName, SimpleFeatureType featureType) throws IOException {
        this.updateSchema(typeName.getLocalPart(), featureType);
    }
}

