/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.awt.RenderingHints;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.geotools.factory.FactoryIteratorProvider;
import org.geotools.factory.FactoryIteratorProviders;
import org.geotools.factory.Hints;
import org.geotools.resources.Arguments;
import org.geotools.resources.Classes;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.geotools.util.Version;
import org.geotools.util.logging.LoggerFactory;
import org.geotools.util.logging.Logging;

public final class GeoTools {
    private static final Version VERSION = new Version("2.6.0");
    private static final EventListenerList LISTENERS = new EventListenerList();
    private static final Map<String, RenderingHints.Key> BINDINGS = new HashMap<String, RenderingHints.Key>();
    public static final String CRS_AUTHORITY_EXTRA_DIRECTORY = "org.geotools.referencing.crs-directory";
    public static final String EPSG_DATA_SOURCE = "org.geotools.referencing.epsg-datasource";
    public static final String FORCE_LONGITUDE_FIRST_AXIS_ORDER = "org.geotools.referencing.forceXY";
    private static InitialContext context;

    private GeoTools() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void bind(String property, RenderingHints.Key key) {
        Map<String, RenderingHints.Key> map = BINDINGS;
        synchronized (map) {
            RenderingHints.Key old = BINDINGS.put(property, key);
            if (old == null) {
                return;
            }
            BINDINGS.put(property, old);
        }
        throw new IllegalArgumentException(Errors.format(42, "property", property));
    }

    public static Version getVersion() {
        return VERSION;
    }

    public void setLoggerFactory(LoggerFactory factory) {
        Logging.GEOTOOLS.setLoggerFactory(factory);
    }

    public static void init(Hints hints) {
        Logging log = Logging.GEOTOOLS;
        try {
            log.setLoggerFactory("org.geotools.util.logging.CommonsLoggerFactory");
        }
        catch (ClassNotFoundException commonsException) {
            try {
                log.setLoggerFactory("org.geotools.util.logging.Log4JLoggerFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (log.getLoggerFactory() == null) {
            log.forceMonolineConsoleOutput();
        }
        if (hints != null) {
            Hints.putSystemDefault(hints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(InitialContext applicationContext) {
        Class<GeoTools> clazz = GeoTools.class;
        synchronized (GeoTools.class) {
            context = applicationContext;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            GeoTools.fireConfigurationChanged();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean scanForSystemHints(Hints hints) {
        assert (Thread.holdsLock(hints));
        boolean changed = false;
        Map<String, RenderingHints.Key> map = BINDINGS;
        synchronized (map) {
            for (Map.Entry<String, RenderingHints.Key> entry : BINDINGS.entrySet()) {
                Object old;
                String property;
                String propertyKey = entry.getKey();
                try {
                    property = System.getProperty(propertyKey);
                }
                catch (SecurityException e) {
                    GeoTools.unexpectedException(e);
                    continue;
                }
                if (property == null) continue;
                Object value = property;
                RenderingHints.Key hintKey = entry.getValue();
                if (hintKey.getClass().equals(Hints.Key.class)) {
                    Class<?> type = ((Hints.Key)hintKey).getValueClass();
                    if (type.equals(Boolean.class)) {
                        value = Boolean.valueOf(property);
                    } else if (Number.class.isAssignableFrom(type)) {
                        try {
                            value = Classes.valueOf(type, property);
                        }
                        catch (NumberFormatException e) {
                            GeoTools.unexpectedException(e);
                            continue;
                        }
                    }
                }
                try {
                    old = hints.put(hintKey, value);
                }
                catch (IllegalArgumentException e) {
                    GeoTools.unexpectedException(e);
                    continue;
                }
                if (changed || Utilities.equals(old, value)) continue;
                changed = true;
            }
        }
        return changed;
    }

    private static void unexpectedException(Exception exception) {
        Logging.unexpectedException(Hints.class, "scanSystemProperties", exception);
    }

    public static Hints getDefaultHints() {
        return Hints.getDefaults(false);
    }

    public static synchronized InitialContext getInitialContext(Hints hints) throws NamingException {
        if (context == null) {
            context = new InitialContext();
        }
        return context;
    }

    public static String fixName(String name) {
        return GeoTools.fixName(null, name, null);
    }

    public static String fixName(Context context, String name) {
        return context != null ? GeoTools.fixName(context, name, null) : name;
    }

    private static String fixName(Context context, String name, Hints hints) {
        String fixed = null;
        if (name != null) {
            StringTokenizer tokens = new StringTokenizer(name, ":/");
            while (tokens.hasMoreTokens()) {
                String part = tokens.nextToken();
                if (fixed == null) {
                    fixed = part;
                    continue;
                }
                try {
                    if (context == null) {
                        context = GeoTools.getInitialContext(hints);
                    }
                    fixed = context.composeName(fixed, part);
                }
                catch (NamingException e) {
                    Logging.unexpectedException(GeoTools.class, "fixName", e);
                    return name;
                }
            }
        }
        return fixed;
    }

    public static void addFactoryIteratorProvider(FactoryIteratorProvider provider) {
        FactoryIteratorProviders.addFactoryIteratorProvider(provider);
    }

    public static void removeFactoryIteratorProvider(FactoryIteratorProvider provider) {
        FactoryIteratorProviders.removeFactoryIteratorProvider(provider);
    }

    public static void addChangeListener(ChangeListener listener) {
        GeoTools.removeChangeListener(listener);
        LISTENERS.add(ChangeListener.class, listener);
    }

    public static void removeChangeListener(ChangeListener listener) {
        LISTENERS.remove(ChangeListener.class, listener);
    }

    public static void fireConfigurationChanged() {
        ChangeEvent event = new ChangeEvent(GeoTools.class);
        Object[] listeners = LISTENERS.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(event);
        }
    }

    public static void main(String[] args) {
        Arguments arguments = new Arguments(args);
        args = arguments.getRemainingArguments(0);
        arguments.out.print("GeoTools version ");
        arguments.out.println(GeoTools.getVersion());
        Hints hints = GeoTools.getDefaultHints();
        if (hints != null && !hints.isEmpty()) {
            arguments.out.println(hints);
        }
    }

    static {
        GeoTools.bind(CRS_AUTHORITY_EXTRA_DIRECTORY, Hints.CRS_AUTHORITY_EXTRA_DIRECTORY);
        GeoTools.bind(EPSG_DATA_SOURCE, Hints.EPSG_DATA_SOURCE);
        GeoTools.bind(FORCE_LONGITUDE_FIRST_AXIS_ORDER, Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER);
    }
}

