/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.console;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.geotools.console.Option;
import org.geotools.io.TableWriter;
import org.geotools.resources.Arguments;
import org.geotools.resources.Classes;
import org.geotools.resources.i18n.Errors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLine {
    private static final String OPTION_PREFIX = "--";
    public static final int ILLEGAL_ARGUMENT_EXIT_CODE = 1;
    public static final int ABORT_EXIT_CODE = 2;
    public static final int BAD_CONTENT_EXIT_CODE = 3;
    public static final int IO_EXCEPTION_EXIT_CODE = 100;
    public static final int SQL_EXCEPTION_EXIT_CODE = 101;
    protected final PrintWriter out;
    protected final PrintWriter err;
    protected final Locale locale;
    protected final String[] arguments;

    protected CommandLine(String[] args) {
        this(args, 0);
    }

    protected CommandLine(String[] args, int maximumRemaining) {
        Arguments arguments = new Arguments(args);
        this.out = arguments.out;
        this.err = arguments.err;
        this.locale = arguments.locale;
        if (arguments.getFlag("--help")) {
            this.help();
            System.exit(0);
        }
        this.setArgumentValues(this.getClass(), arguments);
        this.arguments = arguments.getRemainingArguments(maximumRemaining, OPTION_PREFIX.charAt(0));
    }

    private void setArgumentValues(Class<?> classe, Arguments arguments) throws UnsupportedOperationException {
        Class<?> parent = classe.getSuperclass();
        if (!CommandLine.class.equals(parent)) {
            this.setArgumentValues(parent, arguments);
        }
        for (Field field : classe.getDeclaredFields()) {
            Object value;
            Option option = field.getAnnotation(Option.class);
            if (option == null) continue;
            boolean mandatory = option.mandatory();
            Class<?> type = field.getType();
            String name = option.name().trim();
            if (name.length() == 0) {
                name = field.getName();
            }
            name = OPTION_PREFIX + name;
            if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.equals(type)) {
                value = mandatory ? Boolean.valueOf(arguments.getRequiredBoolean(name)) : Boolean.valueOf(arguments.getFlag(name));
            } else if (Integer.class.isAssignableFrom(type) || Integer.TYPE.equals(type)) {
                value = mandatory ? Integer.valueOf(arguments.getRequiredInteger(name)) : arguments.getOptionalInteger(name);
            } else if (Double.class.isAssignableFrom(type) || Double.TYPE.equals(type)) {
                value = mandatory ? Double.valueOf(arguments.getRequiredDouble(name)) : arguments.getOptionalDouble(name);
            } else if (String.class.isAssignableFrom(type)) {
                value = mandatory ? arguments.getRequiredString(name) : arguments.getOptionalString(name);
            } else {
                String text = mandatory ? arguments.getRequiredString(name) : arguments.getOptionalString(name);
                value = this.parse(type, text);
            }
            field.setAccessible(true);
            try {
                field.set(this, value);
            }
            catch (IllegalAccessException e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    protected <T> T parse(Class<T> type, String value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(Errors.format(135, type));
    }

    private void getArguments(Class<?> classe, Map<String, String> mandatory, Map<String, String> optional) {
        Class<?> parent = classe.getSuperclass();
        if (!CommandLine.class.equals(parent)) {
            this.getArguments(parent, mandatory, optional);
        }
        for (Field field : classe.getDeclaredFields()) {
            Class<?> type;
            String description;
            Option option = field.getAnnotation(Option.class);
            if (option == null || (description = option.description().trim()).length() == 0) continue;
            String name = option.name().trim();
            if (name.length() == 0) {
                name = field.getName();
            }
            if (Number.class.isAssignableFrom(type = Classes.primitiveToWrapper(field.getType()))) {
                name = name + "=N";
            } else if (!Boolean.class.isAssignableFrom(type)) {
                name = name + "=S";
            }
            if (option.mandatory()) {
                mandatory.put(name, description);
                continue;
            }
            optional.put(name, description);
        }
    }

    protected void help() {
        TreeMap<String, String> mandatory = new TreeMap<String, String>();
        TreeMap<String, String> optional = new TreeMap<String, String>();
        optional.put("help", "Print this summary.");
        optional.put("locale=S", "Set the locale for string, number and date formatting. Examples: \"fr\", \"fr_CA\".");
        optional.put("encoding=S", "Set the input and output encoding. Examples: \"UTF-8\", \"ISO-8859-1\".");
        this.getArguments(this.getClass(), mandatory, optional);
        if (!mandatory.isEmpty()) {
            this.out.println("Mandatory arguments:");
            this.print(mandatory);
        }
        this.out.println("Optional arguments:");
        this.print(optional);
    }

    private void print(Map<String, String> options) {
        TableWriter table = new TableWriter((Writer)this.out, "  ");
        for (Map.Entry<String, String> entry : options.entrySet()) {
            table.write("  ");
            table.write(OPTION_PREFIX);
            table.write(entry.getKey());
            table.nextColumn();
            table.write(entry.getValue());
            table.nextLine();
        }
        try {
            table.flush();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

