/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import org.geotools.resources.Classes;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class AbstractDirectPosition
implements DirectPosition {
    protected AbstractDirectPosition() {
    }

    @Deprecated
    public DirectPosition getPosition() {
        return this;
    }

    public DirectPosition getDirectPosition() {
        return this;
    }

    public void setPosition(DirectPosition position) {
        int dimension = this.getDimension();
        if (position != null) {
            AbstractDirectPosition.ensureDimensionMatch("position", position.getDimension(), dimension);
            for (int i = 0; i < dimension; ++i) {
                this.setOrdinate(i, position.getOrdinate(i));
            }
        } else {
            for (int i = 0; i < dimension; ++i) {
                this.setOrdinate(i, Double.NaN);
            }
        }
    }

    public double[] getCoordinate() {
        double[] ordinates = new double[this.getDimension()];
        for (int i = 0; i < ordinates.length; ++i) {
            ordinates[i] = this.getOrdinate(i);
        }
        return ordinates;
    }

    @Deprecated
    public double[] getCoordinates() {
        return this.getCoordinate();
    }

    static void checkCoordinateReferenceSystemDimension(CoordinateReferenceSystem crs, int expected) throws MismatchedDimensionException {
        int dimension;
        if (crs != null && (dimension = crs.getCoordinateSystem().getDimension()) != expected) {
            throw new MismatchedDimensionException(Errors.format((int)69, (Object)crs.getName().getCode(), (Object)dimension, (Object)expected));
        }
    }

    static void ensureDimensionMatch(String name, int dimension, int expectedDimension) throws MismatchedDimensionException {
        if (dimension != expectedDimension) {
            throw new MismatchedDimensionException(Errors.format((int)69, (Object)name, (Object)dimension, (Object)expectedDimension));
        }
    }

    public String toString() {
        return AbstractDirectPosition.toString(this);
    }

    static String toString(DirectPosition position) {
        StringBuilder buffer = new StringBuilder(Classes.getShortClassName((Object)position)).append('[');
        int dimension = position.getDimension();
        for (int i = 0; i < dimension; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(position.getOrdinate(i));
        }
        return buffer.append(']').toString();
    }

    public int hashCode() {
        return AbstractDirectPosition.hashCode(this);
    }

    static int hashCode(DirectPosition position) {
        int dimension = position.getDimension();
        int code = 1;
        for (int i = 0; i < dimension; ++i) {
            long bits = Double.doubleToLongBits(position.getOrdinate(i));
            code = 31 * code + ((int)bits ^ (int)(bits >>> 32));
        }
        CoordinateReferenceSystem crs = position.getCoordinateReferenceSystem();
        if (crs != null) {
            code += crs.hashCode();
        }
        return code;
    }

    public boolean equals(Object object) {
        if (object instanceof DirectPosition) {
            DirectPosition that = (DirectPosition)object;
            int dimension = this.getDimension();
            if (dimension == that.getDimension()) {
                for (int i = 0; i < dimension; ++i) {
                    if (Utilities.equals((double)this.getOrdinate(i), (double)that.getOrdinate(i))) continue;
                    return false;
                }
                if (Utilities.equals((Object)this.getCoordinateReferenceSystem(), (Object)that.getCoordinateReferenceSystem())) {
                    assert (this.hashCode() == that.hashCode()) : this;
                    return true;
                }
            }
        }
        return false;
    }
}

