/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage;

import java.awt.Color;
import java.io.Serializable;
import java.util.Arrays;
import org.geotools.coverage.GeophysicsCategory;
import org.geotools.referencing.operation.transform.LinearTransform1D;
import org.geotools.resources.Classes;
import org.geotools.resources.XMath;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.NumberRange;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.Utilities;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Category
implements Serializable {
    private static final long serialVersionUID = 6215962897884256696L;
    private static final NumberRange<Byte> BYTE_0;
    private static final NumberRange<Byte> BYTE_1;
    private static final Color TRANSPARENT;
    public static final Category NODATA;
    public static final Category FALSE;
    public static final Category TRUE;
    private final InternationalString name;
    final double minimum;
    final double maximum;
    NumberRange<? extends Number> range;
    final MathTransform1D transform;
    final Category inverse;
    private final int[] ARGB;
    private static final int[] DEFAULT;
    private static final Color[] CYCLE;

    public Category(CharSequence name, Color color, boolean sample) {
        this(name, Category.toArray(color), sample ? BYTE_0 : BYTE_1, (MathTransform1D)LinearTransform1D.IDENTITY);
    }

    public Category(CharSequence name, Color color, int sample) {
        this(name, Category.toARGB(color, sample), (Number)sample);
        assert (this.minimum == (double)sample) : this.minimum;
        assert (this.maximum == (double)sample) : this.maximum;
    }

    public Category(CharSequence name, Color color, double sample) {
        this(name, Category.toARGB(color, (int)sample), (Number)sample);
        assert (Double.doubleToRawLongBits(this.minimum) == Double.doubleToRawLongBits(sample)) : this.minimum;
        assert (Double.doubleToRawLongBits(this.maximum) == Double.doubleToRawLongBits(sample)) : this.maximum;
    }

    private Category(CharSequence name, int[] ARGB, Number sample) {
        this(name, ARGB, new NumberRange(sample.getClass(), sample, sample), null);
        assert (Double.isNaN(this.inverse.minimum)) : this.inverse.minimum;
        assert (Double.isNaN(this.inverse.maximum)) : this.inverse.maximum;
    }

    public Category(CharSequence name, Color color, NumberRange<?> sampleValueRange) throws IllegalArgumentException {
        this(name, Category.toArray(color), sampleValueRange, (MathTransform1D)null);
    }

    public Category(CharSequence name, Color[] colors, int lower, int upper, double scale, double offset) throws IllegalArgumentException {
        this(name, colors, NumberRange.create((int)lower, (boolean)true, (int)upper, (boolean)false), scale, offset);
    }

    public Category(CharSequence name, Color[] colors, NumberRange sampleValueRange, double scale, double offset) throws IllegalArgumentException {
        this(name, colors, sampleValueRange, Category.createLinearTransform(scale, offset));
        try {
            assert (Double.doubleToLongBits(this.transform.derivative(0.0)) == Double.doubleToLongBits(scale));
            assert (Double.doubleToLongBits(this.transform.transform(0.0)) == Double.doubleToLongBits(offset));
        }
        catch (TransformException exception) {
            throw new AssertionError((Object)exception);
        }
        if (Double.isNaN(scale) || Double.isInfinite(scale)) {
            throw new IllegalArgumentException(Errors.format((int)6, (Object)"scale", (Object)scale));
        }
        if (Double.isNaN(offset) || Double.isInfinite(offset)) {
            throw new IllegalArgumentException(Errors.format((int)6, (Object)"offset", (Object)offset));
        }
    }

    public Category(CharSequence name, Color[] colors, NumberRange sampleValueRange, NumberRange geophysicsValueRange) throws IllegalArgumentException {
        this(name, colors, sampleValueRange, Category.createLinearTransform(sampleValueRange, geophysicsValueRange));
        this.inverse.range = geophysicsValueRange;
        assert (this.range.equals((Object)sampleValueRange));
    }

    public Category(CharSequence name, Color[] colors, NumberRange sampleValueRange, MathTransform1D sampleToGeophysics) throws IllegalArgumentException {
        this(name, Category.toARGB(colors), sampleValueRange, sampleToGeophysics);
    }

    private Category(CharSequence name, int[] ARGB, NumberRange range, MathTransform1D sampleToGeophysics) throws IllegalArgumentException {
        Category.ensureNonNull("name", name);
        this.name = SimpleInternationalString.wrap((CharSequence)name);
        this.ARGB = ARGB;
        this.range = range;
        Class type = range.getElementClass();
        boolean minInc = range.isMinIncluded();
        boolean maxInc = range.isMaxIncluded();
        this.minimum = Category.doubleValue(type, range.getMinValue(), minInc ? 0 : 1);
        this.maximum = Category.doubleValue(type, range.getMaxValue(), maxInc ? 0 : -1);
        if (sampleToGeophysics == null && minInc && maxInc && Double.isNaN(this.minimum) && Double.doubleToRawLongBits(this.minimum) == Double.doubleToRawLongBits(this.maximum)) {
            this.inverse = this;
            this.transform = Category.createLinearTransform(0.0, this.minimum);
            return;
        }
        if (!(this.minimum <= this.maximum) || Double.isInfinite(this.minimum) || Double.isInfinite(this.maximum)) {
            throw new IllegalArgumentException(Errors.format((int)13, (Object)range.getMinValue(), (Object)range.getMaxValue()));
        }
        TransformException cause = null;
        try {
            if (sampleToGeophysics == null) {
                this.inverse = new GeophysicsCategory(this, false);
                this.transform = Category.createLinearTransform(0.0, this.inverse.minimum);
                return;
            }
            this.transform = sampleToGeophysics;
            this.inverse = sampleToGeophysics.isIdentity() ? this : new GeophysicsCategory(this, true);
            if (this.inverse.minimum <= this.inverse.maximum) {
                return;
            }
        }
        catch (TransformException exception) {
            cause = exception;
        }
        throw new IllegalArgumentException(Errors.format((int)15, (Object)Classes.getClass((Object)sampleToGeophysics)), cause);
    }

    Category(Category inverse, boolean isQuantitative) throws TransformException {
        double max;
        assert (this instanceof GeophysicsCategory);
        assert (!(inverse instanceof GeophysicsCategory));
        this.inverse = inverse;
        this.name = inverse.name;
        this.ARGB = inverse.ARGB;
        if (!isQuantitative) {
            this.minimum = this.maximum = (double)org.geotools.math.XMath.toNaN((int)((int)Math.round((inverse.minimum + inverse.maximum) / 2.0)));
            this.transform = Category.createLinearTransform(0.0, inverse.minimum);
            return;
        }
        this.transform = inverse.transform.inverse();
        double min = inverse.transform.transform(inverse.minimum);
        if (min > (max = inverse.transform.transform(inverse.maximum))) {
            this.minimum = max;
            this.maximum = min;
        } else {
            this.minimum = min;
            this.maximum = max;
        }
    }

    static MathTransform1D createLinearTransform(double scale, double offset) {
        return LinearTransform1D.create(scale, offset);
    }

    private static MathTransform1D createLinearTransform(NumberRange sampleValueRange, NumberRange geophysicsValueRange) {
        int swap;
        boolean adjustSamples;
        int gMaxInc;
        Class sType = sampleValueRange.getElementClass();
        Class gType = geophysicsValueRange.getElementClass();
        int sMinInc = sampleValueRange.isMinIncluded() ? 0 : 1;
        int sMaxInc = sampleValueRange.isMaxIncluded() ? 0 : -1;
        int gMinInc = geophysicsValueRange.isMinIncluded() ? 0 : 1;
        int n = gMaxInc = geophysicsValueRange.isMaxIncluded() ? 0 : -1;
        if (sMinInc == gMinInc) {
            gMinInc = 0;
            sMinInc = 0;
        }
        if (sMaxInc == gMaxInc) {
            gMaxInc = 0;
            sMaxInc = 0;
        }
        if (((adjustSamples = Classes.isInteger((Class)sType) && !Classes.isInteger((Class)gType)) ? gMinInc : sMinInc) != 0) {
            swap = sMinInc;
            sMinInc = -gMinInc;
            gMinInc = -swap;
        }
        if ((adjustSamples ? gMaxInc : sMaxInc) != 0) {
            swap = sMaxInc;
            sMaxInc = -gMaxInc;
            gMaxInc = -swap;
        }
        double minSample = Category.doubleValue(sType, sampleValueRange.getMinValue(), sMinInc);
        double maxSample = Category.doubleValue(sType, sampleValueRange.getMaxValue(), sMaxInc);
        double minValue = Category.doubleValue(gType, geophysicsValueRange.getMinValue(), gMinInc);
        double maxValue = Category.doubleValue(gType, geophysicsValueRange.getMaxValue(), gMaxInc);
        double scale = (maxValue - minValue) / (maxSample - minSample);
        if (Double.isNaN(scale) && !Double.isNaN(maxValue - minValue) && !Double.isNaN(maxSample - minSample)) {
            scale = 1.0;
        }
        double offset = minValue - scale * minSample;
        return Category.createLinearTransform(scale, offset);
    }

    private static double doubleValue(Class<?> type, Comparable number, int direction) {
        assert (direction >= -1 && direction <= 1) : direction;
        return XMath.rool(type, (double)((Number)((Object)number)).doubleValue(), (int)direction);
    }

    private static Color[] toArray(Color color) {
        Color[] colorArray;
        if (color != null) {
            Color[] colorArray2 = new Color[1];
            colorArray = colorArray2;
            colorArray2[0] = color;
        } else {
            colorArray = null;
        }
        return colorArray;
    }

    private static int[] toARGB(Color[] colors) {
        int[] ARGB;
        if (colors != null && colors.length != 0) {
            ARGB = new int[colors.length];
            for (int i = 0; i < ARGB.length; ++i) {
                Color color = colors[i];
                if (color == null) continue;
                ARGB[i] = color.getRGB();
            }
        } else {
            ARGB = DEFAULT;
        }
        return ARGB;
    }

    private static int[] toARGB(Color color, int sample) {
        if (color == null) {
            color = CYCLE[Math.abs(sample) % CYCLE.length];
        }
        return new int[]{color.getRGB()};
    }

    public InternationalString getName() {
        return this.name;
    }

    public Color[] getColors() {
        Color[] colors = new Color[this.ARGB.length];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = new Color(this.ARGB[i], true);
        }
        return colors;
    }

    public NumberRange<? extends Number> getRange() {
        assert (this.range != null);
        return this.range;
    }

    public MathTransform1D getSampleToGeophysics() {
        return this.isQuantitative() ? this.transform : null;
    }

    public boolean isQuantitative() {
        return !Double.isNaN(this.inverse.minimum) && !Double.isNaN(this.inverse.maximum);
    }

    public Category recolor(Color[] colors) {
        assert (!(this instanceof GeophysicsCategory)) : this;
        int[] newARGB = Category.toARGB(colors);
        if (Arrays.equals(this.ARGB, newARGB)) {
            return this;
        }
        assert (this.range != null) : this;
        Category newCategory = new Category((CharSequence)this.name, newARGB, this.range, this.getSampleToGeophysics());
        newCategory.inverse.range = this.inverse.range;
        return newCategory;
    }

    public Category rescale(MathTransform1D sampleToGeophysics) {
        if (Utilities.equals((Object)sampleToGeophysics, (Object)this.transform)) {
            return this;
        }
        return new Category((CharSequence)this.name, this.ARGB, this.range, sampleToGeophysics);
    }

    public Category geophysics(boolean geo) {
        return geo ? this.inverse : this;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            Category that = (Category)object;
            if (Double.doubleToRawLongBits(this.minimum) == Double.doubleToRawLongBits(that.minimum) && Double.doubleToRawLongBits(this.maximum) == Double.doubleToRawLongBits(that.maximum) && Utilities.equals((Object)this.transform, (Object)that.transform) && Utilities.equals((Object)this.name, (Object)that.name) && Arrays.equals(this.ARGB, that.ARGB)) {
                if (this.range != null && that.range != null) {
                    if (!Utilities.equals(this.range, that.range)) {
                        return false;
                    }
                    if (this.inverse instanceof GeophysicsCategory) assert (this.inverse.equals(that.inverse));
                    return true;
                }
                assert (this instanceof GeophysicsCategory);
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(Classes.getShortClassName((Object)this));
        buffer.append("(\"").append((CharSequence)this.name).append("\":[");
        if (Double.isNaN(this.minimum) && Double.isNaN(this.maximum)) {
            buffer.append("NaN(").append(Math.round(this.inverse.minimum)).append("...").append(Math.round(this.inverse.maximum)).append(')');
        } else if (Classes.isInteger((Class)this.getRange().getElementClass())) {
            buffer.append(Math.round(this.minimum)).append("...").append(Math.round(this.maximum));
        } else {
            buffer.append(this.minimum).append(" ... ").append(this.maximum);
        }
        return buffer.append("])").toString();
    }

    static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(Errors.format((int)105, (Object)name));
        }
    }

    static {
        Byte index = 0;
        BYTE_0 = NumberRange.create((byte)index, (byte)index);
        index = 1;
        BYTE_1 = NumberRange.create((byte)index, (byte)index);
        TRANSPARENT = new Color(0, 0, 0, 0);
        NODATA = new Category((CharSequence)Vocabulary.formatInternational((int)110), TRANSPARENT, 0);
        FALSE = new Category((CharSequence)Vocabulary.formatInternational((int)46), Color.BLACK, false);
        TRUE = new Category((CharSequence)Vocabulary.formatInternational((int)173), Color.WHITE, true);
        DEFAULT = new int[]{-16777216, -1};
        CYCLE = new Color[]{Color.BLUE, Color.RED, Color.ORANGE, Color.YELLOW, Color.PINK, Color.MAGENTA, Color.GREEN, Color.CYAN, Color.LIGHT_GRAY, Color.GRAY};
    }
}

