/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.utilities;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;

public final class Utilities {
    private static final String[] spacesFactory = new String[20];

    private Utilities() {
    }

    public static boolean equals(Object object1, Object object2) {
        return object1 == object2 || object1 != null && object1.equals(object2);
    }

    public static boolean sameInterfaces(Class object1, Class object2, Class base) {
        Class<?> c;
        int i;
        if (object1 == object2) {
            return true;
        }
        if (object1 == null || object2 == null) {
            return false;
        }
        Class<?>[] c1 = object1.getInterfaces();
        Class<?>[] c2 = object2.getInterfaces();
        int n = 0;
        for (i = 0; i < c2.length; ++i) {
            c = c2[i];
            if (!base.isAssignableFrom(c)) continue;
            c2[n++] = c;
        }
        block1: for (i = 0; i < c1.length; ++i) {
            c = c1[i];
            if (!base.isAssignableFrom(c)) continue;
            for (int j = 0; j < n; ++j) {
                if (!c.equals(c2[j])) continue;
                System.arraycopy(c2, j + 1, c2, j, --n - j);
                continue block1;
            }
            return false;
        }
        return n == 0;
    }

    public static String spaces(int length) {
        int last = spacesFactory.length - 1;
        if (length < 0) {
            length = 0;
        }
        if (length <= last) {
            if (spacesFactory[length] == null) {
                if (spacesFactory[last] == null) {
                    char[] blancs = new char[last];
                    Arrays.fill(blancs, ' ');
                    Utilities.spacesFactory[last] = new String(blancs).intern();
                }
                Utilities.spacesFactory[length] = spacesFactory[last].substring(0, length).intern();
            }
            return spacesFactory[length];
        }
        char[] blancs = new char[length];
        Arrays.fill(blancs, ' ');
        return new String(blancs);
    }

    public static String getShortName(Class classe) {
        Class<?> el;
        if (classe == null) {
            return "<*>";
        }
        int dimension = 0;
        while ((el = classe.getComponentType()) != null) {
            classe = el;
            ++dimension;
        }
        String name = classe.getName();
        int lower = name.lastIndexOf(46);
        int upper = name.length();
        name = name.substring(lower + 1, upper).replace('$', '.');
        if (dimension != 0) {
            StringBuffer buffer = new StringBuffer(name);
            do {
                buffer.append("[]");
            } while (--dimension != 0);
            name = buffer.toString();
        }
        return name;
    }

    public static File urlToFile(URL url) {
        String path3;
        String string = url.toExternalForm();
        try {
            string = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        String simplePrefix = "file:/";
        String standardPrefix = simplePrefix + "/";
        if (string.startsWith(standardPrefix)) {
            path3 = string.substring(standardPrefix.length());
        } else if (string.startsWith(simplePrefix)) {
            path3 = string.substring(simplePrefix.length() - 1);
        } else {
            String auth = url.getAuthority();
            String path2 = url.getPath().replace("%20", " ");
            path3 = auth != null && !auth.equals("") ? "//" + auth + path2 : path2;
        }
        return new File(path3);
    }

    public static String getShortClassName(Object object) {
        return Utilities.getShortName(object != null ? object.getClass() : null);
    }

    public static String adjustAttributeName(String attributeName) {
        if (attributeName.contains("\\")) {
            return attributeName.replace("\\", "_");
        }
        return attributeName;
    }
}

