/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.ChannelSelectionImpl;
import org.geotools.styling.ColorMapImpl;
import org.geotools.styling.ContrastEnhancementImpl;
import org.geotools.styling.Description;
import org.geotools.styling.DescriptionImpl;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.ShadedReliefImpl;
import org.geotools.styling.StyleFactoryImpl2;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbolizer;
import org.geotools.util.Utilities;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.style.ColorMap;
import org.opengis.style.ContrastEnhancement;
import org.opengis.style.OverlapBehavior;
import org.opengis.style.ShadedRelief;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RasterSymbolizerImpl
implements RasterSymbolizer {
    private DescriptionImpl description;
    private String name;
    private Unit<Length> uom;
    private OverlapBehavior behavior;
    private FilterFactory filterFactory;
    private ChannelSelection channelSelection = new ChannelSelectionImpl();
    private ColorMapImpl colorMap = new ColorMapImpl();
    private ContrastEnhancementImpl contrastEnhancement = new ContrastEnhancementImpl();
    private ShadedReliefImpl shadedRelief = new ShadedReliefImpl();
    private String geometryName = "raster";
    private Symbolizer symbolizer;
    private Expression opacity;
    private Expression overlap;

    public RasterSymbolizerImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    public RasterSymbolizerImpl(FilterFactory factory) {
        this(factory, null, null, null, null);
    }

    public RasterSymbolizerImpl(FilterFactory factory, Description desc, String name, Unit<Length> uom, OverlapBehavior behavior) {
        this.filterFactory = factory;
        this.opacity = this.filterFactory.literal(1.0);
        this.overlap = this.filterFactory.literal((Object)OverlapBehavior.RANDOM);
        this.description = DescriptionImpl.cast(desc);
        this.name = name;
        this.uom = uom;
        this.behavior = behavior;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public DescriptionImpl getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(org.opengis.style.Description description) {
        this.description = DescriptionImpl.cast(description);
    }

    public Unit<Length> getUnitOfMeasure() {
        return this.uom;
    }

    @Override
    public void setUnitOfMeasure(Unit<Length> uom) {
        this.uom = uom;
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.geometryName != null) {
            result = 1000003 * result + this.geometryName.hashCode();
        }
        if (this.channelSelection != null) {
            result = 1000003 * result + this.channelSelection.hashCode();
        }
        if (this.colorMap != null) {
            result = 1000003 * result + this.colorMap.hashCode();
        }
        if (this.contrastEnhancement != null) {
            result = 1000003 * result + this.contrastEnhancement.hashCode();
        }
        if (this.shadedRelief != null) {
            result = 1000003 * result + this.shadedRelief.hashCode();
        }
        if (this.opacity != null) {
            result = 1000003 * result + this.opacity.hashCode();
        }
        if (this.overlap != null) {
            result = 1000003 * result + this.overlap.hashCode();
        }
        if (this.description != null) {
            result = 1000003 * result + this.description.hashCode();
        }
        if (this.uom != null) {
            result = 1000003 * result + this.uom.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RasterSymbolizerImpl) {
            RasterSymbolizerImpl other = (RasterSymbolizerImpl)obj;
            return Utilities.equals((Object)this.geometryName, (Object)other.geometryName) && Utilities.equals((Object)this.channelSelection, (Object)other.channelSelection) && Utilities.equals((Object)this.colorMap, (Object)other.colorMap) && Utilities.equals((Object)this.contrastEnhancement, (Object)other.contrastEnhancement) && Utilities.equals((Object)this.shadedRelief, (Object)other.shadedRelief) && Utilities.equals((Object)this.opacity, (Object)other.opacity) && Utilities.equals((Object)this.overlap, (Object)other.overlap) && Utilities.equals((Object)this.description, (Object)other.description) && Utilities.equals(this.uom, other.uom);
        }
        return false;
    }

    @Override
    public ChannelSelection getChannelSelection() {
        return this.channelSelection;
    }

    @Override
    public ColorMapImpl getColorMap() {
        return this.colorMap;
    }

    @Override
    public ContrastEnhancementImpl getContrastEnhancement() {
        return this.contrastEnhancement;
    }

    public String getGeometryPropertyName() {
        return this.geometryName;
    }

    @Override
    public Symbolizer getImageOutline() {
        return this.symbolizer;
    }

    public Expression getOpacity() {
        return this.opacity;
    }

    @Override
    @Deprecated
    public Expression getOverlap() {
        return this.overlap;
    }

    public OverlapBehavior getOverlapBehavior() {
        return this.behavior;
    }

    @Override
    public void setOverlapBehavior(OverlapBehavior overlapBehavior) {
        this.behavior = overlapBehavior;
    }

    @Override
    public ShadedReliefImpl getShadedRelief() {
        return this.shadedRelief;
    }

    @Override
    public void setChannelSelection(org.opengis.style.ChannelSelection channel) {
        if (this.channelSelection == channel) {
            return;
        }
        this.channelSelection = ChannelSelectionImpl.cast(channel);
    }

    @Override
    public void setColorMap(ColorMap colorMap) {
        if (this.colorMap == colorMap) {
            return;
        }
        this.colorMap = ColorMapImpl.cast(colorMap);
    }

    @Override
    public void setContrastEnhancement(ContrastEnhancement contrastEnhancement) {
        if (this.contrastEnhancement == contrastEnhancement) {
            return;
        }
        this.contrastEnhancement = ContrastEnhancementImpl.cast(contrastEnhancement);
    }

    @Override
    public void setGeometryPropertyName(String geometryName) {
        if (this.geometryName == geometryName) {
            return;
        }
        this.geometryName = geometryName;
    }

    @Override
    public void setImageOutline(org.opengis.style.Symbolizer symbolizer) {
        if (symbolizer == null) {
            this.symbolizer = null;
        } else if (symbolizer instanceof LineSymbolizer || symbolizer instanceof PolygonSymbolizer) {
            if (this.symbolizer == symbolizer) {
                return;
            }
            this.symbolizer = StyleFactoryImpl2.cast(symbolizer);
        } else {
            throw new IllegalArgumentException("Only a line or polygon symbolizer may be used to outline a raster");
        }
    }

    @Override
    public void setOpacity(Expression opacity) {
        if (this.opacity == opacity) {
            return;
        }
        this.opacity = opacity;
    }

    @Override
    @Deprecated
    public void setOverlap(Expression overlap) {
        if (this.overlap == overlap) {
            return;
        }
        this.overlap = overlap;
    }

    @Override
    public void setShadedRelief(ShadedRelief shadedRelief) {
        if (this.shadedRelief == shadedRelief) {
            return;
        }
        this.shadedRelief = ShadedReliefImpl.cast(shadedRelief);
    }

    public Object accept(org.opengis.style.StyleVisitor visitor, Object data) {
        return visitor.visit((org.opengis.style.RasterSymbolizer)this, data);
    }

    @Override
    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        Object clone;
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return clone;
    }

    static RasterSymbolizerImpl cast(org.opengis.style.Symbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        if (symbolizer instanceof RasterSymbolizerImpl) {
            return (RasterSymbolizerImpl)symbolizer;
        }
        if (symbolizer instanceof org.opengis.style.RasterSymbolizer) {
            org.opengis.style.RasterSymbolizer rasterSymbolizer = (org.opengis.style.RasterSymbolizer)symbolizer;
            RasterSymbolizerImpl copy = new RasterSymbolizerImpl();
            copy.setChannelSelection(rasterSymbolizer.getChannelSelection());
            copy.setColorMap(rasterSymbolizer.getColorMap());
            copy.setContrastEnhancement(rasterSymbolizer.getContrastEnhancement());
            copy.setDescription(rasterSymbolizer.getDescription());
            copy.setGeometryPropertyName(rasterSymbolizer.getGeometryPropertyName());
            copy.setImageOutline(rasterSymbolizer.getImageOutline());
            copy.setName(rasterSymbolizer.getName());
            copy.setOpacity(rasterSymbolizer.getOpacity());
            copy.setOverlapBehavior(rasterSymbolizer.getOverlapBehavior());
            copy.setShadedRelief(rasterSymbolizer.getShadedRelief());
            copy.setUnitOfMeasure((Unit<Length>)rasterSymbolizer.getUnitOfMeasure());
            return copy;
        }
        return null;
    }
}

