/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import org.geotools.styling.Description;
import org.geotools.styling.DescriptionImpl;
import org.geotools.styling.Displacement;
import org.geotools.styling.DisplacementImpl;
import org.geotools.styling.Fill;
import org.geotools.styling.FillImpl;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Stroke;
import org.geotools.styling.StrokeImpl;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.Utilities;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Symbolizer;
import org.opengis.util.Cloneable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolygonSymbolizerImpl
implements PolygonSymbolizer,
Cloneable {
    private DescriptionImpl description;
    private String name;
    private Expression offset;
    private Unit<Length> uom;
    private DisplacementImpl disp;
    private Fill fill = new FillImpl();
    private StrokeImpl stroke = new StrokeImpl();
    private String geometryName = null;

    protected PolygonSymbolizerImpl() {
        this(null, null, null, null, null, null, null, null);
    }

    protected PolygonSymbolizerImpl(Stroke stroke, Fill fill, Displacement disp, Expression offset, Unit<Length> uom, String geom, String name, Description desc) {
        this.stroke = StrokeImpl.cast(stroke);
        this.fill = fill;
        this.disp = DisplacementImpl.cast(disp);
        this.offset = offset;
        this.uom = uom;
        this.geometryName = geom;
        this.name = name;
        this.description = DescriptionImpl.cast(desc);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Description getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(org.opengis.style.Description description) {
        this.description = DescriptionImpl.cast(description);
    }

    public String getGeometryPropertyName() {
        return this.geometryName;
    }

    @Override
    public void setGeometryPropertyName(String name) {
        this.geometryName = name;
    }

    public Unit<Length> getUnitOfMeasure() {
        return this.uom;
    }

    @Override
    public void setUnitOfMeasure(Unit<Length> uom) {
        this.uom = uom;
    }

    public Expression getPerpendicularOffset() {
        return this.offset;
    }

    @Override
    public void setPerpendicularOffset(Expression offset) {
        this.offset = offset;
    }

    @Override
    public Displacement getDisplacement() {
        return this.disp;
    }

    @Override
    public void setDisplacement(org.opengis.style.Displacement displacement) {
        this.disp = DisplacementImpl.cast(displacement);
    }

    @Override
    public Fill getFill() {
        return this.fill;
    }

    @Override
    public void setFill(org.opengis.style.Fill fill) {
        if (this.fill == fill) {
            return;
        }
        this.fill = FillImpl.cast(fill);
    }

    @Override
    public StrokeImpl getStroke() {
        return this.stroke;
    }

    @Override
    public void setStroke(org.opengis.style.Stroke stroke) {
        if (this.stroke == stroke) {
            return;
        }
        this.stroke = StrokeImpl.cast(stroke);
    }

    public Object accept(org.opengis.style.StyleVisitor visitor, Object data) {
        return visitor.visit((org.opengis.style.PolygonSymbolizer)this, data);
    }

    @Override
    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        PolygonSymbolizerImpl clone;
        try {
            clone = (PolygonSymbolizerImpl)super.clone();
            if (this.fill != null) {
                clone.fill = (Fill)((Cloneable)this.fill).clone();
            }
            if (this.stroke != null) {
                clone.stroke = (StrokeImpl)this.stroke.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return clone;
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.fill != null) {
            result = 1000003 * result + this.fill.hashCode();
        }
        if (this.stroke != null) {
            result = 1000003 * result + this.stroke.hashCode();
        }
        if (this.geometryName != null) {
            result = 1000003 * result + this.geometryName.hashCode();
        }
        if (this.description != null) {
            result = 1000003 * result + this.description.hashCode();
        }
        if (this.uom != null) {
            result = 1000003 * result + this.uom.hashCode();
        }
        if (this.offset != null) {
            result = 1000003 * result + this.offset.hashCode();
        }
        if (this.disp != null) {
            result = 1000003 * result + this.disp.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof PolygonSymbolizerImpl) {
            PolygonSymbolizerImpl other = (PolygonSymbolizerImpl)oth;
            return Utilities.equals((Object)this.geometryName, (Object)other.geometryName) && Utilities.equals((Object)this.fill, (Object)other.fill) && Utilities.equals((Object)this.stroke, (Object)other.stroke) && Utilities.equals((Object)this.description, (Object)other.description) && Utilities.equals((Object)this.disp, (Object)other.disp) && Utilities.equals((Object)this.offset, (Object)other.offset) && Utilities.equals(this.uom, other.uom);
        }
        return false;
    }

    static PolygonSymbolizerImpl cast(Symbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        if (symbolizer instanceof PolygonSymbolizerImpl) {
            return (PolygonSymbolizerImpl)symbolizer;
        }
        if (symbolizer instanceof org.opengis.style.PolygonSymbolizer) {
            org.opengis.style.PolygonSymbolizer polygonSymbolizer = (org.opengis.style.PolygonSymbolizer)symbolizer;
            PolygonSymbolizerImpl copy = new PolygonSymbolizerImpl();
            copy.setStroke(StrokeImpl.cast(polygonSymbolizer.getStroke()));
            copy.setDescription(polygonSymbolizer.getDescription());
            copy.setDisplacement(polygonSymbolizer.getDisplacement());
            copy.setFill(polygonSymbolizer.getFill());
            copy.setGeometryPropertyName(polygonSymbolizer.getGeometryPropertyName());
            copy.setName(polygonSymbolizer.getName());
            copy.setPerpendicularOffset(polygonSymbolizer.getPerpendicularOffset());
            copy.setUnitOfMeasure((Unit<Length>)polygonSymbolizer.getUnitOfMeasure());
            return copy;
        }
        return null;
    }
}

