/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing;

import java.awt.Color;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.measure.converter.ConversionException;
import javax.measure.unit.Unit;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.processing.AbstractProcessor;
import org.geotools.io.TableWriter;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.resources.image.ColorUtilities;
import org.geotools.util.MeasurementRange;
import org.geotools.util.NumberRange;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorMap
implements Serializable {
    private static final long serialVersionUID = 1688030908496323012L;
    public static final CharSequence ANY_QUANTITATIVE_CATEGORY = Vocabulary.formatInternational((int)4);
    private Map<String, Object> colorMap;
    private Map<String, NumberRange> colorRanges;
    private boolean resetUnspecifiedColors;

    public ColorMap() {
    }

    public ColorMap(Color[] colors) {
        this.setColors(ANY_QUANTITATIVE_CATEGORY, colors);
    }

    public ColorMap(Map<? extends CharSequence, Color[]> colorMap) {
        for (Map.Entry<? extends CharSequence, Color[]> entry : colorMap.entrySet()) {
            this.setColors(entry.getKey(), entry.getValue());
        }
    }

    private static String unlocalized(CharSequence name) {
        if (name == ANY_QUANTITATIVE_CATEGORY) {
            return null;
        }
        if (name instanceof InternationalString) {
            return ((InternationalString)name).toString(null);
        }
        return ((Object)name).toString();
    }

    private void setColorObject(CharSequence category, Object colors) {
        String name = ColorMap.unlocalized(category);
        if (colors != null) {
            if (this.colorMap == null) {
                this.colorMap = new HashMap<String, Object>();
            }
            this.colorMap.put(name, colors);
        } else if (this.colorMap != null) {
            this.colorMap.remove(name);
            if (this.colorMap.isEmpty()) {
                this.colorMap = null;
            }
        }
    }

    public void setColor(CharSequence category, Color color) {
        this.setColorObject(category, color);
    }

    public void setColors(CharSequence category, Color[] colors) {
        Object value;
        if (colors != null) {
            switch (colors.length) {
                default: {
                    value = colors.clone();
                    break;
                }
                case 1: {
                    value = colors[0];
                    break;
                }
                case 0: {
                    value = null;
                    break;
                }
            }
        } else {
            value = null;
        }
        this.setColorObject(category, value);
    }

    public Color[] getColors(CharSequence category) {
        if (this.colorMap == null) {
            return null;
        }
        String name = ColorMap.unlocalized(category);
        Color[] colors = this.colorMap.get(name);
        if (colors == null) {
            if (name != null && category instanceof InternationalString) {
                colors = this.getColors(((Object)category).toString());
                if (colors == null) {
                    return null;
                }
            } else {
                return null;
            }
        }
        if (colors instanceof Color) {
            return new Color[]{(Color)colors};
        }
        return (Color[])((Color[])colors).clone();
    }

    public void setGeophysicsRange(CharSequence category, MeasurementRange<?> range) {
        this.setRange(category, (NumberRange)range);
    }

    public void setRelativeRange(CharSequence category, NumberRange<?> range) {
        if (range instanceof MeasurementRange) {
            throw new IllegalArgumentException(Errors.format((int)167, (Object)"range"));
        }
        this.setRange(category, range);
    }

    private void setRange(CharSequence category, NumberRange range) {
        String name = ColorMap.unlocalized(category);
        if (range != null) {
            if (this.colorRanges == null) {
                this.colorRanges = new HashMap<String, NumberRange>();
            }
            this.colorRanges.put(name, range);
        } else if (this.colorRanges != null) {
            this.colorRanges.remove(name);
            if (this.colorRanges.isEmpty()) {
                this.colorRanges = null;
            }
        }
    }

    public MeasurementRange<?> getGeophysicsRange(CharSequence category) {
        NumberRange range = this.getRange(category);
        return range instanceof MeasurementRange ? (MeasurementRange)range : null;
    }

    public NumberRange getRelativeRange(CharSequence category) {
        NumberRange range = this.getRange(category);
        return range instanceof MeasurementRange ? null : range;
    }

    private NumberRange getRange(CharSequence category) {
        if (this.colorRanges == null) {
            return null;
        }
        String name = ColorMap.unlocalized(category);
        NumberRange range = this.colorRanges.get(name);
        if (range == null && name != null && category instanceof InternationalString) {
            range = this.colorRanges.get(((Object)category).toString());
        }
        return range;
    }

    private NumberRange getTargetRange(Category category, Unit<?> units) {
        int upper;
        int lower;
        NumberRange scale = this.getRange((CharSequence)category.getName());
        if (scale == null) {
            if (category.isQuantitative()) {
                scale = this.getRange(ANY_QUANTITATIVE_CATEGORY);
            }
            if (scale == null) {
                return null;
            }
        }
        double minimum = scale.getMinimum();
        double maximum = scale.getMaximum();
        boolean minIncluded = scale.isMinIncluded();
        boolean maxIncluded = scale.isMaxIncluded();
        if (scale instanceof MeasurementRange) {
            try {
                scale = ((MeasurementRange)scale).convertTo(units);
            }
            catch (ConversionException e) {
                Logging.unexpectedException((Logger)AbstractProcessor.LOGGER, ColorMap.class, (String)"recolor", (Throwable)e);
                return null;
            }
            MathTransform1D tr = category.getSampleToGeophysics();
            if (tr != null) {
                try {
                    tr = tr.inverse();
                    minimum = tr.transform(minimum);
                    maximum = tr.transform(maximum);
                }
                catch (TransformException e) {
                    Logging.unexpectedException((Logger)AbstractProcessor.LOGGER, ColorMap.class, (String)"recolor", (Throwable)e);
                    return null;
                }
            }
        } else {
            NumberRange<? extends Number> range = category.getRange();
            double lower2 = range.getMinimum();
            double extent = range.getMaximum() - lower2;
            minimum = minimum / 100.0 * extent + lower2;
            maximum = maximum / 100.0 * extent + lower2;
            minIncluded &= range.isMinIncluded();
            maxIncluded &= range.isMaxIncluded();
        }
        if (minimum > maximum) {
            lower = ColorMap.round(maximum, maxIncluded);
            upper = ColorMap.round(minimum, !minIncluded);
        } else {
            lower = ColorMap.round(minimum, minIncluded);
            upper = ColorMap.round(maximum, !maxIncluded);
        }
        return NumberRange.create((int)lower, (boolean)true, (int)upper, (boolean)false);
    }

    private static int round(double value, boolean included) {
        double rounded = included ? Math.floor(value) : Math.ceil(value);
        int asInteger = (int)rounded;
        if (!included && value == rounded) {
            ++asInteger;
        }
        return asInteger;
    }

    public void setResetUnspecifiedColors(boolean reset) {
        this.resetUnspecifiedColors = reset;
    }

    public boolean getResetUnspecifiedColors() {
        return this.resetUnspecifiedColors;
    }

    public GridSampleDimension recolor(GridSampleDimension sampleDimension, int[] ARGB) {
        GridSampleDimension displayDimension = sampleDimension.geophysics(false);
        boolean changed = false;
        Category[] categories = (Category[])displayDimension.getCategories().toArray();
        for (int i = 0; i < categories.length; ++i) {
            Category category = categories[i];
            Color[] colors = this.getColors((CharSequence)category.getName());
            if (colors == null) {
                if (category.isQuantitative()) {
                    colors = this.getColors(ANY_QUANTITATIVE_CATEGORY);
                }
                if (colors == null && this.resetUnspecifiedColors) {
                    colors = category.getColors();
                }
            }
            if (ARGB != null) {
                NumberRange<? extends Number> range = category.getRange();
                int lower = ((Number)((Object)range.getMinValue())).intValue();
                int upper = ((Number)((Object)range.getMaxValue())).intValue();
                if (!range.isMinIncluded()) {
                    ++lower;
                }
                if (range.isMaxIncluded()) {
                    ++upper;
                }
                boolean outOfBounds = false;
                if (lower < 0) {
                    lower = 0;
                    outOfBounds = true;
                }
                if (upper > ARGB.length) {
                    upper = ARGB.length;
                    outOfBounds = true;
                }
                if (outOfBounds) {
                    AbstractProcessor.LOGGER.warning(Errors.format((int)145, (Object)category, (Object)0, (Object)(ARGB.length - 1)));
                }
                if (upper <= lower) continue;
                NumberRange target = this.getTargetRange(category, sampleDimension.getUnits());
                if (target != null) {
                    if (colors == null) {
                        colors = category.getColors();
                    }
                    if (colors.length >= 2) {
                        assert (target.isMinIncluded() && !target.isMaxIncluded()) : target;
                        int lo = Math.max(lower, ((Number)((Object)target.getMinValue())).intValue());
                        int hi = Math.min(upper, ((Number)((Object)target.getMaxValue())).intValue());
                        if (lo != lower || hi != upper) {
                            Arrays.fill(ARGB, lower, lo, colors[0].getRGB());
                            Arrays.fill(ARGB, hi, upper, colors[colors.length - 1].getRGB());
                            lower = lo;
                            upper = hi;
                        }
                    }
                } else if (colors == null) continue;
                ColorUtilities.expand(colors, ARGB, lower, upper);
            } else if (colors == null) continue;
            category = category.recolor(colors);
            if (categories[i].equals(category)) continue;
            categories[i] = category;
            changed = true;
        }
        if (!changed) {
            return sampleDimension;
        }
        GridSampleDimension result = new GridSampleDimension((CharSequence)displayDimension.getDescription(), categories, displayDimension.getUnits());
        if (sampleDimension != displayDimension) {
            result = result.geophysics(true);
        }
        return result;
    }

    private CharSequence[] getCategoryNames() {
        Set<Object> names;
        if (this.colorMap != null) {
            if (this.colorRanges != null) {
                names = new HashSet<String>(this.colorMap.keySet());
                names.addAll(this.colorRanges.keySet());
            } else {
                names = this.colorMap.keySet();
            }
        } else {
            names = this.colorRanges != null ? this.colorRanges.keySet() : Collections.emptySet();
        }
        int count = names.size();
        Object[] asArray = names.toArray(new CharSequence[count]);
        int i = count;
        while (--i >= 0) {
            if (asArray[i] != null) continue;
            System.arraycopy(asArray, i + 1, asArray, i, --count - i);
            asArray[count] = ANY_QUANTITATIVE_CATEGORY;
        }
        Arrays.sort(asArray, 0, count);
        return asArray;
    }

    public int hashCode() {
        return 0xEECDA1C4 ^ (this.colorMap != null ? ((Object)this.colorMap).hashCode() : 31) + 37 * (this.colorRanges != null ? ((Object)this.colorRanges).hashCode() : 31);
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass().equals(object.getClass())) {
            ColorMap that = (ColorMap)object;
            return Utilities.equals(this.colorMap, that.colorMap) && Utilities.equals(this.colorRanges, that.colorRanges);
        }
        return false;
    }

    public String toString() {
        CharSequence[] names = this.getCategoryNames();
        TableWriter writer = new TableWriter(null, 1);
        for (int i = 0; i < names.length; ++i) {
            NumberRange range;
            CharSequence name = names[i];
            writer.write(((Object)name).toString());
            if (this.colorRanges != null && (range = this.getRange(name)) != null) {
                writer.write(32);
                writer.write(range.toString());
                if (!(range instanceof MeasurementRange)) {
                    writer.write(37);
                }
            }
            writer.nextColumn();
            writer.write(58);
            writer.nextColumn();
            Color[] colors = this.getColors(name);
            if (colors != null) {
                String message = colors.length == 1 ? Integer.toHexString(colors[0].getRGB()).toUpperCase() : Vocabulary.format((int)16, (Object)colors.length);
                writer.write(message);
            }
            writer.nextLine();
        }
        return writer.toString();
    }
}

