/*
 * Decompiled with CFR 0.152.
 */
package buildings_tools;

import buildings_tools.ToolSettings;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.TagEditorPanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class AdvancedSettingsDialog
extends ExtendedDialog {
    private TagEditorModel tagsModel = new TagEditorModel();
    private JCheckBox cBigMode = new JCheckBox(I18n.tr((String)"Big buildings mode"));
    private JCheckBox cSoftCur = new JCheckBox(I18n.tr((String)"Rotate crosshair"));

    public AdvancedSettingsDialog() {
        super(Main.parent, I18n.tr((String)"Advanced settings"), new String[]{I18n.tr((String)"OK"), I18n.tr((String)"Cancel")}, true);
        this.contentInsets = new Insets(15, 15, 5, 15);
        this.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(I18n.tr((String)"Buildings tags:")), GBC.eol().fill(2));
        for (Map.Entry<String, String> entry : ToolSettings.getTags().entrySet()) {
            this.tagsModel.add(entry.getKey(), entry.getValue());
        }
        panel.add((Component)new TagEditorPanel(this.tagsModel, null), GBC.eop().fill(1));
        panel.add((Component)this.cBigMode, GBC.eol().fill(2));
        panel.add((Component)this.cSoftCur, GBC.eol().fill(2));
        this.cBigMode.setSelected(ToolSettings.isBBMode());
        this.cSoftCur.setSelected(ToolSettings.isSoftCursor());
        this.setContent(panel);
        this.setupDialog();
        this.setVisible(true);
    }

    public boolean isBBMode() {
        return this.cBigMode.isSelected();
    }

    public boolean isSoftCursor() {
        return this.cSoftCur.isSelected();
    }

    public void saveSettings() {
        this.tagsModel.applyToTags(ToolSettings.getTags());
        ToolSettings.setBBMode(this.isBBMode());
        ToolSettings.setSoftCursor(this.isSoftCursor());
    }
}

