/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.wayselector;

import java.util.Collection;
import java.util.LinkedList;
import java.util.TreeSet;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaySelection {
    TreeSet<Node> outerNodes;
    TreeSet<Node> nodes;

    public WaySelection(Collection<Way> ways) {
        if (ways.isEmpty()) {
            this.outerNodes = null;
            this.nodes = null;
        } else {
            this.nodes = new TreeSet();
            this.outerNodes = new TreeSet();
            for (Way way : ways) {
                this.addNodes(way);
            }
        }
    }

    private void addNodes(Node node) {
        if (node != null) {
            if (!this.nodes.add(node)) {
                this.outerNodes.remove(node);
            } else {
                this.outerNodes.add(node);
            }
        }
    }

    private void addNodes(Way way) {
        this.addNodes(way.firstNode());
        this.addNodes(way.lastNode());
    }

    public boolean canExtend() {
        return this.outerNodes != null && !this.outerNodes.isEmpty();
    }

    private Way findWay(Collection<OsmPrimitive> selection, Node node) {
        TreeSet<Way> foundWays = new TreeSet<Way>();
        for (Way way : OsmPrimitive.getFilteredList((Collection)node.getReferrers(), Way.class)) {
            if (way.getNodesCount() < 2 || selection.contains(way) || !way.isFirstLastNode(node)) continue;
            foundWays.add(way);
        }
        return foundWays.size() == 1 ? (Way)foundWays.first() : null;
    }

    private Way findWay(Collection<OsmPrimitive> selection) {
        for (Node node : this.outerNodes) {
            Way way = this.findWay(selection, node);
            if (way == null) continue;
            return way;
        }
        return null;
    }

    void extend(DataSet data) {
        boolean selectionChanged = false;
        if (!this.canExtend()) {
            return;
        }
        Collection currentSelection = data.getSelected();
        Way way = this.findWay(currentSelection);
        if (way == null) {
            return;
        }
        LinkedList<OsmPrimitive> selection = new LinkedList<OsmPrimitive>();
        for (OsmPrimitive primitive : currentSelection) {
            selection.add(primitive);
        }
        while (selection.add((OsmPrimitive)way)) {
            selectionChanged = true;
            this.addNodes(way);
            way = this.findWay(selection);
            if (way != null) continue;
        }
        if (selectionChanged) {
            data.setSelected(selection, true);
        }
    }
}

